package com.tydic.dyc.ssc.service.scheme;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.model.SscSchemeMatPackExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatListQueryExtBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatListQueryExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatListQueryExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatListPackExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatQueryListExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatQueryListExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatQueryListExtRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：采购方案明细分页查询实现类
 * 时间：2023/07/24
 */
@HTServiceImpl
public class SscSchemeMatQueryListExtServiceImpl implements SscSchemeMatQueryListExtService {

    /**
     * 采购方案明细模型层
     */
    @Autowired
    private SscSchemeMatPackExtModel sscSchemeMatPackExtModel;

    /**
     * 采购方案明细分页查询
     */
    @Override
    public SscSchemeMatQueryListExtRspBO querySchemeMatList(SscSchemeMatQueryListExtReqBO reqBO) {
        //入参转换
        SscSchemeMatListQueryExtReqBO sscSchemeMatListQueryExtReqBO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeMatListQueryExtReqBO.class);

        //调用采购方案明细模型层，采购方案明细分页查询
        SscSchemeMatListQueryExtRspBO sscSchemeMatListQueryExtRspBO = this.sscSchemeMatPackExtModel.querySchemeMatList(sscSchemeMatListQueryExtReqBO);

        //出参转换
        SscSchemeMatQueryListExtRspBO rspBO = JSON.parseObject(JSON.toJSONString(sscSchemeMatListQueryExtRspBO), SscSchemeMatQueryListExtRspBO.class);

        //封装出参数据
        this.packingRspData(sscSchemeMatListQueryExtRspBO, rspBO);

        return rspBO;
    }

    /**
     * 封装出参数据
     */
    private void packingRspData(SscSchemeMatListQueryExtRspBO sscSchemeMatListQueryExtRspBO, SscSchemeMatQueryListExtRspBO rspBO){
        if (!CollectionUtils.isEmpty(sscSchemeMatListQueryExtRspBO.getRows())){
            //出参集合去重
            List<SscSchemeMatQueryListExtBO> sscSchemeMatQueryListExtBOList = rspBO.getRows().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(SscSchemeMatQueryListExtBO::getPackId))), ArrayList::new));
            //设置数据
            rspBO.setRows(sscSchemeMatQueryListExtBOList);

            //获取方案明细Map
            Map<Long, List<SscSchemeMatListQueryExtBO>> sscSchemeMatListQueryExtBOMap = sscSchemeMatListQueryExtRspBO.getRows().stream().collect(Collectors.groupingBy(SscSchemeMatListQueryExtBO::getPackId));

            for (SscSchemeMatQueryListExtBO sscSchemeMatQueryListExtBO : rspBO.getRows()) {
                if (!CollectionUtils.isEmpty(sscSchemeMatListQueryExtBOMap.get(sscSchemeMatQueryListExtBO.getPackId()))){
                    List<SscSchemeMatListPackExtBO> schemeMatListPackExtBOList = JSON.parseArray(JSON.toJSONString(sscSchemeMatListQueryExtBOMap.get(sscSchemeMatQueryListExtBO.getPackId())), SscSchemeMatListPackExtBO.class);
                    sscSchemeMatQueryListExtBO.setSchemeMatListPackExtBOList(schemeMatListPackExtBOList);
                }
            }
        }
    }
}


