package com.tydic.dyc.ssc.service.scheme;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeMatAmountBatchExtExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeMatAmountBatchExtExtRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 描述:采购方案同步包明细批量修改明细字段 (purchaseNum、expectMoney、totalTaxPrice、totalNoTaxPrice)
 *
 * @author XiaWD
 * @date 2023/4/26 19:01
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@HTServiceImpl
public class SscUpdateSchemeMatAmountBatchExtExtServiceImpl implements SscUpdateSchemeMatAmountBatchExtExtService {
    @Autowired
    private SscUpdateSchemeMatAmountBatchExtExtModel sscUpdateSchemeMatAmountBatchExtExtModel;

    @Override
    public SscUpdateSchemeMatAmountBatchExtExtRspBO updateSchemeMatAmountBatchExt(SscUpdateSchemeMatAmountBatchExtExtReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getUpdateMats())){
            throw new ZTBusinessException("入参不能为空");
        }

        return sscUpdateSchemeMatAmountBatchExtExtModel.updateSchemeMatAmountBatchExt(reqBO);
    }
}
