package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.service.scheme.bo.SscEditSchemeExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscEditSchemeExtRspBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;

/**
 * @Description: SscEditSchemeExtServiceImpl
 * @Author: the_xhl
 * @Date: 2023-04-14
 */
@HTServiceImpl
public class SscEditSchemeExtServiceImpl implements SscEditSchemeExtService {

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscEditSchemeExtRspBO editSchemeExt(SscEditSchemeExtReqBO reqBO) {
        SscEditSchemeExtRspBO rspBO = new SscEditSchemeExtRspBO();
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            rspBO.setRespDesc("入参属性[schemeId] 不能为空");
            return rspBO;
        }
        if (ObjectUtil.isNull(reqBO.getFieldCode())) {
            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            rspBO.setRespDesc("入参属性[fieldCode] 不能为空");
            return rspBO;
        }

        SscExtObjInfo extObjInfo = new SscExtObjInfo();
        // 扩展对象类型组装
        extObjInfo.setObjId(reqBO.getSchemeId());
        extObjInfo.setOrderId(reqBO.getSchemeId());
        extObjInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_EXT);
        // 扩展字段组装
        SscExtInfo info = new SscExtInfo();
        info.setFieldCode(reqBO.getFieldCode());
        info.setFieldName(reqBO.getFieldName());
        info.setFieldValue(reqBO.getFieldValue());
        extObjInfo.setExtInfo(Collections.singletonList(info));

        SscCommonDo sscCommonDo = new SscCommonDo();
        sscCommonDo.setExtObjInfos(Collections.singletonList(extObjInfo));
        this.iSscCommonModel.updateExtInfo(sscCommonDo);

        rspBO.setRespDesc(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespCode(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }


}
