package com.tydic.dyc.ssc.service.scheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.qrybo.SscTaskQryBo;
import com.tydic.dyc.ssc.service.scheme.bo.OrderTaskInstBo;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryTaskReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryTaskRspBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题：
 * 说明：
 * 时间：2023/5/5
 *
 * @author：lantian
 **/
@HTServiceImpl
public class SscQryTaskServiceImpl implements SscQryTaskService {
    @Autowired
    private ISscProcInstModel iSscProcInstModel;
    /**
     * 查询上一次处理审批的人
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscQryTaskRspBO qryTask(SscQryTaskReqBO reqBO) {
        SscQryTaskRspBO rspBO = new SscQryTaskRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);

        SscTaskQryBo qryBo = new SscTaskQryBo();
        qryBo.setOrderId(reqBO.getOrderId());
        qryBo.setFinishTag(1);
        SscProcInstDo instDo = iSscProcInstModel.getTaskList(qryBo);
        if (instDo==null){
            return rspBO;
        }
        if (CollectionUtils.isEmpty(instDo.getSscUocOrderTaskInst())){
            return rspBO;
        }
        List<OrderTaskInstBo> sscUocOrderTaskInst = JSONArray.parseArray(JSONObject.toJSONString(instDo.getSscUocOrderTaskInst()),OrderTaskInstBo.class);
        rspBO.setSscUocOrderTaskInst(sscUocOrderTaskInst);
        return rspBO;
    }
}
