package com.tydic.dyc.ssc.service.scheme;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.model.SscSchemeMatPackExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatQryExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatQryExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatQueryExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatQueryExtRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：采购方案明细列表分页查询实现类
 * 时间：2023/08/01
 */
@HTServiceImpl
public class SscSchemeMatQueryExtServiceImpl implements SscSchemeMatQueryExtService {

    /**
     * 采购方案明细模型层
     */
    @Autowired
    private SscSchemeMatPackExtModel sscSchemeMatPackExtModel;

    /**
     * 采购方案明细列表分页查询
     */
    @Override
    public SscSchemeMatQueryExtRspBO querySchemeMatListPage(SscSchemeMatQueryExtReqBO reqBO) {
        //入参转换
        SscSchemeMatQryExtReqBO sscSchemeMatQryExtReqBO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeMatQryExtReqBO.class);

        //调用采购方案明细模型层，采购方案明细列表分页查询
        SscSchemeMatQryExtRspBO sscSchemeMatQryExtRspBO = this.sscSchemeMatPackExtModel.querySchemeMatListPage(sscSchemeMatQryExtReqBO);

        //出参转换
        return JSON.parseObject(JSON.toJSONString(sscSchemeMatQryExtRspBO), SscSchemeMatQueryExtRspBO.class);
    }

}
