package com.tydic.dyc.ssc.model.scheme.impl;

import com.tydic.dyc.ssc.model.SscSchemeRecentMatListQueryModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.repository.SscSchemeRecentMatListQueryRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 说明：查询近期相同物料提交的方案
 * 时间：2024/08/28
 * 作者：曹永吉
 */
@Slf4j
@Service
public class SscSchemeRecentMatListQueryModelImpl implements SscSchemeRecentMatListQueryModel {

    /**
     * 查询近期相同物料提交的方案基建层
     */
    @Autowired
    SscSchemeRecentMatListQueryRepository sscSchemeRecentMatListQueryRepository;

    /**
     * 查询近期相同物料提交的方案
     */
    @Override
    public SscSchemeRecentMatListRspBO querySchemeRecentMatList(SscSchemeRecentMatListReqBO reqBO) {
        return this.sscSchemeRecentMatListQueryRepository.querySchemeRecentMatList(reqBO);
    }
}
