package com.tydic.dyc.ssc.model.scheme.impl;

import com.tydic.dyc.ssc.model.CrcItemQueryExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.CrcItemDbQryListExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.CrcItemDbQryListExtRspBO;
import com.tydic.dyc.ssc.repository.CrcItemQueryExtRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题：询源明细查询模型层接口实现类
 * 时间：2023/08/13
 */
@Slf4j
@Service
public class CrcItemQueryExtModelImpl implements CrcItemQueryExtModel {

    /**
     * 询源明细查询基建层接口
     */
    @Autowired
    CrcItemQueryExtRepository crcItemQueryExtRepository;

    /**
     * 查询询源定标明细数量信息集合
     */
    @Override
    public CrcItemDbQryListExtRspBO getItemDbCountInfoList(CrcItemDbQryListExtReqBO reqBO) {
        //调用询源明细查询基建层接口，查询询源定标明细数量信息集合
        return this.crcItemQueryExtRepository.getItemDbCountInfoList(reqBO);
    }
}
