package com.tydic.dyc.ssc.service.scheme;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.constant.SscRelationStatusEnum;
import com.tydic.dyc.ssc.repository.SscSmartApproveRelationRepository;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApprovePushChangeInfoReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApprovePushChangeInfoRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 智慧评审与采购方案关联
 *
 * @author hsw
 * @since 2024-8-16 11:19:58
 */
@HTServiceImpl
public class SscSmartApproveRelationServiceImpl implements SscSmartApproveRelationService{

    @Resource
    private SscSmartApproveRelationRepository sscSmartApproveRelationRepository;

    /**
     * 智慧评审-简易采购计划关联
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscSmartApproveRelationRspBO dealRelationSimpleScheme(SscSmartApproveRelationReqBO reqBO) {
        // 参数校验
        checkInputSimpleScheme(reqBO);
        return sscSmartApproveRelationRepository.dealRelationSimpleScheme(reqBO);
    }

    /**
     * 智慧评审-方案包关联
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscSmartApproveRelationRspBO dealRelationPack(SscSmartApproveRelationReqBO reqBO) {
        checkInputPack(reqBO);
        return sscSmartApproveRelationRepository.dealRelationPack(reqBO);
    }

    /**
     * 变更审批通过后推送变动信息给智能评审
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscSmartApprovePushChangeInfoRspBO dealPushChangeInfo(SscSmartApprovePushChangeInfoReqBO reqBO) {
        // 参数校验
        if (Objects.isNull(reqBO) || Objects.isNull(reqBO.getSchemeId())) {
            throw new ZTBusinessException("入参不能为空");
        }

        return sscSmartApproveRelationRepository.dealPushChangeInfo(reqBO);
    }

    /**
     * 简易采购方案参数校验
     * @param reqBO
     */
    private void checkInputSimpleScheme(SscSmartApproveRelationReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new ZTBusinessException("入参不能为空");
        }
        if (Objects.isNull(reqBO.getType())) {
            throw new ZTBusinessException("入参关联方式不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getData())) {
            throw new ZTBusinessException("入参数据集不能为空");
        }
        reqBO.getData().forEach( e -> {
            if (Objects.isNull(e.getSchemeId())) {
                throw new ZTBusinessException("入参方案id不能为空");
            }
            if (SscRelationStatusEnum.RELATION.getCode().equals(reqBO.getType())) {
                if (StringUtils.isBlank(e.getFileId())) {
                    throw new ZTBusinessException("入参采购文件id不能为空");
                }
                if (StringUtils.isBlank(e.getFileItemId())) {
                    throw new ZTBusinessException("入参采购文件明细id能为空");
                }
            }
        });
    }

    /**
     * 简易采购方案参数校验
     * @param reqBO
     */
    private void checkInputPack(SscSmartApproveRelationReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new ZTBusinessException("入参不能为空");
        }
        if (Objects.isNull(reqBO.getType())) {
            throw new ZTBusinessException("入参关联方式不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getData())) {
            throw new ZTBusinessException("入参数据集不能为空");
        }
        reqBO.getData().forEach( e -> {
            if (Objects.isNull(e.getPackId())) {
                throw new ZTBusinessException("入参方案包id不能为空");
            }
            if (SscRelationStatusEnum.RELATION.getCode().equals(reqBO.getType())) {
                if (StringUtils.isBlank(e.getFileId())) {
                    throw new ZTBusinessException("入参采购文件id不能为空");
                }
                if (StringUtils.isBlank(e.getFileItemId())) {
                    throw new ZTBusinessException("入参采购文件明细id能为空");
                }
            }
        });
    }
}
