/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.model.SchemeAmountModel;
import com.tydic.dyc.ssc.service.scheme.SchemeAmountService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeGetCanOrderNumAtomRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeAmountReqBO;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SchemeAmountService"})
public class SchemeAmountServiceImpl
implements SchemeAmountService {
    @Autowired
    private SchemeAmountModel schemeAmountModel;

    @PostMapping(value={"updateSchemeOrderAmount"})
    public SscSchemeAmountRspBO updateSchemeOrderAmount(@RequestBody SscSchemeAmountReqBO reqBO) {
        this.verifyScheme(reqBO);
        return this.schemeAmountModel.updateSchemeOrderAmount(reqBO);
    }

    @PostMapping(value={"getCanOrderNum"})
    public SscSchemeGetCanOrderNumAtomRspBO getCanOrderNum(@RequestBody SscSchemeAmountReqBO reqBO) {
        this.verifyQryScheme(reqBO);
        return this.schemeAmountModel.getCanOrderNum(reqBO);
    }

    @PostMapping(value={"updateDdCount"})
    public SscSchemeAmountRspBO updateDdCount(@RequestBody SscUpdateSchemeAmountReqBO reqBO) {
        return this.schemeAmountModel.updateDdCount(reqBO);
    }

    private void verifyScheme(SscSchemeAmountReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderItem())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getOrderItem().forEach(e -> {
            if (StringUtils.isEmpty((Object)e.getOrderNum())) {
                throw new ZTBusinessException("\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)e.getGoodTypeId())) {
                throw new ZTBusinessException("\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)e.getOperateType())) {
                throw new ZTBusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }

    private void verifyQryScheme(SscSchemeAmountReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderItem())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getOrderItem().forEach(e -> {
            if (StringUtils.isEmpty((Object)e.getGoodTypeId())) {
                throw new ZTBusinessException("\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

