package com.tydic.dyc.ssc.constant;

/**
 * The Class RelationStatusEnum.
 *
 * @author husw
 * @since 2024-8-16 15:51:55
 */
public enum SscRelationStatusEnum {
    /**
     * Normal delete yn enum.
     */
    RELATION(1, "关联"),
    /**
     * Delete delete yn enum.
     */
    NOT_RELATION(0, "未关联");

    /**
     * Instantiates a new Delete yn enum.
     *
     * @param code the code
     * @param desc the desc
     */
    SscRelationStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * The Code.
     */
    private Integer code;

    /**
     * The Desc.
     */
    private String desc;

    /**
     * Gets code.
     *
     * @return the code
     */
    public Integer getCode() {
        return code;
    }

    /**
     * Gets desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }

    /**
     * Gets enum.
     *
     * @param code the code
     * @return the enum
     */
    public static SscRelationStatusEnum getEnum(Integer code) {
        for (SscRelationStatusEnum instance : values()) {
            if (instance.getCode().equals(code)) {
                return instance;
            }
        }
        return null;
    }
}
