package com.tydic.dyc.ssc.model.scheme.impl;

import com.tydic.dyc.ssc.model.SchemeAmountModel;
import com.tydic.dyc.ssc.repository.SchemeAmountRepository;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeGetCanOrderNumAtomRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeAmountReqBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 方案物料信息(SscSchemeMat)表数据库访问层
 *
 * @author hcl
 * @since 2023-07-31 15:26:20
 */
@Service
public class SchemeAmountModelImpl implements SchemeAmountModel {
    @Autowired
    private SchemeAmountRepository schemeAmountRepository;

    @Override
    public SscSchemeAmountRspBO updateSchemeOrderAmount(SscSchemeAmountReqBO reqBO) {
        return schemeAmountRepository.updateSchemeOrderAmount(reqBO);
    }

    @Override
    public SscSchemeGetCanOrderNumAtomRspBO getCanOrderNum(SscSchemeAmountReqBO reqBO) {

        return schemeAmountRepository.getCanOrderNum(reqBO);
    }

    @Override
    public SscSchemeAmountRspBO updateDdCount(SscUpdateSchemeAmountReqBO reqBO) {
        return schemeAmountRepository.updateDdCount(reqBO);
    }
}


