package com.tydic.dyc.ssc.service.scheme;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.model.CrcItemQueryExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.CrcItemDbQryExtBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.CrcItemDbQryListExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.CrcItemDbQryListExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.CrcItemDbQueryExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.CrcItemDbQueryListExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.CrcItemDbQueryListExtRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：询源明细查询实现类
 * 时间：2023/08/15
 */
@HTServiceImpl
public class CrcItemQueryExtServiceImpl implements CrcItemQueryExtService {

    /**
     * 询源明细查询模型层接口
     */
    @Autowired
    private CrcItemQueryExtModel crcItemQueryExtModel;

    /**
     * 查询询源定标明细数量信息集合
     */
    @Override
    public CrcItemDbQueryListExtRspBO getItemDbCountInfoList(CrcItemDbQueryListExtReqBO reqBO) {
        //定义出参对象
        CrcItemDbQueryListExtRspBO rspBO = new CrcItemDbQueryListExtRspBO();

        //入参转换
        CrcItemDbQryListExtReqBO crcItemDbQryListExtReqBO = JSON.parseObject(JSON.toJSONString(reqBO), CrcItemDbQryListExtReqBO.class);

        //调用询源明细查询模型层接口，查询询源定标明细数量信息集合
        CrcItemDbQryListExtRspBO crcItemDbQryListExtRspBO = this.crcItemQueryExtModel.getItemDbCountInfoList(crcItemDbQryListExtReqBO);

        //出参转换
        rspBO = JSON.parseObject(JSON.toJSONString(crcItemDbQryListExtRspBO), CrcItemDbQueryListExtRspBO.class);

        //封装出参数据
        this.packingRspData(rspBO, crcItemDbQryListExtRspBO);

        return rspBO;
    }

    /**
     * 封装出参数据
     */
    private void packingRspData(CrcItemDbQueryListExtRspBO rspBO, CrcItemDbQryListExtRspBO crcItemDbQryListExtRspBO){
        //定义询源定标明细查询 BO 集合
        List<CrcItemDbQueryExtBO> crcItemDbQueryExtBOList = new ArrayList<>(10);

        if (!CollectionUtils.isEmpty(crcItemDbQryListExtRspBO.getCrcItemDbExtBOList())){
            //遍历
            for (CrcItemDbQryExtBO bo : crcItemDbQryListExtRspBO.getCrcItemDbExtBOList()) {
                //定义询源定标明细查询 BO
                CrcItemDbQueryExtBO crcItemDbQueryExtBO = new CrcItemDbQueryExtBO();
                //设置明细ID
                crcItemDbQueryExtBO.setGoodTypeId(bo.getItemId());
                //设置可下单数量（合同剩余量）
                crcItemDbQueryExtBO.setOrderNum(bo.getHtRemainingCount());

                //添加集合
                crcItemDbQueryExtBOList.add(crcItemDbQueryExtBO);
            }
        }

        //设置询源定标明细查询 BO 集合
        rspBO.setOrderItem(crcItemDbQueryExtBOList);
    }

}
