package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.ssc.repository.QryPlanPackExtRepository;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import org.bouncycastle.cms.PasswordRecipientId;
import org.springframework.beans.factory.annotation.Autowired;

import com.tydic.dyc.ssc.model.QryPlanPackExtModel;

import lombok.extern.ohaotian.HTServiceImpl;

@HTServiceImpl
public class SscQryPlanPackExtServiceImpl implements SscQryPlanPackExtService{

	@Autowired
	private QryPlanPackExtModel qryPlanPackExtModel;

	@Autowired
	private QryPlanPackExtRepository qryPlanPackExtRepository;

	@Override
	public SscQryPlanPackExtRspBO qryPlanPack(SscQryPlanPackExtReqBO reqBO) {
		return qryPlanPackExtModel.selectPlanPack(reqBO);
	}

	@Override
	public SscPurchaseSourcingRspBO qrySchemePackSourcing(SscPurchaseSourcingReqBO reqBO) {
		return qryPlanPackExtModel.qrySchemePackSourcing(reqBO);
	}

	@Override
	public SscPurchaseSourcingRspBO qrySchemePackSourcingTime(SscPurchaseSourcingReqBO reqBO) {
		return qryPlanPackExtModel.qrySchemePackSourcingTime(reqBO);
	}

	@Override
	public SscPurchasingPlanArgumentRspBO qrySchemePurchasingPlanArgument(SscPurchasingPlanArgumentReqBO reqBO) {
		return qryPlanPackExtRepository.qrySchemePurchasingPlanArgument(reqBO);
	}

}
