package com.tydic.dyc.ssc.service.scheme;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.model.SscSchemeMatListCrcResultExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatCrcResultListExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatCrcResultListExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatListCrcResultExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatListCrcResultExtRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：采购方案询源结果列表查询实现类
 * 时间：2023/08/14
 */
@HTServiceImpl
public class SscSchemeMatListCrcResultExtServiceImpl implements SscSchemeMatListCrcResultExtService {

    /**
     * 采购方案询源结果列表模型层接口
     */
    @Autowired
    private SscSchemeMatListCrcResultExtModel sscSchemeMatListCrcResultExtModel;

    /**
     * 通过询源结果查询采购方案明细列表
     */
    @Override
    public SscSchemeMatListCrcResultExtRspBO getSchemeMatListByCrcResult(SscSchemeMatListCrcResultExtReqBO reqBO) {
        //入参转换
        SscSchemeMatCrcResultListExtReqBO sscSchemeMatCrcResultListExtReqBO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeMatCrcResultListExtReqBO.class);

        //调用采购方案询比结果列表模型层接口，通过询比结果查询采购方案明细列表
        SscSchemeMatCrcResultListExtRspBO sscSchemeMatCrcResultListExtRspBO = this.sscSchemeMatListCrcResultExtModel.getSchemeMatListByCrcResult(sscSchemeMatCrcResultListExtReqBO);

        //出参转换
        return JSON.parseObject(JSON.toJSONString(sscSchemeMatCrcResultListExtRspBO), SscSchemeMatListCrcResultExtRspBO.class);
    }
}
