package com.tydic.dyc.ssc.service.scheme;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.SscSchemeMatPackExtModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatQryExtReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMatQryExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatListReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatQueryExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatQueryExtRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 标题：采购方案明细列表分页查询实现类
 * 时间：2023/08/01
 */
@HTServiceImpl
public class SscSchemeMatQueryExtServiceImpl implements SscSchemeMatQueryExtService {

    /**
     * 采购方案明细模型层
     */
    @Autowired
    private SscSchemeMatPackExtModel sscSchemeMatPackExtModel;

    /**
     * 采购方案明细列表分页查询
     */
    @Override
    public SscSchemeMatQueryExtRspBO querySchemeMatListPage(SscSchemeMatQueryExtReqBO reqBO) {
        //入参转换
        SscSchemeMatQryExtReqBO sscSchemeMatQryExtReqBO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeMatQryExtReqBO.class);

        //调用采购方案明细模型层，采购方案明细列表分页查询
        SscSchemeMatQryExtRspBO sscSchemeMatQryExtRspBO = this.sscSchemeMatPackExtModel.querySchemeMatListPage(sscSchemeMatQryExtReqBO);

        //出参转换
        return JSON.parseObject(JSON.toJSONString(sscSchemeMatQryExtRspBO), SscSchemeMatQueryExtRspBO.class);
    }

    /**
     * 查看方案物料明细
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscSchemeMatListRspBO getSchemeMatList(SscSchemeMatListReqBO reqBO) {
        if (Objects.isNull(reqBO) || CollectionUtils.isEmpty(reqBO.getSchemeIds())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参方案ID集合不能为空！");
        }
        return sscSchemeMatPackExtModel.getSchemeMatList(reqBO);
    }

}
