package com.tydic.dyc.ssc.service.scheme;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.model.SscSchemeMatPackExtModel;
import com.tydic.dyc.ssc.model.SscSchemeRecentMatListQueryModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 说明：查询近期相同物料提交的方案
 * 时间：2024/08/28
 * 作者：曹永吉
 */
@Slf4j
@HTServiceImpl
public class SscSchemeRecentMatListQueryServiceImpl implements SscSchemeRecentMatListQueryService {

    /**
     * 查询近期相同物料提交的方案
     */
    @Autowired
    private SscSchemeRecentMatListQueryModel sscSchemeRecentMatListQueryModel;

    /**
     * 采购方案明细分页查询
     */
    @Override
    public SscSchemeRecentMatListQueryRspBO querySchemeRecentMatList(SscSchemeRecentMatListQueryReqBO reqBO) {
        //入参转换
        SscSchemeRecentMatListReqBO sscSchemeRecentMatListReqBO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeRecentMatListReqBO.class);

        //查询近期相同物料提交的方案
        SscSchemeRecentMatListRspBO sscSchemeRecentMatListRspBO = this.sscSchemeRecentMatListQueryModel.querySchemeRecentMatList(sscSchemeRecentMatListReqBO);
        //出参转换
        SscSchemeRecentMatListQueryRspBO rspBO = JSON.parseObject(JSON.toJSONString(sscSchemeRecentMatListRspBO), SscSchemeRecentMatListQueryRspBO.class);
        return rspBO;
    }
}


