/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.constant.SscRelationStatusEnum;
import com.tydic.dyc.ssc.repository.SscSmartApproveRelationRepository;
import com.tydic.dyc.ssc.service.scheme.SscSmartApproveRelationService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApprovePushChangeInfoReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApprovePushChangeInfoRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationRspBO;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscSmartApproveRelationService"})
public class SscSmartApproveRelationServiceImpl
implements SscSmartApproveRelationService {
    @Resource
    private SscSmartApproveRelationRepository sscSmartApproveRelationRepository;

    @PostMapping(value={"dealRelationSimpleScheme"})
    public SscSmartApproveRelationRspBO dealRelationSimpleScheme(@RequestBody SscSmartApproveRelationReqBO reqBO) {
        this.checkInputSimpleScheme(reqBO);
        return this.sscSmartApproveRelationRepository.dealRelationSimpleScheme(reqBO);
    }

    @PostMapping(value={"dealRelationPack"})
    public SscSmartApproveRelationRspBO dealRelationPack(@RequestBody SscSmartApproveRelationReqBO reqBO) {
        this.checkInputPack(reqBO);
        return this.sscSmartApproveRelationRepository.dealRelationPack(reqBO);
    }

    @PostMapping(value={"dealPushChangeInfo"})
    public SscSmartApprovePushChangeInfoRspBO dealPushChangeInfo(@RequestBody SscSmartApprovePushChangeInfoReqBO reqBO) {
        if (Objects.isNull(reqBO) || Objects.isNull(reqBO.getSchemeId())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sscSmartApproveRelationRepository.dealPushChangeInfo(reqBO);
    }

    private void checkInputSimpleScheme(SscSmartApproveRelationReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getType())) {
            throw new ZTBusinessException("\u5165\u53c2\u5173\u8054\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getData())) {
            throw new ZTBusinessException("\u5165\u53c2\u6570\u636e\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getData().forEach(e -> {
            if (Objects.isNull(e.getSchemeId())) {
                throw new ZTBusinessException("\u5165\u53c2\u65b9\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (SscRelationStatusEnum.RELATION.getCode().equals(reqBO.getType())) {
                if (StringUtils.isBlank((CharSequence)e.getFileId())) {
                    throw new ZTBusinessException("\u5165\u53c2\u91c7\u8d2d\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)e.getFileItemId())) {
                    throw new ZTBusinessException("\u5165\u53c2\u91c7\u8d2d\u6587\u4ef6\u660e\u7ec6id\u80fd\u4e3a\u7a7a");
                }
            }
        });
    }

    private void checkInputPack(SscSmartApproveRelationReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getType())) {
            throw new ZTBusinessException("\u5165\u53c2\u5173\u8054\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getData())) {
            throw new ZTBusinessException("\u5165\u53c2\u6570\u636e\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getData().forEach(e -> {
            if (Objects.isNull(e.getPackId())) {
                throw new ZTBusinessException("\u5165\u53c2\u65b9\u6848\u5305id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (SscRelationStatusEnum.RELATION.getCode().equals(reqBO.getType())) {
                if (StringUtils.isBlank((CharSequence)e.getFileId())) {
                    throw new ZTBusinessException("\u5165\u53c2\u91c7\u8d2d\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)e.getFileItemId())) {
                    throw new ZTBusinessException("\u5165\u53c2\u91c7\u8d2d\u6587\u4ef6\u660e\u7ec6id\u80fd\u4e3a\u7a7a");
                }
            }
        });
    }
}

