/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repositoryExt.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.repository.SchemeAmountRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.CrcItemPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeMatNumMapper;
import com.tydic.dyc.ssc.repositoryExt.po.CrcItemPackExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeMatNum;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeGetCanOrderNumAtomRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeAmountBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeAmountReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SchemeAmountRepositoryImpl
implements SchemeAmountRepository {
    private static final Logger log = LoggerFactory.getLogger(SchemeAmountRepositoryImpl.class);
    @Autowired
    private SscSchemeMatNumMapper sscSchemeMatNumMapper;
    @Autowired
    private CrcItemPackExtMapper crcItemPackExtMapper;
    private final Integer TYPE_CONTRACT_AMOUNT = 0;
    private final Integer TYPE_ORDER_AMOUNT = 1;

    public SscSchemeAmountRspBO updateDdCount(SscUpdateSchemeAmountReqBO reqBO) {
        log.info("updateDdCount reqBO:{}", (Object)JSON.toJSONString((Object)reqBO));
        this.checkParam(reqBO);
        SscSchemeAmountRspBO rspBO = new SscSchemeAmountRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Map<Integer, List<SscUpdateSchemeAmountBO>> requestParam = reqBO.getReqBOs().stream().collect(Collectors.groupingBy(SscUpdateSchemeAmountBO::getType));
        try {
            block6: for (Integer key : requestParam.keySet()) {
                switch (key) {
                    case 1: {
                        List<SscUpdateSchemeAmountBO> zixingList;
                        List<SscUpdateSchemeAmountBO> xunbiList = requestParam.get(key);
                        List<SscUpdateSchemeAmountBO> weituoList = xunbiList.stream().filter($ -> $.getQueryType() == 2).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(weituoList)) {
                            List<Long> ids = weituoList.stream().map(SscUpdateSchemeAmountBO::getId).collect(Collectors.toList());
                            List<CrcItemPackExtPO> crcItemPackExtPOS = this.listWeiTuoList(ids);
                            String checkStr = this.CheckCount(weituoList, crcItemPackExtPOS, "\u59d4\u6258\u91c7\u8d2d\u660e\u7ec6\u53d8\u66f4");
                            if (!StringUtils.isEmpty((Object)checkStr)) {
                                rspBO.setRespCode("8888");
                                rspBO.setRespDesc(checkStr);
                                return rspBO;
                            }
                            this.updateWeiTuo(weituoList, crcItemPackExtPOS);
                        }
                        if (CollectionUtils.isEmpty(zixingList = xunbiList.stream().filter($ -> $.getQueryType() == 3).collect(Collectors.toList()))) continue block6;
                        List<Long> ids = zixingList.stream().map(SscUpdateSchemeAmountBO::getId).collect(Collectors.toList());
                        List<CrcItemPackExtPO> crcItemPackExtPOS = this.listzixingList(ids);
                        String checkStr = this.CheckCount(zixingList, crcItemPackExtPOS, "\u81ea\u884c\u91c7\u8d2d\u660e\u7ec6\u53d8\u66f4");
                        if (!StringUtils.isEmpty((Object)checkStr)) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc(checkStr);
                            return rspBO;
                        }
                        this.updateZixing(zixingList, crcItemPackExtPOS);
                        continue block6;
                    }
                    case 2: {
                        List<SscUpdateSchemeAmountBO> dingbiaoList = requestParam.get(key);
                        if (CollectionUtils.isEmpty(dingbiaoList)) continue block6;
                        List<Long> ids = dingbiaoList.stream().map(SscUpdateSchemeAmountBO::getId).collect(Collectors.toList());
                        List<CrcItemPackExtPO> crcItemPackExtPOS = this.listWeiTuoList(ids);
                        String checkStr = this.CheckCount(dingbiaoList, crcItemPackExtPOS, "\u5b9a\u6807\u91c7\u8d2d\u660e\u7ec6\u53d8\u66f4");
                        if (!StringUtils.isEmpty((Object)checkStr)) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc(checkStr);
                            return rspBO;
                        }
                        this.updateWeiTuo(dingbiaoList, crcItemPackExtPOS);
                        continue block6;
                    }
                }
                throw new RuntimeException("\u672a\u77e5\u7684\u660e\u7ec6\u7c7b\u578b");
            }
        }
        catch (Exception e) {
            log.error("updateDdCount error:{}", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }

    @Transactional
    public void updateZixing(List<SscUpdateSchemeAmountBO> weituoList, List<CrcItemPackExtPO> crcItemPackExtPOS) {
        Map<String, List<CrcItemPackExtPO>> collect = crcItemPackExtPOS.stream().collect(Collectors.groupingBy(CrcItemPackExtPO::getItemId));
        List<CrcItemPackExtPO> collect1 = weituoList.stream().map($ -> {
            List crcItemPackExtPOS1 = (List)collect.get($.getId().toString());
            CrcItemPackExtPO crcItemPackExtPO = new CrcItemPackExtPO();
            if (!CollectionUtils.isEmpty((Collection)crcItemPackExtPOS1)) {
                CrcItemPackExtPO crcItemPackExtPO1 = (CrcItemPackExtPO)crcItemPackExtPOS1.get(0);
                BigDecimal ddCount = crcItemPackExtPO1.getDdCount();
                crcItemPackExtPO.setDdCount(1 == $.getOperateType() ? ddCount.add($.getOrderNum()) : ddCount.subtract($.getOrderNum()));
                crcItemPackExtPO.setItemId($.getId().toString());
            }
            return crcItemPackExtPO;
        }).filter($ -> Objects.nonNull($.getItemId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect1)) {
            log.info("updateZixing param :{}", (Object)JSON.toJSONString(collect1));
            this.sscSchemeMatNumMapper.batchUpdateZx(collect1);
        }
    }

    @Transactional
    public void updateWeiTuo(List<SscUpdateSchemeAmountBO> weituoList, List<CrcItemPackExtPO> crcItemPackExtPOS) {
        Map<String, List<CrcItemPackExtPO>> collect = crcItemPackExtPOS.stream().collect(Collectors.groupingBy(CrcItemPackExtPO::getItemId));
        List<CrcItemPackExtPO> collect1 = weituoList.stream().map($ -> {
            List crcItemPackExtPOS1 = (List)collect.get($.getId().toString());
            CrcItemPackExtPO crcItemPackExtPO = new CrcItemPackExtPO();
            if (!CollectionUtils.isEmpty((Collection)crcItemPackExtPOS1)) {
                CrcItemPackExtPO crcItemPackExtPO1 = (CrcItemPackExtPO)crcItemPackExtPOS1.get(0);
                BigDecimal ddCount = crcItemPackExtPO1.getDdCount();
                crcItemPackExtPO.setDdCount(1 == $.getOperateType() ? ddCount.add($.getOrderNum()) : ddCount.subtract($.getOrderNum()));
                crcItemPackExtPO.setItemId($.getId().toString());
            }
            return crcItemPackExtPO;
        }).filter($ -> Objects.nonNull($.getItemId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect1)) {
            log.info("updateWeiTuo param :{}", (Object)JSON.toJSONString(collect1));
            this.sscSchemeMatNumMapper.batchUpdateWt(collect1);
        }
    }

    private String CheckCount(List<SscUpdateSchemeAmountBO> list, List<CrcItemPackExtPO> crcItemPackExtPOS, String message) {
        if (CollectionUtils.isEmpty(crcItemPackExtPOS)) {
            return message + "\u672a\u67e5\u8be2\u5230" + message + "\u5217\u8868";
        }
        Map<String, List<CrcItemPackExtPO>> collect = crcItemPackExtPOS.stream().collect(Collectors.groupingBy(CrcItemPackExtPO::getItemId));
        for (int i = 0; i < list.size(); ++i) {
            SscUpdateSchemeAmountBO sscUpdateSchemeAmountBO = list.get(i);
            List<CrcItemPackExtPO> crcItemPackExtPOS1 = collect.get(sscUpdateSchemeAmountBO.getId().toString());
            if (CollectionUtils.isEmpty(crcItemPackExtPOS1)) continue;
            CrcItemPackExtPO crcItemPackExtPO = crcItemPackExtPOS1.get(0);
            BigDecimal ddCount = crcItemPackExtPO.getDdCount();
            BigDecimal purchaseCount = crcItemPackExtPO.getPurchaseCount();
            BigDecimal orderNum = sscUpdateSchemeAmountBO.getOrderNum();
            if (sscUpdateSchemeAmountBO.getOperateType() == 0) {
                if (Objects.isNull(ddCount) || ddCount.compareTo(BigDecimal.ZERO) == 0) {
                    return message + "\uff1a\u51cf\u5c11\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u4f7f\u7528\u6570\u91cf";
                }
                if (ddCount.subtract(orderNum).compareTo(BigDecimal.ZERO) < 0) {
                    return message + "\uff1a\u51cf\u5c11\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u4f7f\u7528\u6570\u91cf";
                }
                if (purchaseCount.subtract(orderNum).compareTo(BigDecimal.ZERO) >= 0) continue;
                return message + "\uff1a\u51cf\u5c11\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u4e2d\u6807\u6570\u91cf";
            }
            if (sscUpdateSchemeAmountBO.getOperateType() != 1) continue;
            if (purchaseCount.subtract(orderNum).compareTo(BigDecimal.ZERO) < 0) {
                return message + "\uff1a\u51cf\u5c11\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u4e2d\u6807\u6570\u91cf";
            }
            if (purchaseCount.subtract(orderNum.add(ddCount)).compareTo(BigDecimal.ZERO) >= 0) continue;
            return message + "\uff1a\u51cf\u5c11\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e(\u4e2d\u6807\u6570\u91cf-\u4f7f\u7528\u6570\u91cf)";
        }
        return null;
    }

    private List<CrcItemPackExtPO> listzixingList(List<Long> ids) {
        CrcItemPackExtPO crcItemPackExtPO = new CrcItemPackExtPO();
        List longs = JSON.parseArray((String)JSON.toJSONString(ids), String.class);
        crcItemPackExtPO.setItemIds(longs);
        return this.crcItemPackExtMapper.getInquiryItemDbCountInfoList(crcItemPackExtPO);
    }

    private List<CrcItemPackExtPO> listWeiTuoList(List<Long> ids) {
        CrcItemPackExtPO crcItemPackExtPO = new CrcItemPackExtPO();
        List longs = JSON.parseArray((String)JSON.toJSONString(ids), String.class);
        crcItemPackExtPO.setItemIds(longs);
        return this.crcItemPackExtMapper.getEntrustItemDbCountInfoList(crcItemPackExtPO);
    }

    private void checkParam(SscUpdateSchemeAmountReqBO reqBO) {
        Assert.notNull((Object)reqBO, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)reqBO.getReqBOs(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        for (int i = 0; i < reqBO.getReqBOs().size(); ++i) {
            SscUpdateSchemeAmountBO sscUpdateSchemeAmountBO = (SscUpdateSchemeAmountBO)reqBO.getReqBOs().get(i);
            Assert.notNull((Object)sscUpdateSchemeAmountBO.getId(), (String)"\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.notNull((Object)sscUpdateSchemeAmountBO.getType(), (String)"\u660e\u7ec6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            if (sscUpdateSchemeAmountBO.getType() == 1) {
                Assert.notNull((Object)sscUpdateSchemeAmountBO.getQueryType(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Assert.notNull((Object)sscUpdateSchemeAmountBO.getOperateType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public SscSchemeAmountRspBO updateSchemeOrderAmount(SscSchemeAmountReqBO reqBO) {
        SscSchemeAmountRspBO rspBO = new SscSchemeAmountRspBO();
        List<String> schemeMatIds = reqBO.getOrderItem().stream().map(SscSchemeAmountBO::getGoodTypeId).collect(Collectors.toList());
        List<SscSchemeMatNum> updateVerify = this.sscSchemeMatNumMapper.queryAllByschemeMatIds(schemeMatIds);
        Map<String, SscSchemeAmountBO> sscSchemeAmountBOMap = reqBO.getOrderItem().stream().collect(Collectors.toMap(SscSchemeAmountBO::getGoodTypeId, i -> i));
        if (!CollectionUtils.isEmpty(updateVerify)) {
            for (SscSchemeMatNum sscSchemeMatNum : updateVerify) {
                SscSchemeAmountBO sscSchemeAmountBO = sscSchemeAmountBOMap.get(String.valueOf(sscSchemeMatNum.getSchemeMatId()));
                if (reqBO.getTypeAmount().equals(0)) {
                    if (sscSchemeAmountBO.getOperateType() == 1) {
                        sscSchemeMatNum.setContractAmount(sscSchemeMatNum.getContractAmount().subtract(sscSchemeAmountBO.getOrderNum()));
                    } else {
                        sscSchemeMatNum.setContractAmount(sscSchemeMatNum.getContractAmount().add(sscSchemeAmountBO.getOrderNum()));
                        if (sscSchemeAmountBO.getOrderNum().compareTo(sscSchemeMatNum.getContractAmountY()) > 0) {
                            rspBO.setRespDesc("8888");
                            rspBO.setRespCode("\u9000\u56de\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u4f7f\u7528\u91cf");
                            return rspBO;
                        }
                    }
                    if (sscSchemeMatNum.getOrderAmountY() != null && sscSchemeMatNum.getOrderAmountY().compareTo(BigDecimal.ZERO) > 0) {
                        rspBO.setRespDesc("8888");
                        rspBO.setRespCode("\u5408\u540c\u6216\u8005\u8ba2\u5355\u53ea\u80fd\u5b58\u5728\u4e00\u79cd");
                        return rspBO;
                    }
                } else {
                    if (sscSchemeAmountBO.getOperateType() == 1) {
                        sscSchemeMatNum.setOrderAmount(sscSchemeMatNum.getOrderAmount().subtract(sscSchemeAmountBO.getOrderNum()));
                    } else {
                        sscSchemeMatNum.setOrderAmount(sscSchemeMatNum.getOrderAmount().add(sscSchemeAmountBO.getOrderNum()));
                        if (sscSchemeAmountBO.getOrderNum().compareTo(sscSchemeMatNum.getOrderAmountY()) > 0) {
                            rspBO.setRespDesc("8888");
                            rspBO.setRespCode("\u9000\u56de\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u4f7f\u7528\u91cf");
                            return rspBO;
                        }
                    }
                    if (sscSchemeMatNum.getContractAmountY() != null && sscSchemeMatNum.getContractAmountY().compareTo(BigDecimal.ZERO) > 0) {
                        rspBO.setRespDesc("8888");
                        rspBO.setRespCode("\u5408\u540c\u6216\u8005\u8ba2\u5355\u53ea\u80fd\u5b58\u5728\u4e00\u79cd");
                        return rspBO;
                    }
                }
                if (-1 == sscSchemeMatNum.getOrderAmount().compareTo(BigDecimal.ZERO)) {
                    rspBO.setRespDesc("8888");
                    rspBO.setRespCode("\u65b9\u6848\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
                    return rspBO;
                }
                if (-1 != sscSchemeMatNum.getContractAmount().compareTo(BigDecimal.ZERO)) continue;
                rspBO.setRespDesc("8888");
                rspBO.setRespCode("\u65b9\u6848\u5269\u4f59\u6570\u91cf\u4e0d\u8db3");
                return rspBO;
            }
        }
        ArrayList<SscSchemeMatNum> inserLists = new ArrayList<SscSchemeMatNum>();
        List bos = reqBO.getOrderItem();
        List<SscSchemeMatNum> sscSchemeMats = this.sscSchemeMatNumMapper.queryAllIsNullByschemeMatIds(schemeMatIds);
        Map<Long, SscSchemeMatNum> sscSchemeMatNumMap = sscSchemeMats.stream().collect(Collectors.toMap(a -> a.getSchemeMatId(), b -> b));
        for (SscSchemeAmountBO bo : bos) {
            SscSchemeMatNum sscSchemeMatNum = null;
            if (ObjectUtil.isNotEmpty(sscSchemeMatNumMap)) {
                sscSchemeMatNum = sscSchemeMatNumMap.get(Convert.toLong((Object)bo.getGoodTypeId()));
            }
            SscSchemeMatNum update = new SscSchemeMatNum();
            update.setSchemeMatId(Convert.toLong((Object)bo.getGoodTypeId()));
            if (ObjectUtil.isNotEmpty((Object)sscSchemeMatNum)) {
                this.setSscSchemeMatNumMapper(reqBO.getTypeAmount(), bo, update, sscSchemeMatNum);
                this.sscSchemeMatNumMapper.update(update);
                continue;
            }
            if (reqBO.getTypeAmount().equals(this.TYPE_CONTRACT_AMOUNT)) {
                update.setContractAmount(bo.getOrderNum());
            } else if (reqBO.getTypeAmount().equals(this.TYPE_ORDER_AMOUNT)) {
                update.setOrderAmount(bo.getOrderNum());
            }
            inserLists.add(update);
        }
        if (!CollectionUtils.isEmpty(inserLists)) {
            this.sscSchemeMatNumMapper.insertBatch(inserLists);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    public SscSchemeGetCanOrderNumAtomRspBO getCanOrderNum(SscSchemeAmountReqBO reqBO) {
        SscSchemeGetCanOrderNumAtomRspBO rspBO = new SscSchemeGetCanOrderNumAtomRspBO();
        ArrayList respList = new ArrayList();
        List bos = reqBO.getOrderItem();
        List<String> collect = bos.stream().map(SscSchemeAmountBO::getGoodTypeId).collect(Collectors.toList());
        List<SscSchemeMatNum> sscSchemeMatNums = this.sscSchemeMatNumMapper.queryAllByschemeMatIds(collect);
        sscSchemeMatNums.forEach(e -> {
            SscSchemeAmountBO sscSchemeAmountBO = new SscSchemeAmountBO();
            sscSchemeAmountBO.setGoodTypeId(Convert.toStr((Object)e.getSchemeMatId()));
            if (reqBO.getTypeAmount().equals(0)) {
                sscSchemeAmountBO.setOrderNum(e.getContractAmount());
            } else if (reqBO.getTypeAmount().equals(1)) {
                sscSchemeAmountBO.setOrderNum(e.getOrderAmount());
            }
            respList.add(sscSchemeAmountBO);
        });
        if (!CollectionUtils.isEmpty(respList)) {
            rspBO.setOrderItem(respList);
        } else {
            rspBO.setOrderItem(new ArrayList());
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void setSscSchemeMatNumMapper(Integer type, SscSchemeAmountBO sscSchemeAmountBO, SscSchemeMatNum update, SscSchemeMatNum sscSchemeMat) {
        if (type.equals(0)) {
            if (sscSchemeAmountBO.getOperateType().equals(1)) {
                update.setContractAmount(NumberUtil.add((Number)sscSchemeMat.getContractAmount(), (Number)sscSchemeAmountBO.getOrderNum()));
            } else if (sscSchemeAmountBO.getOperateType().equals(0)) {
                update.setContractAmount(NumberUtil.sub((Number)sscSchemeMat.getContractAmount(), (Number)sscSchemeAmountBO.getOrderNum()));
            }
        } else if (type.equals(1)) {
            if (sscSchemeAmountBO.getOperateType().equals(1)) {
                update.setOrderAmount(NumberUtil.add((Number)sscSchemeMat.getOrderAmount(), (Number)sscSchemeAmountBO.getOrderNum()));
            } else if (sscSchemeAmountBO.getOperateType().equals(0)) {
                update.setOrderAmount(NumberUtil.sub((Number)sscSchemeMat.getOrderAmount(), (Number)sscSchemeAmountBO.getOrderNum()));
            }
        }
    }
}

