package com.tydic.dyc.ssc.repositoryExt.dao;

import com.tydic.dyc.ssc.repositoryExt.po.CrcItemPackExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeMatNum;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 方案物料信息(SscSchemeMatNum)表数据库访问层
 *
 * @author hcl
 * @since 2023-07-31 17:32:03
 */
@Mapper
@Repository
public interface SscSchemeMatNumMapper {

    /**
     * 通过ID查询单条数据
     *
     * @param schemeMatId 主键
     * @return 实例对象
     */
    SscSchemeMatNum queryById();

    /**
     * 查询指定行数据
     *
     * @param offset 查询起始位置
     * @param limit  查询条数
     * @return 对象列表
     */
    List<SscSchemeMatNum> queryAllByLimit(@Param("offset") int offset, @Param("limit") int limit);


    /**
     * 通过实体作为筛选条件查询
     *
     * @param sscSchemeMatNum 实例对象
     * @return 对象列表
     */
    List<SscSchemeMatNum> queryAll(SscSchemeMatNum sscSchemeMatNum);

    /**
     * 新增数据
     *
     * @param sscSchemeMatNum 实例对象
     * @return 影响行数
     */
    int insert(SscSchemeMatNum sscSchemeMatNum);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<SscSchemeMatNum> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<SscSchemeMatNum> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<SscSchemeMatNum> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<SscSchemeMatNum> entities);

    /**
     * 修改数据
     *
     * @param sscSchemeMatNum 实例对象
     * @return 影响行数
     */
    int update(SscSchemeMatNum sscSchemeMatNum);

    int batchUpdateWt(@Param("list") List<CrcItemPackExtPO> list);
    int batchUpdateZx(@Param("list") List<CrcItemPackExtPO> list);

    /**
     * 通过主键删除数据
     *
     * @param schemeMatId 主键
     * @return 影响行数
     */
    int deleteById(Long schemeMatId);

    List<SscSchemeMatNum> queryAllByschemeMatIds(@Param("schemeMatIds") List<String> schemeMatIds);

    List<SscSchemeMatNum> queryAllIsNullByschemeMatIds(@Param("schemeMatIds")List<String> schemeMatIds);
}

