package com.tydic.dyc.ssc.repositoryExt.impl;

import com.tydic.dyc.ssc.repository.QrySchemeServiceRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.PlatFormSscSchemeMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryPlanPackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoExtBO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @Author jmrg
 * @dATE 2023/7/25
 * @Desc
 */
@Service
public class QrySchemeServiceRepositoryImpl implements QrySchemeServiceRepository {

    @Autowired
    private PlatFormSscSchemeMapper sscSchemeMapper;

    @Override
    public List<SscQryPlanPackBO> listByParam(SscQrySchemeMainInfoExtBO param) {
        return converterList(sscSchemeMapper.listByParam(param));
    }

    private List<SscQryPlanPackBO> converterList(List<SscSchemePO> list){
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        List<SscQryPlanPackBO> resultList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            SscSchemePO sscSchemePO = list.get(i);
            SscQryPlanPackBO sscQryPlanPackBO = new SscQryPlanPackBO();
            BeanUtils.copyProperties(sscSchemePO,sscQryPlanPackBO);
            sscQryPlanPackBO.setSchemeClass(Objects.isNull(sscSchemePO.getSchemeClass())?null:sscSchemePO.getSchemeClass().toString());
            sscQryPlanPackBO.setCreateCompanCode(sscSchemePO.getCreateCompanyCode());
            sscQryPlanPackBO.setEmergencyFlag(Objects.isNull(sscSchemePO.getEmergencyFlag())?null:sscSchemePO.getEmergencyFlag().toString());
            sscQryPlanPackBO.setEstAmount(Objects.isNull(sscSchemePO.getEstAmount())?null:sscSchemePO.getEstAmount().toString());
            sscQryPlanPackBO.setImportFlag(Objects.isNull(sscSchemePO.getImportFlag())?null:sscSchemePO.getImportFlag().toString());
            resultList.add(sscQryPlanPackBO);
        }
        return resultList;
    }
}
