package com.tydic.dyc.ssc.repositoryExt.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.repository.SchemeAmountRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.CrcItemPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeMatNumMapper;
import com.tydic.dyc.ssc.repositoryExt.po.CrcItemPackExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeMatNum;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 方案物料信息(SscSchemeMat)表数据库访问层
 *
 * @author hcl
 * @since 2023-07-31 15:26:20
 */
@Service
@Slf4j
public class SchemeAmountRepositoryImpl implements SchemeAmountRepository {


    @Autowired
    private SscSchemeMatNumMapper sscSchemeMatNumMapper;
    @Autowired
    private CrcItemPackExtMapper crcItemPackExtMapper;
    /**
     * 合同类型
     */
    private final Integer TYPE_CONTRACT_AMOUNT = 0;
    /**
     * 订单类型
     */
    private final Integer TYPE_ORDER_AMOUNT = 1;

    @Override
    public SscSchemeAmountRspBO updateDdCount(SscUpdateSchemeAmountReqBO reqBO) {
        log.info("updateDdCount reqBO:{}",JSON.toJSONString(reqBO));
        checkParam(reqBO);
        SscSchemeAmountRspBO rspBO = new SscSchemeAmountRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);

        Map<Integer, List<SscUpdateSchemeAmountBO>> requestParam = reqBO.getReqBOs()
                .stream()
                .collect(Collectors.groupingBy(SscUpdateSchemeAmountBO::getType));

        try{
            for(Integer key : requestParam.keySet()){
                switch (key){
                    case 1:
                        List<SscUpdateSchemeAmountBO> xunbiList = requestParam.get(key);
                        //询比结果 - 委托采购
                        List<SscUpdateSchemeAmountBO> weituoList = xunbiList.stream()
                                .filter(
                                        $ -> {
                                            return $.getQueryType() == 2;
                                        })
                                .collect(Collectors.toList());
                        if(!CollectionUtils.isEmpty(weituoList)){
                            List<Long> ids = weituoList.stream().map(SscUpdateSchemeAmountBO::getId).collect(Collectors.toList());
                            //获取委托采购明细
                            List<CrcItemPackExtPO> crcItemPackExtPOS = listWeiTuoList(ids);
                            //校验数量
                            String checkStr = CheckCount(weituoList, crcItemPackExtPOS,"委托采购明细变更");
                            if(!StringUtils.isEmpty(checkStr)){
                                rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                                rspBO.setRespDesc(checkStr);
                                return rspBO;
                            }
                            //变更委托采购数量
                            updateWeiTuo(weituoList, crcItemPackExtPOS);
                        }
                        //询比结果 - 自行采购
                        List<SscUpdateSchemeAmountBO> zixingList = xunbiList.stream()
                                .filter(
                                        $ -> {
                                            return $.getQueryType() == 3;
                                        })
                                .collect(Collectors.toList());
                        if(!CollectionUtils.isEmpty(zixingList)){
                            List<Long> ids = zixingList.stream().map(SscUpdateSchemeAmountBO::getId).collect(Collectors.toList());
                            //获取自行采购明细
                            List<CrcItemPackExtPO> crcItemPackExtPOS = listzixingList(ids);
                            //校验数量
                            String checkStr = CheckCount(zixingList, crcItemPackExtPOS,"自行采购明细变更");
                            if(!StringUtils.isEmpty(checkStr)){
                                rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                                rspBO.setRespDesc(checkStr);
                                return rspBO;
                            }
                            //变更自行采购数量
                            updateZixing(zixingList, crcItemPackExtPOS);
                        }
                        break;
                    case 2:
                        //定标报告
                        List<SscUpdateSchemeAmountBO> dingbiaoList = requestParam.get(key);
                        if(!CollectionUtils.isEmpty(dingbiaoList)){
                            List<Long> ids = dingbiaoList.stream().map(SscUpdateSchemeAmountBO::getId).collect(Collectors.toList());
                            //获取定标采购明细
                            List<CrcItemPackExtPO> crcItemPackExtPOS = listWeiTuoList(ids);
                            //校验数量
                            String checkStr = CheckCount(dingbiaoList, crcItemPackExtPOS,"定标采购明细变更");
                            if(!StringUtils.isEmpty(checkStr)){
                                rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                                rspBO.setRespDesc(checkStr);
                                return rspBO;
                            }
                            //变更定标报告数量
                            updateWeiTuo(dingbiaoList, crcItemPackExtPOS);
                        }
                        break;
                    default:
                        throw new RuntimeException("未知的明细类型");
                }
            }
        }catch (Exception e){
            log.error("updateDdCount error:{}",e);
            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            rspBO.setRespDesc(RspConstant.RESP_DESC_ERROR);
        }
        return rspBO;
    }
    @Transactional
    public void updateZixing(List<SscUpdateSchemeAmountBO> weituoList,List<CrcItemPackExtPO> crcItemPackExtPOS){
        Map<String, List<CrcItemPackExtPO>> collect =
                crcItemPackExtPOS.stream().collect(Collectors.groupingBy(CrcItemPackExtPO::getItemId));
        List<CrcItemPackExtPO> collect1 = weituoList.stream()
                .map($ -> {
                    List<CrcItemPackExtPO> crcItemPackExtPOS1 = collect.get($.getId().toString());
                    CrcItemPackExtPO crcItemPackExtPO = new CrcItemPackExtPO();
                    if (!CollectionUtils.isEmpty(crcItemPackExtPOS1)) {
                        CrcItemPackExtPO crcItemPackExtPO1 = crcItemPackExtPOS1.get(0);
                        BigDecimal ddCount = crcItemPackExtPO1.getDdCount();
                        crcItemPackExtPO.setDdCount(1 == $.getOperateType()?ddCount.add($.getOrderNum()):ddCount.subtract($.getOrderNum()));
                        crcItemPackExtPO.setItemId($.getId().toString());
                    }
                    return crcItemPackExtPO;
                })
                .filter(
                        $ -> {
                            return Objects.nonNull($.getItemId());
                        })
                .collect(Collectors.toList());

        if(!CollectionUtils.isEmpty(collect1)){
            log.info("updateZixing param :{}", JSON.toJSONString(collect1));
            sscSchemeMatNumMapper.batchUpdateZx(collect1);
        }

    }
    @Transactional
    public void updateWeiTuo(List<SscUpdateSchemeAmountBO> weituoList,List<CrcItemPackExtPO> crcItemPackExtPOS){
        Map<String, List<CrcItemPackExtPO>> collect =
                crcItemPackExtPOS.stream().collect(Collectors.groupingBy(CrcItemPackExtPO::getItemId));
        List<CrcItemPackExtPO> collect1 = weituoList.stream()
                .map($ -> {
                    List<CrcItemPackExtPO> crcItemPackExtPOS1 = collect.get($.getId().toString());
                    CrcItemPackExtPO crcItemPackExtPO = new CrcItemPackExtPO();
                    if (!CollectionUtils.isEmpty(crcItemPackExtPOS1)) {
                        CrcItemPackExtPO crcItemPackExtPO1 = crcItemPackExtPOS1.get(0);
                        BigDecimal ddCount = crcItemPackExtPO1.getDdCount();
                        crcItemPackExtPO.setDdCount(1 == $.getOperateType()?ddCount.add($.getOrderNum()):ddCount.subtract($.getOrderNum()));
                        crcItemPackExtPO.setItemId($.getId().toString());
                    }
                    return crcItemPackExtPO;
                })
                .filter(
                        $ -> {
                            return Objects.nonNull($.getItemId());
                        })
                .collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(collect1)){
            log.info("updateWeiTuo param :{}", JSON.toJSONString(collect1));
            sscSchemeMatNumMapper.batchUpdateWt(collect1);
        }

    }

    private String CheckCount(List<SscUpdateSchemeAmountBO> list,List<CrcItemPackExtPO> crcItemPackExtPOS,String message){
        if(CollectionUtils.isEmpty(crcItemPackExtPOS)){
            return message+"未查询到"+message+"列表";
        }
        Map<String, List<CrcItemPackExtPO>> collect =
                crcItemPackExtPOS.stream().collect(Collectors.groupingBy(CrcItemPackExtPO::getItemId));
        for (int i = 0; i < list.size(); i++) {
            SscUpdateSchemeAmountBO sscUpdateSchemeAmountBO = list.get(i);
            List<CrcItemPackExtPO> crcItemPackExtPOS1 = collect.get(sscUpdateSchemeAmountBO.getId().toString());
            if(CollectionUtils.isEmpty(crcItemPackExtPOS1)){
                continue;
            }
            CrcItemPackExtPO crcItemPackExtPO = crcItemPackExtPOS1.get(0);
            BigDecimal ddCount = crcItemPackExtPO.getDdCount();
            BigDecimal purchaseCount = crcItemPackExtPO.getPurchaseCount();
            BigDecimal orderNum = sscUpdateSchemeAmountBO.getOrderNum();
            if(sscUpdateSchemeAmountBO.getOperateType() == 0){
                //减少
                //校验订单使用数量是否为空
                if(Objects.isNull(ddCount)||ddCount.compareTo(BigDecimal.ZERO) == 0){
                    return message+"：减少量不允许大于使用数量";
                }
                //校验减少量是否大于订单使用数量
                if(ddCount.subtract(orderNum).compareTo(BigDecimal.ZERO) < 0){
                    return  message+"：减少量不允许大于使用数量";
                }
                //校验减少量是否大于总量
                if(purchaseCount.subtract(orderNum).compareTo(BigDecimal.ZERO) < 0){
                    return  message+"：减少量不允许大于中标数量";
                }
            }else if(sscUpdateSchemeAmountBO.getOperateType() == 1){
                //增加
                //校验增加量是否大于总量
                if(purchaseCount.subtract(orderNum).compareTo(BigDecimal.ZERO) < 0){
                    return  message+"：减少量不允许大于中标数量";
                }
                //校验增加量+已下单量是否大于总量
                if(purchaseCount.subtract(orderNum.add(ddCount)).compareTo(BigDecimal.ZERO) < 0){
                    return  message+"：减少量不允许大于(中标数量-使用数量)";
                }
            }
        }
        return null;
    }
    private List<CrcItemPackExtPO> listzixingList(List<Long> ids){
        CrcItemPackExtPO crcItemPackExtPO = new CrcItemPackExtPO();
        List<String> longs = JSON.parseArray(JSON.toJSONString(ids), String.class);
        crcItemPackExtPO.setItemIds(longs);
        return crcItemPackExtMapper.getInquiryItemDbCountInfoList(crcItemPackExtPO);
    }

    private List<CrcItemPackExtPO> listWeiTuoList(List<Long> ids){
        CrcItemPackExtPO crcItemPackExtPO = new CrcItemPackExtPO();
        List<String> longs = JSON.parseArray(JSON.toJSONString(ids), String.class);
        crcItemPackExtPO.setItemIds(longs);
        return crcItemPackExtMapper.getEntrustItemDbCountInfoList(crcItemPackExtPO);
    }


    private void checkParam(SscUpdateSchemeAmountReqBO reqBO){
        Assert.notNull(reqBO,"入参不能为空");
        Assert.notEmpty(reqBO.getReqBOs(),"明细不能为空");
        for (int i = 0; i < reqBO.getReqBOs().size(); i++) {
            SscUpdateSchemeAmountBO sscUpdateSchemeAmountBO = reqBO.getReqBOs().get(i);
            Assert.notNull(sscUpdateSchemeAmountBO.getId(),"行id不能为空");
            Assert.notNull(sscUpdateSchemeAmountBO.getType(),"明细类型不能为空");
            if(sscUpdateSchemeAmountBO.getType() == 1){
                Assert.notNull(sscUpdateSchemeAmountBO.getQueryType(),"查询类型不能为空");
            }
            Assert.notNull(sscUpdateSchemeAmountBO.getOperateType(),"操作类型不能为空");
        }
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SscSchemeAmountRspBO updateSchemeOrderAmount(SscSchemeAmountReqBO reqBO) {
        SscSchemeAmountRspBO rspBO = new SscSchemeAmountRspBO();

        List<String> schemeMatIds = reqBO.getOrderItem().stream().map(SscSchemeAmountBO::getGoodTypeId).collect(Collectors.toList());

        List<SscSchemeMatNum> updateVerify = sscSchemeMatNumMapper.queryAllByschemeMatIds(schemeMatIds);

        Map<String, SscSchemeAmountBO> sscSchemeAmountBOMap = reqBO.getOrderItem().stream().collect(Collectors.toMap(SscSchemeAmountBO::getGoodTypeId, i -> i));
        //检验订单扣减数量
        if (!CollectionUtils.isEmpty(updateVerify)) {
            for (SscSchemeMatNum sscSchemeMatNum : updateVerify) {
                SscSchemeAmountBO sscSchemeAmountBO = sscSchemeAmountBOMap.get(String.valueOf(sscSchemeMatNum.getSchemeMatId()));
                if (reqBO.getTypeAmount().equals(0)) {
                    if (sscSchemeAmountBO.getOperateType()==1){
                        sscSchemeMatNum.setContractAmount(sscSchemeMatNum.getContractAmount().subtract(sscSchemeAmountBO.getOrderNum()));
                    }else {
                        sscSchemeMatNum.setContractAmount(sscSchemeMatNum.getContractAmount().add(sscSchemeAmountBO.getOrderNum()));

                        if (sscSchemeAmountBO.getOrderNum().compareTo(sscSchemeMatNum.getContractAmountY())>0){
                            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                            rspBO.setRespDesc("退回数量不能大于使用量");
                            return rspBO;
                        }
                    }

                    if (sscSchemeMatNum.getOrderAmountY()!=null && sscSchemeMatNum.getOrderAmountY().compareTo(BigDecimal.ZERO)>0){
                        rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                        rspBO.setRespDesc("合同或者订单只能存在一种");
                        return rspBO;
                    }
                }else {
                    if (sscSchemeAmountBO.getOperateType()==1){
                        sscSchemeMatNum.setOrderAmount(sscSchemeMatNum.getOrderAmount().subtract(sscSchemeAmountBO.getOrderNum()));
                    }else {
                        sscSchemeMatNum.setOrderAmount(sscSchemeMatNum.getOrderAmount().add(sscSchemeAmountBO.getOrderNum()));
                        if (sscSchemeAmountBO.getOrderNum().compareTo(sscSchemeMatNum.getOrderAmountY())>0){
                            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                            rspBO.setRespDesc("退回数量不能大于使用量");
                            return rspBO;
                        }
                    }

                    if (sscSchemeMatNum.getContractAmountY()!=null && sscSchemeMatNum.getContractAmountY().compareTo(BigDecimal.ZERO)>0){
                        rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                        rspBO.setRespDesc("合同或者订单只能存在一种");
                        return rspBO;
                    }
                }
                if (-1 == sscSchemeMatNum.getOrderAmount().compareTo(BigDecimal.ZERO)) {
                    rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                    rspBO.setRespDesc("方案剩余数量不足");
                    return rspBO;
                }
                if (-1 == sscSchemeMatNum.getContractAmount().compareTo(BigDecimal.ZERO)) {
                    rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                    rspBO.setRespDesc("方案剩余数量不足");
                    return rspBO;
                }

            }
        }

        List<SscSchemeMatNum> inserLists = new ArrayList<>();

        List<SscSchemeAmountBO> bos = reqBO.getOrderItem();

        List<SscSchemeMatNum> sscSchemeMats = sscSchemeMatNumMapper.queryAllIsNullByschemeMatIds(schemeMatIds);
        Map<Long, SscSchemeMatNum> sscSchemeMatNumMap = sscSchemeMats.stream().collect(Collectors.toMap(a -> a.getSchemeMatId(), b -> b));
        for (SscSchemeAmountBO bo : bos) {
            SscSchemeMatNum sscSchemeMatNum = null;
            if (ObjectUtil.isNotEmpty(sscSchemeMatNumMap)) {
                sscSchemeMatNum = sscSchemeMatNumMap.get(Convert.toLong(bo.getGoodTypeId()));
            }
            SscSchemeMatNum update = new SscSchemeMatNum();
            update.setSchemeMatId(Convert.toLong(bo.getGoodTypeId()));
            if (ObjectUtil.isNotEmpty(sscSchemeMatNum)) {
                setSscSchemeMatNumMapper(reqBO.getTypeAmount(), bo, update, sscSchemeMatNum);
                sscSchemeMatNumMapper.update(update);
            } else {
                if (reqBO.getTypeAmount().equals(TYPE_CONTRACT_AMOUNT)) {
                    update.setContractAmount(bo.getOrderNum());
                } else if (reqBO.getTypeAmount().equals(TYPE_ORDER_AMOUNT)) {
                    update.setOrderAmount(bo.getOrderNum());
                }
                inserLists.add(update);
            }
        }
        if (!CollectionUtils.isEmpty(inserLists)) {
            sscSchemeMatNumMapper.insertBatch(inserLists);
        }



        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }

    @Override
    public SscSchemeGetCanOrderNumAtomRspBO getCanOrderNum(SscSchemeAmountReqBO reqBO) {
        SscSchemeGetCanOrderNumAtomRspBO rspBO = new SscSchemeGetCanOrderNumAtomRspBO();
        List<SscSchemeAmountBO> respList = new ArrayList<>();
        List<SscSchemeAmountBO> bos = reqBO.getOrderItem();
        List<String> collect = bos.stream().map(SscSchemeAmountBO::getGoodTypeId).collect(Collectors.toList());
        List<SscSchemeMatNum> sscSchemeMatNums = sscSchemeMatNumMapper.queryAllByschemeMatIds(collect);
        sscSchemeMatNums.forEach(
                e -> {
                    SscSchemeAmountBO sscSchemeAmountBO = new SscSchemeAmountBO();
                    sscSchemeAmountBO.setGoodTypeId(Convert.toStr(e.getSchemeMatId()));
                    if (reqBO.getTypeAmount().equals(0)) {
                        sscSchemeAmountBO.setOrderNum(e.getContractAmount());
                    } else if (reqBO.getTypeAmount().equals(1)) {
                        sscSchemeAmountBO.setOrderNum(e.getOrderAmount());
                    }
                    respList.add(sscSchemeAmountBO);
                }
        );
        if (!CollectionUtils.isEmpty(respList)) {
            rspBO.setOrderItem(respList);
        } else {
            rspBO.setOrderItem(new ArrayList<>());
        }
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }

    /**
     * @param type              合同||订单
     * @param sscSchemeAmountBO 入参
     * @param update            更新数据类
     * @param sscSchemeMat      查询
     */
    private void setSscSchemeMatNumMapper(Integer type, SscSchemeAmountBO sscSchemeAmountBO, SscSchemeMatNum update, SscSchemeMatNum sscSchemeMat) {
        //合同还是订单
        if (type.equals(0)) {
            //操作类型增加还是减少
            if (sscSchemeAmountBO.getOperateType().equals(1)) {
                //新实体=查询数量+入参数量
                update.setContractAmount(NumberUtil.add(sscSchemeMat.getContractAmount(), sscSchemeAmountBO.getOrderNum()));
            } else if (sscSchemeAmountBO.getOperateType().equals(0)) {
                update.setContractAmount(NumberUtil.sub(sscSchemeMat.getContractAmount(), sscSchemeAmountBO.getOrderNum()));
            }
        }
        //1订单数量扣减
        else if (type.equals(1)) {
            if (sscSchemeAmountBO.getOperateType().equals(1)) {
                update.setOrderAmount(NumberUtil.add(sscSchemeMat.getOrderAmount(), sscSchemeAmountBO.getOrderNum()));
            } else if (sscSchemeAmountBO.getOperateType().equals(0)) {
                update.setOrderAmount(NumberUtil.sub(sscSchemeMat.getOrderAmount(), sscSchemeAmountBO.getOrderNum()));
            }
        }


    }


}


