package com.tydic.dyc.ssc.repositoryExt.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.repository.SscSchemeMatPackExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeInviteSupPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeMatExtPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeMatPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeInviteSupPackExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeInviteSupPackFzExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeMatExtPackExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeMatPackExtPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：采购方案明细基建层接口实现类
 * 时间：2023/07/24
 */
@Service
public class SscSchemeMatPackExtRepositoryImpl implements SscSchemeMatPackExtRepository {

    /**
     * 采购方案明细 Mapper
     */
    @Autowired
    private SscSchemeMatPackExtMapper sscSchemeMatPackExtMapper;

    /**
     * 采购方案明细扩展 Mapper
     */
    @Autowired
    private SscSchemeMatExtPackExtMapper sscSchemeMatExtPackExtMapper;

    /**
     * 采购方案供应商 Mapper
     */
    @Autowired
    private SscSchemeInviteSupPackExtMapper sscSchemeInviteSupPackExtMapper;

    /**
     * 采购方案明细分页查询
     */
    @Override
    public SscSchemeMatListQueryExtRspBO querySchemeMatList(SscSchemeMatListQueryExtReqBO reqBO) {
        SscSchemeMatListQueryExtRspBO rspBO = new SscSchemeMatListQueryExtRspBO();

        //设置分页参数
        Page<SscSchemeMatPackExtPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        //入参条件参数转换
        SscSchemeMatPackExtPO sscSchemeMatPackExtPO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeMatPackExtPO.class);

        //调用根据条件分页查询列表数据
        List<SscSchemeMatPackExtPO> listPage = this.sscSchemeMatPackExtMapper.getListPage(sscSchemeMatPackExtPO, page);

        if (CollectionUtils.isEmpty(listPage)){
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setRows(new ArrayList<>());
            rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
            rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }

        //采购方案明细列表数据转换
        List<SscSchemeMatListQueryExtBO> sscSchemeMatListQueryExtBOList = JSON.parseArray(JSON.toJSONString(listPage), SscSchemeMatListQueryExtBO.class);

        //获取采购方案明细扩展数据
        this.getSscSchemeMatExt(sscSchemeMatListQueryExtBOList);

        //封装金钱
        this.packingMoney(sscSchemeMatListQueryExtBOList);

        //获取供应商信息
        this.getSupplierInfo(sscSchemeMatListQueryExtBOList);

        //数据转译
        this.querySchemeMatListDataTranslation(sscSchemeMatListQueryExtBOList);

        //封装剩余量
        this.packingRemainingNum(reqBO, sscSchemeMatListQueryExtBOList);

        //出参
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(sscSchemeMatListQueryExtBOList);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);

        return rspBO;
    }

    /**
     * 获取采购方案明细扩展数据
     */
    private void getSscSchemeMatExt(List<SscSchemeMatListQueryExtBO> sscSchemeMatListQueryExtBOList){
        if (!CollectionUtils.isEmpty(sscSchemeMatListQueryExtBOList)){
            //获取方案物料ID集合
            List<Long> schemeMatIds = sscSchemeMatListQueryExtBOList.stream().map(SscSchemeMatListQueryExtBO::getSchemeMatId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());

            //调用根据方案物料ID查询列表数据
            List<SscSchemeMatExtPackExtPO> sscSchemeMatExtPackExtPOList = new ArrayList<>(10);
            if (!CollectionUtils.isEmpty(schemeMatIds)){
                sscSchemeMatExtPackExtPOList = this.sscSchemeMatExtPackExtMapper.getListBySchemeMatExtId(schemeMatIds);
            }

            if (!CollectionUtils.isEmpty(sscSchemeMatExtPackExtPOList)){
                //获取采购方案明细扩展Map
                Map<Long, List<SscSchemeMatExtPackExtPO>> sscSchemeMatExtPackExtPOMap = sscSchemeMatExtPackExtPOList.stream().collect(Collectors.groupingBy(SscSchemeMatExtPackExtPO::getSchemeMatId));

                for (SscSchemeMatListQueryExtBO sscSchemeMatListQueryExtBO : sscSchemeMatListQueryExtBOList) {
                    if (!CollectionUtils.isEmpty(sscSchemeMatExtPackExtPOMap.get(sscSchemeMatListQueryExtBO.getSchemeMatId()))){
                        List<SscSchemeMatExtPackExtBO> schemeMatExtPackExtFields = JSON.parseArray(JSON.toJSONString(sscSchemeMatExtPackExtPOMap.get(sscSchemeMatListQueryExtBO.getSchemeMatId())), SscSchemeMatExtPackExtBO.class);
                        //采购方案明细扩展集合
                        sscSchemeMatListQueryExtBO.setSchemeMatExtPackExtFields(schemeMatExtPackExtFields);
                    }
                }
            }
        }
    }

    /**
     * 封装金钱
     */
    private void packingMoney(List<SscSchemeMatListQueryExtBO> sscSchemeMatListQueryExtBOList){
        if (!CollectionUtils.isEmpty(sscSchemeMatListQueryExtBOList)){
            for (SscSchemeMatListQueryExtBO sscSchemeMatListQueryExtBO : sscSchemeMatListQueryExtBOList) {

                //判断税率为空
                if (ObjectUtil.isEmpty(sscSchemeMatListQueryExtBO.getTaxRate())){
                    //设置税率默认值
                    sscSchemeMatListQueryExtBO.setTaxRate(new BigDecimal("0"));
                }
                //判断采购数量为空
                if (ObjectUtil.isEmpty(sscSchemeMatListQueryExtBO.getPurchaseNum())){
                    //设置采购数量默认值
                    sscSchemeMatListQueryExtBO.setPurchaseNum(new BigDecimal("0"));
                }
                //判断不含税单价为空
                if (ObjectUtil.isEmpty(sscSchemeMatListQueryExtBO.getNoTaxPrice())){
                    //设置不含税单价默认值
                    sscSchemeMatListQueryExtBO.setNoTaxPrice(new BigDecimal("0"));
                }

                //计算不含税金额
                BigDecimal totalNoTaxPrice = sscSchemeMatListQueryExtBO.getNoTaxPrice().multiply(sscSchemeMatListQueryExtBO.getPurchaseNum()).setScale(10, BigDecimal.ROUND_HALF_UP);
                //设置不含税金额
                sscSchemeMatListQueryExtBO.setTotalNoTaxPrice(totalNoTaxPrice);

                //计算税率百分率
                BigDecimal percentage = new BigDecimal("100").add(sscSchemeMatListQueryExtBO.getTaxRate()).divide(new BigDecimal("100"),10,BigDecimal.ROUND_HALF_UP);

                //计算含税单价
                BigDecimal taxPrice = sscSchemeMatListQueryExtBO.getNoTaxPrice().multiply(percentage).setScale(10, BigDecimal.ROUND_HALF_UP);
                //设置含税单价
                sscSchemeMatListQueryExtBO.setTaxPrice(taxPrice);

                //计算含税金额
                BigDecimal totalTaxPrice = sscSchemeMatListQueryExtBO.getTaxPrice().multiply(sscSchemeMatListQueryExtBO.getPurchaseNum()).setScale(10, BigDecimal.ROUND_HALF_UP);
                //设置含税金额
                sscSchemeMatListQueryExtBO.setTotalTaxPrice(totalTaxPrice);

            }
        }
    }

    /**
     * 获取供应商信息
     */
    private void getSupplierInfo(List<SscSchemeMatListQueryExtBO> sscSchemeMatListQueryExtBOList){
        if (!CollectionUtils.isEmpty(sscSchemeMatListQueryExtBOList)){
            //获取方案ID集合
            List<Long> schemeIds = sscSchemeMatListQueryExtBOList.stream().map(SscSchemeMatListQueryExtBO::getSchemeId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());

            //调用根据方案ID查询列表数据
            List<SscSchemeInviteSupPackExtPO> sscSchemeInviteSupPackExtPOList = new ArrayList<>(10);
            List<SscSchemeInviteSupPackFzExtPO> sscSchemeInviteSupPackFzExtPOList = new ArrayList<>(10);

            if (!CollectionUtils.isEmpty(schemeIds)){
                sscSchemeInviteSupPackExtPOList = this.sscSchemeInviteSupPackExtMapper.getListBySchemeId(schemeIds);
                //扩展表查询非招供应商id
                sscSchemeInviteSupPackFzExtPOList = this.sscSchemeInviteSupPackExtMapper.getFzCompanyIdListBySchemeId(schemeIds);
            }

            if (!CollectionUtils.isEmpty(sscSchemeInviteSupPackExtPOList)){

                //将非招供应商id拼至sscSchemeInviteSupPackExtPOList中
                if(!CollectionUtils.isEmpty(sscSchemeInviteSupPackFzExtPOList)) {
                Map<Long, String> sscSchemeInviteSupPackFzExtPOMap = sscSchemeInviteSupPackFzExtPOList.stream().collect(Collectors.toMap(SscSchemeInviteSupPackFzExtPO::getSchemeInviteSupId,SscSchemeInviteSupPackFzExtPO::getCompanyId));

                    for (SscSchemeInviteSupPackExtPO sscSchemeInviteSupPackExtPO:sscSchemeInviteSupPackExtPOList) {
                        if (!sscSchemeInviteSupPackFzExtPOMap.get(sscSchemeInviteSupPackExtPO.getSchemeInviteSupId()).isEmpty()) {
                            sscSchemeInviteSupPackExtPO.setCompanyId(sscSchemeInviteSupPackFzExtPOMap.get(sscSchemeInviteSupPackExtPO.getSchemeInviteSupId()));
                        }
                    }
                }
                //获取采购方案供应商Map
                Map<Long, List<SscSchemeInviteSupPackExtPO>> sscSchemeInviteSupPackExtPOMap = sscSchemeInviteSupPackExtPOList.stream().collect(Collectors.groupingBy(SscSchemeInviteSupPackExtPO::getPackId));

                for (SscSchemeMatListQueryExtBO sscSchemeMatListQueryExtBO : sscSchemeMatListQueryExtBOList) {
                    if (!CollectionUtils.isEmpty(sscSchemeInviteSupPackExtPOMap.get(sscSchemeMatListQueryExtBO.getPackId()))){
                        List<SscSchemeInviteSupPackExtBO> schemeInviteSupPackExtBOList = JSON.parseArray(JSON.toJSONString(sscSchemeInviteSupPackExtPOMap.get(sscSchemeMatListQueryExtBO.getPackId())), SscSchemeInviteSupPackExtBO.class);
                        //设置采购方案供应商集合
                        sscSchemeMatListQueryExtBO.setSchemeInviteSupPackExtBOList(schemeInviteSupPackExtBOList);
                    }
                }
            }
        }
    }

    /**
     * 数据转译
     */
    private void querySchemeMatListDataTranslation(List<SscSchemeMatListQueryExtBO> sscSchemeMatListQueryExtBOList){
        if (!CollectionUtils.isEmpty(sscSchemeMatListQueryExtBOList)){
            for (SscSchemeMatListQueryExtBO sscSchemeMatListQueryExtBO : sscSchemeMatListQueryExtBOList) {

                //判断方案类别不为空
                if (ObjectUtil.isNotEmpty(sscSchemeMatListQueryExtBO.getSchemeClass())){
                    //设置方案类别翻译
                    sscSchemeMatListQueryExtBO.setSchemeClassStr(Objects.requireNonNull(SscCommConstant.SchemeClass.getInstance(sscSchemeMatListQueryExtBO.getSchemeClass())).getDesc());
                }
            }
        }
    }

    /**
     * 封装剩余量
     */
    private void packingRemainingNum(SscSchemeMatListQueryExtReqBO reqBO, List<SscSchemeMatListQueryExtBO> sscSchemeMatListQueryExtBOList){
        if (!CollectionUtils.isEmpty(sscSchemeMatListQueryExtBOList)){
            for (SscSchemeMatListQueryExtBO sscSchemeMatListQueryExtBO : sscSchemeMatListQueryExtBOList) {
                //查询类型 1合同 剩余数量设置为合同剩余数量
                if (ObjectUtil.isNotEmpty(reqBO) && reqBO.getQueryType() == 1){
                    sscSchemeMatListQueryExtBO.setRemainingNum(sscSchemeMatListQueryExtBO.getContractRemainingNum());
                }
                //查询类型 2订单 剩余数量设置为订单剩余数量
                if (ObjectUtil.isNotEmpty(reqBO) && reqBO.getQueryType() == 2){
                    sscSchemeMatListQueryExtBO.setRemainingNum(sscSchemeMatListQueryExtBO.getOrderRemainingNum());
                }
            }
        }
    }

    /**
     * 采购方案明细列表分页查询
     */
    @Override
    public SscSchemeMatQryExtRspBO querySchemeMatListPage(SscSchemeMatQryExtReqBO reqBO) {
        SscSchemeMatQryExtRspBO rspBO = new SscSchemeMatQryExtRspBO();

        //设置分页参数
        Page<SscSchemeMatPackExtPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        //入参条件参数转换
        SscSchemeMatPackExtPO sscSchemeMatPackExtPO = JSON.parseObject(JSON.toJSONString(reqBO), SscSchemeMatPackExtPO.class);

        //根据条件查询列表数据
        List<SscSchemeMatPackExtPO> sscSchemeMatPackExtPOList = this.sscSchemeMatPackExtMapper.getListOfPage(sscSchemeMatPackExtPO, page);

        if (CollectionUtils.isEmpty(sscSchemeMatPackExtPOList)){
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setRows(new ArrayList<>());
            rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
            rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }

        //列表数据转换
        List<SscSchemeMatQryExtBO> sscSchemeMatQryExtBOList = JSON.parseArray(JSON.toJSONString(sscSchemeMatPackExtPOList), SscSchemeMatQryExtBO.class);

        //数据转译
        this.querySchemeMatListPageDataTranslation(sscSchemeMatQryExtBOList);

        //出参
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(sscSchemeMatQryExtBOList);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);

        return rspBO;
    }

    /**
     * 数据转译
     */
    private void querySchemeMatListPageDataTranslation(List<SscSchemeMatQryExtBO> sscSchemeMatQryExtBOList){
        if (!CollectionUtils.isEmpty(sscSchemeMatQryExtBOList)){
            for (SscSchemeMatQryExtBO sscSchemeMatQryExtBO : sscSchemeMatQryExtBOList) {

                //判断采购方式不为空
                if (ObjectUtil.isNotEmpty(sscSchemeMatQryExtBO.getPurchaseType())){
                    //设置采购方式翻译
                    sscSchemeMatQryExtBO.setPurchaseTypeStr(Objects.requireNonNull(SscCommConstant.SchemePurchaseType.getInstance(sscSchemeMatQryExtBO.getPurchaseType())).getDesc());
                }
            }
        }
    }
}
