package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.model.SscSchemeExtDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeMainInfoExtQryBO;
import com.tydic.dyc.ssc.repository.SscSchemeExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeMapperUnsExt;
import com.tydic.dyc.ssc.repositoryExt.po.ExportEsaySchemeAndMatPO;
import com.tydic.dyc.ssc.service.scheme.bo.ExportEsaySchemeAndMatBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description: SscSchemeExtRepositoryImpl
 * @Author: the_xhl
 * @Date: 2023-03-30
 */
@Service
@Slf4j
public class SscSchemeExtRepositoryImpl implements SscSchemeExtRepository {

    @Autowired
    private SscSchemeMapperUnsExt sscSchemeMapperUnsExt;

    @Override
    public List<SscSchemeExtDo> qrySchemeMainInfoList(SscSchemeExtDo reqBO) {
        if (reqBO.getPageNo()==null){
            reqBO.setPageNo(1);
        }
        if (reqBO.getPageSize()==null){
            reqBO.setPageSize(99999);
        }
        Page<SscSchemeExtDo> pg  = new Page<SscSchemeExtDo>(reqBO.getPageNo(), reqBO.getPageSize());
        return sscSchemeMapperUnsExt.qrySchemeMainInfoList(SscRu.js(reqBO, SscSchemeMainInfoExtQryBO.class),pg);
    }

    @Override
    public List<ExportEsaySchemeAndMatBO> selectEsaySchemeAndMat(List<Long> schemeIds) {
        log.info("查询打印入参 ：{}", JSON.toJSON(schemeIds));
        List<ExportEsaySchemeAndMatPO> exportEsaySchemeAndMatPOS = sscSchemeMapperUnsExt.selectEsaySchemeAndMat(schemeIds);
        log.info("查询打印出参 ：{}", JSON.toJSON(exportEsaySchemeAndMatPOS));
        return JUtil.jsl(exportEsaySchemeAndMatPOS,ExportEsaySchemeAndMatBO.class);
    }
}
