package com.tydic.dyc.ssc.repositoryExt.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.repository.SscSchemeMatListCrcResultExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SscCrcResultPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeMatPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeMatCrcResultExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeMatPackExtPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 标题：采购方案询源结果列表基建层接口实现类
 * 时间：2023/08/14
 */
@Service
public class SscSchemeMatListCrcResultExtRepositoryImpl implements SscSchemeMatListCrcResultExtRepository {

    /**
     * 采购方案询源结果 Mapper
     */
    @Autowired
    private SscCrcResultPackExtMapper sscCrcResultPackExtMapper;

    /**
     * 采购方案明细 Mapper
     */
    @Autowired
    private SscSchemeMatPackExtMapper sscSchemeMatPackExtMapper;

    /**
     * 通过询源结果查询采购方案明细列表
     */
    @Override
    public SscSchemeMatCrcResultListExtRspBO getSchemeMatListByCrcResult(SscSchemeMatCrcResultListExtReqBO reqBO) {
        SscSchemeMatCrcResultListExtRspBO rspBO = new SscSchemeMatCrcResultListExtRspBO();

        //定义采购方案询源结果集合
        List<SscSchemeMatCrcResultExtPO> sscSchemeMatCrcResultExtPOList = new ArrayList<>(10);

        //定义采购方案询源结果查询条件入参
        SscSchemeMatCrcResultExtPO querySscSchemeMatCrcResultExtPO = new SscSchemeMatCrcResultExtPO();
        //设置明细ID集合
        querySscSchemeMatCrcResultExtPO.setItemIds(reqBO.getItemIds());

        if (reqBO.getQueryType() == 1){
            //调用根据明细ID集合查询 集中采购 列表数据
            sscSchemeMatCrcResultExtPOList = this.sscCrcResultPackExtMapper.getFindSourceCrcResultList(querySscSchemeMatCrcResultExtPO);
        }
        if (reqBO.getQueryType() == 2){
            //调用根据明细ID集合查询 委托采购 列表数据
            sscSchemeMatCrcResultExtPOList = this.sscCrcResultPackExtMapper.getEntrustCrcResultList(querySscSchemeMatCrcResultExtPO);
        }
        if (reqBO.getQueryType() == 3){
            //调用根据明细ID集合查询 自行采购 列表数据
            sscSchemeMatCrcResultExtPOList = this.sscCrcResultPackExtMapper.getInquiryCrcResultList(querySscSchemeMatCrcResultExtPO);
        }

        if (CollectionUtils.isEmpty(sscSchemeMatCrcResultExtPOList)){
            rspBO.setSscSchemeMatBOList(new ArrayList<>());
            rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
            rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }

        //封装方案明细数据
        this.packingSchemeMatData(reqBO, rspBO, sscSchemeMatCrcResultExtPOList);

        //数据转译
        this.translationRspData(rspBO);

        //出参
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);

        return rspBO;
    }

    /**
     * 封装方案明细数据
     */
    private void packingSchemeMatData(SscSchemeMatCrcResultListExtReqBO reqBO, SscSchemeMatCrcResultListExtRspBO rspBO, List<SscSchemeMatCrcResultExtPO> sscSchemeMatCrcResultExtPOList){
        //定义采购方案明细集合
        List<SscSchemeMatPackExtPO> sscSchemeMatPackExtPOList = new ArrayList<>(10);

        //查询 集中采购 采购方案明细数据
        if (reqBO.getQueryType() == 1){
            //获取采购包物料ID集合
            List<Long> schemaItemIds = sscSchemeMatCrcResultExtPOList.stream().map(SscSchemeMatCrcResultExtPO::getSchemaItemId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());
            //获取采购方案明细数据
            List<SscSchemeMatPackExtPO> centralizedPurchaseSchemeData = this.getSchemeMatData("4", schemaItemIds);
            if (!CollectionUtils.isEmpty(centralizedPurchaseSchemeData)){
                //添加到采购方案明细集合
                sscSchemeMatPackExtPOList.addAll(centralizedPurchaseSchemeData);
            }
        }

        //查询 委托采购 采购方案明细数据
        if (reqBO.getQueryType() == 2){
            //获取 委托采购 采购方案询比结果 分组Map
            Map<String, List<SscSchemeMatCrcResultExtPO>> entrustAwardResultMap = sscSchemeMatCrcResultExtPOList.stream().filter(po -> ObjectUtil.isNotEmpty(po.getEntrustSource())).collect(Collectors.groupingBy(SscSchemeMatCrcResultExtPO::getEntrustSource));

            if (!CollectionUtils.isEmpty(entrustAwardResultMap)){
                //获取采购方案来源数据
                List<SscSchemeMatCrcResultExtPO> purchaseSchemeSourceData = entrustAwardResultMap.get("1");
                //获取简易方案来源数据
                List<SscSchemeMatCrcResultExtPO> simpleSchemeSourceData = entrustAwardResultMap.get("2");

                //封装 采购方案数据 和 简易方案数据
                this.packingNoSimpleSchemeAndSimpleSchemeData(purchaseSchemeSourceData, simpleSchemeSourceData, sscSchemeMatPackExtPOList);
            }
        }

        //查询 自行采购 采购方案明细数据
        if (reqBO.getQueryType() == 3){
            //获取 自行采购 采购方案询比结果 分组Map
            Map<String, List<SscSchemeMatCrcResultExtPO>> inquiryAwardResultMap = sscSchemeMatCrcResultExtPOList.stream().filter(po -> ObjectUtil.isNotEmpty(po.getInquirySource())).collect(Collectors.groupingBy(SscSchemeMatCrcResultExtPO::getInquirySource));

            if (!CollectionUtils.isEmpty(inquiryAwardResultMap)){
                //获取采购方案来源数据
                List<SscSchemeMatCrcResultExtPO> purchaseSchemeSourceData = inquiryAwardResultMap.get("1");
                //获取简易方案来源数据
                List<SscSchemeMatCrcResultExtPO> simpleSchemeSourceData = inquiryAwardResultMap.get("2");

                //封装 采购方案数据 和 简易方案数据
                this.packingNoSimpleSchemeAndSimpleSchemeData(purchaseSchemeSourceData, simpleSchemeSourceData, sscSchemeMatPackExtPOList);
            }
        }

        //采购方案明细集合数据转换
        List<SscSchemeMatQryExtBO> sscSchemeMatQryExtBOList = JSON.parseArray(JSON.toJSONString(sscSchemeMatPackExtPOList), SscSchemeMatQryExtBO.class);
        //设置采购方案明细集合
        rspBO.setSscSchemeMatBOList(sscSchemeMatQryExtBOList);
    }

    /**
     * 获取采购方案明细数据
     */
    private List<SscSchemeMatPackExtPO> getSchemeMatData(String schemeType, List<Long> schemaItemIds){
        //定义采购方案明细查询入参
        SscSchemeMatPackExtPO querySscSchemeMatPackExtPO = new SscSchemeMatPackExtPO();
        //设置方案类型
        querySscSchemeMatPackExtPO.setSchemeType(schemeType);
        //设置方案物料ID集合
        querySscSchemeMatPackExtPO.setSchemeMatIds(schemaItemIds);
        //调用根据方案物料ID集合查询列表数据
        return this.sscSchemeMatPackExtMapper.getListBySchemeMatIds(querySscSchemeMatPackExtPO);
    }

    /**
     * 封装 采购方案数据 和 简易方案数据
     */
    private void packingNoSimpleSchemeAndSimpleSchemeData(List<SscSchemeMatCrcResultExtPO> purchaseSchemeSourceData, List<SscSchemeMatCrcResultExtPO> simpleSchemeSourceData, List<SscSchemeMatPackExtPO> sscSchemeMatPackExtPOList){
        if (!CollectionUtils.isEmpty(purchaseSchemeSourceData)){
            //获取采购包物料ID集合
            List<Long> schemaItemIds = purchaseSchemeSourceData.stream().map(SscSchemeMatCrcResultExtPO::getSchemaItemId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(schemaItemIds)){
                //获取采购方案数据数据
                List<SscSchemeMatPackExtPO> purchaseSchemeData = this.getSchemeMatData("3", schemaItemIds);
                if (!CollectionUtils.isEmpty(purchaseSchemeData)){
                    //添加到采购方案明细集合
                    sscSchemeMatPackExtPOList.addAll(purchaseSchemeData);
                }
            }
        }

        if (!CollectionUtils.isEmpty(simpleSchemeSourceData)){
            //获取采购包物料ID集合
            List<Long> schemaItemIds = simpleSchemeSourceData.stream().map(SscSchemeMatCrcResultExtPO::getSchemaItemId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(schemaItemIds)){
                //获取简易方案数据
                List<SscSchemeMatPackExtPO> simpleSchemeData = this.getSchemeMatData("2", schemaItemIds);
                if (!CollectionUtils.isEmpty(simpleSchemeData)){
                    //添加到采购方案明细集合
                    sscSchemeMatPackExtPOList.addAll(simpleSchemeData);
                }
            }
        }
    }

    /**
     * 数据转译
     */
    private void translationRspData(SscSchemeMatCrcResultListExtRspBO rspBO){
        if (!CollectionUtils.isEmpty(rspBO.getSscSchemeMatBOList())){
            for (SscSchemeMatQryExtBO bo : rspBO.getSscSchemeMatBOList()) {

                //判断采购方式不为空
                if (ObjectUtil.isNotEmpty(bo.getPurchaseType())){
                    //设置采购方式翻译
                    bo.setPurchaseTypeStr(Objects.requireNonNull(SscCommConstant.SchemePurchaseType.getInstance(bo.getPurchaseType())).getDesc());
                }
            }
        }
    }
}
