package com.tydic.dyc.ssc.repositoryExt.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.repositoryExt.config.SscThreadPoolExecutorUtil;
import com.tydic.dyc.ssc.repositoryExt.po.syncSchemeListPO;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemePackExtServie;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtRspBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import com.tydic.dyc.ssc.service.scheme.syncSchemeListService;
import lombok.extern.ohaotian.HTServiceAPI;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import com.tydic.dyc.ssc.repositoryExt.dao.*;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 描述:
 *
 * @author WangGang
 * @date 2024/7/17
 */
@Slf4j
@HTServiceImpl
public class syncSchemeListServiceImpl implements syncSchemeListService {

    @Autowired
    private SaasSchemePackMapper schemePackMapper;
    @Value("${PAGE_SIZE:100}")
    private int PAGE_SIZE;
    @Value("${MaxSize:200}")
    private int MaxSize;

    @HTServiceRef
    private SscQrySchemePackExtServie schemePackExtServie;

    /**
     * 线程池
     */
    private static final ThreadPoolExecutor threadPoolExecutor = SscThreadPoolExecutorUtil.poolExecutor;

    @Override
    public SscQrySchemePackExtRspBO syncSchemeList(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO busiRspBO = new SscQrySchemePackExtRspBO();
        log.error("全量同步方案ES开启=====");
        //查询需要匹配的数据总量
/*
        int planCount = schemePackMapper.queryCount();
        if (planCount == 0) {
            busiRspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            busiRspBO.setRespDesc(RspConstant.RESP_DESC_ERROR);
            return busiRspBO;
        }
        //计算页数
        int pageCount = planCount % PAGE_SIZE == 0 ? planCount / PAGE_SIZE : planCount / PAGE_SIZE + 1;
        //设置最大限制页数
        pageCount = pageCount > MaxSize ? MaxSize : pageCount;
*/


        //开启线程进行匹配
    //    for (int i = 1; i <= pageCount; i++){
            Page<syncSchemeListPO> page = new Page<>();
            page.setPageNo(-1);
            page.setPageSize(PAGE_SIZE);
            List<SscQrySchemePackExtBO> syncList = schemePackMapper.querySchemePage(page);
            dealData(syncList);
  //     }
        busiRspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        busiRspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return busiRspBO;
    }

    private void dealData( List<SscQrySchemePackExtBO> syncList) {
        CompletableFuture.runAsync(() -> {
            for (SscQrySchemePackExtBO sscQrySchemePackExtBO : syncList) {
                Long objId = schemePackMapper.queryObjId(sscQrySchemePackExtBO.getSchemeId());
                log.error("Objid============" +objId);
                log.error("SchemeId()============" +sscQrySchemePackExtBO.getSchemeId());
                if (null != objId){
                    SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
                    sscQrySchemePackExtReqBO.setOrderId(sscQrySchemePackExtBO.getSchemeId());
                    sscQrySchemePackExtReqBO.setObjId(objId);
                    schemePackExtServie.syncTaskBySchemeId(sscQrySchemePackExtReqBO);
                }
            }
        });
    }
}
