package com.tydic.dyc.ssc.repositoryExt.dao;

import com.tydic.dyc.ssc.repositoryExt.po.SchemeBasisFileBuildFailPO;
import com.tydic.dyc.ssc.repositoryExt.po.SchemeBasisFilePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface SchemeBasisFileMapper {
    int deleteByPrimaryKey(Long fileId);

    int insert(SchemeBasisFilePO record);

    int insertSelective(SchemeBasisFilePO record);

    SchemeBasisFilePO selectByPrimaryKey(Long fileId);

    int updateByPrimaryKeySelective(SchemeBasisFilePO record);

    int updateByPrimaryKey(SchemeBasisFilePO record);

    /**
     * 根据方案id 清空附件
     * @param schemeId
     * @return
     */
    int deleteBySchemeId(@Param("schemeId") Long schemeId, @Param("fileType") Integer fileType);

    /**
     * 根据包id 清空附件
     * @param packIds
     * @return
     */
    int deleteByPackIds(@Param("packIds") List<Long> packIds, @Param("fileType") Integer fileType);

    /**
     * 批量新增
     * @param list
     * @return
     */
    int insertBatch(List<SchemeBasisFilePO> list);

    List<SchemeBasisFilePO> selectByPackIds(@Param("packIds") List<Long> packIds, @Param("fileType") Integer fileType);
}