package com.tydic.dyc.ssc.repositoryExt.impl;

import com.tydic.dyc.ssc.repository.QrySchememPackServiceRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.PlatFormSscSchemeMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.PlatFormSscSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryPlanPackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePackBO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @Author jmrg
 * @dATE 2023/7/26
 * @Desc
 */
@Service
public class QrySchemePackServiceRepositoryImpl implements QrySchememPackServiceRepository {

    @Autowired
    private PlatFormSscSchemePackMapper sscSchemPackMapper;

    @Override
    public List<SscSchemePackBO> listByParam(SscQrySchemeMainInfoExtBO param) {
        return converterList(sscSchemPackMapper.listByParam(param));
    }
    private List<SscSchemePackBO> converterList(List<SscSchemePackBO> list){
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        List<SscSchemePackBO> resultList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            SscSchemePackBO sscSchemePackBO = list.get(i);
            SscSchemePackBO sscQryPlanPackBO = new SscSchemePackBO();
            BeanUtils.copyProperties(sscSchemePackBO,sscQryPlanPackBO);
            resultList.add(sscQryPlanPackBO);
        }
        return resultList;
    }
}
