package com.tydic.dyc.ssc.repositoryExt.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtReqBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtRspBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackSyncFzBO;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.repository.SscSchemeTrackExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeTrackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeTrackSyncFzMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SysDicDictionaryMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SaasSchemePackPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeTrackSyncFzPO;
import com.tydic.dyc.ssc.repositoryExt.po.SysDicDictionaryPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 作者 85222
 * 创建日期 2023年04月12日
 */
@Service
public class SscSchemeTrackExtRepositoryImpl implements SscSchemeTrackExtRepository {
    @Autowired
    private SscSchemeTrackExtMapper sscSchemeTrackExtMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @Autowired
    private SscSchemeTrackSyncFzMapper sscSchemeTrackSyncFzMapper;
    @Autowired
    private SaasSchemePackMapper saasSchemePackMapper;
    @Override
    public int schemeTrackSync(SscSchemeTrackSyncFzBO bo) {
        int rspBO=8888;
        SscSchemeTrackSyncFzPO po = sscSchemeTrackSyncFzMapper.selectByPackId(bo.getPackId());
        if(ObjectUtils.isEmpty(po)){
            SscSchemeTrackSyncFzPO js = JUtil.js(bo, SscSchemeTrackSyncFzPO.class);
            js.setCreateTime(new Date());
            rspBO = sscSchemeTrackSyncFzMapper.insert(js);
        }else {
            SscSchemeTrackSyncFzPO sscSchemeTrackSyncFzPO = JUtil.js(bo, SscSchemeTrackSyncFzPO.class);
            sscSchemeTrackSyncFzPO.setId(po.getId());
            sscSchemeTrackSyncFzPO.setUpdateTime(new Date());
            rspBO=sscSchemeTrackSyncFzMapper.updateById(sscSchemeTrackSyncFzPO);
        }
        return rspBO;
    }
    @Override
    public SscSchemeTrackExtRspBO selectSchemeTrack(SscSchemeTrackExtReqBO reqBO) {
        if (!StringUtils.isEmpty(reqBO.getAuditTimeEnd())) {
            reqBO.setAuditTimeEnd(reqBO.getAuditTimeEnd()+" 23:59:59");
        }
        if (!StringUtils.isEmpty(reqBO.getCreateTimeEnd())) {
            reqBO.setCreateTimeEnd(reqBO.getCreateTimeEnd()+" 23:59:59");
        }
        SscSchemeTrackExtRspBO rspBO = new SscSchemeTrackExtRspBO();
        Page<SscSchemeTrackExtReqBO> page = new Page<SscSchemeTrackExtReqBO>(reqBO.getPageNo(), reqBO.getPageSize());
        //是否是集采方案要根据采购方案那面的数据查询
        Integer isGroupBuyQryFlag = 0;
        if (!StringUtils.isEmpty(reqBO.getPlanPackCode())){
            isGroupBuyQryFlag =1;
        }
        if (!StringUtils.isEmpty(reqBO.getPlanPackName())){
            isGroupBuyQryFlag =1;
        }
        if (!StringUtils.isEmpty(reqBO.getPlanPackNo())){
            isGroupBuyQryFlag =1;
        }
        if (!StringUtils.isEmpty(reqBO.getPlanPackOrgCode())){
            isGroupBuyQryFlag =1;
        }
        if (!StringUtils.isEmpty(reqBO.getPlanPackOrgName())){
            isGroupBuyQryFlag =1;
        }
        reqBO.setIsGroupBuyQryFlag(isGroupBuyQryFlag);
        List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS = sscSchemeTrackExtMapper.selectSchemeTrack(reqBO, page);
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS) && SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(String.valueOf(reqBO.getSchemeType()))){
            //判断 采购方案 分配给 对应人，然后生成集采方案，跟踪列表要展示对应的集采方案的 询比
            /**
             * 1、采购方案的分交方式被审核/修改为[集采实施-自营]后，
             * 采购方案采购包的执行状态、业务状态=集采方案采购包的执行状态、业务状态，
             * 并在采购方案跟踪-采购寻源中展示该集采方案采购包的集采方案、委托书、询价书...合同、订单等 (除采购方案可以查看详情外，其他单据均不可查看详情)
             */
            List<Long> packIds = new ArrayList<>();
            for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                if ("集采实施-自营".equals(sscSchemeTrackExtBO.getSchemeSubmitValue())){
                    packIds.add(sscSchemeTrackExtBO.getPackId());
                }
            }
            if (!CollectionUtils.isEmpty(packIds)){
                //查询 是否有对应的集采包
                List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackByPurchasePackIds(packIds);
                if (!CollectionUtils.isEmpty(saasSchemePackPOS)){
                    Map<String, List<SaasSchemePackPO>> groupBuyPackIdMap = saasSchemePackPOS.stream().collect(Collectors.groupingBy(SaasSchemePackPO::getPurchasePackId));
                    //找到所有的集采包ids
                    List<Long> groupBuyPackIds = saasSchemePackPOS.stream().map(SaasSchemePackPO::getPackId).collect(Collectors.toList());
                    List<SscSchemeTrackSyncFzPO> sscSchemeTrackSyncFzPOS = sscSchemeTrackSyncFzMapper.selectByPackIds(groupBuyPackIds);
                    Map<Long, List<SscSchemeTrackSyncFzPO>> groupBuyPackIdFzMap = new HashMap<>();
                    if (CollectionUtils.isEmpty(sscSchemeTrackSyncFzPOS)){
                        groupBuyPackIdFzMap = sscSchemeTrackSyncFzPOS.stream().collect(Collectors.groupingBy(SscSchemeTrackSyncFzPO::getPackId));
                    }
                    for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                        if (groupBuyPackIdMap.keySet().contains(sscSchemeTrackExtBO.getPackId().toString())){
                            SaasSchemePackPO saasSchemePackPO = groupBuyPackIdMap.get(sscSchemeTrackExtBO.getPackId().toString()).get(0);
                            //替换为集采包的状态
                            sscSchemeTrackExtBO.setSchemeExectStatus(saasSchemePackPO.getPackExectStatus());
                            sscSchemeTrackExtBO.setGroupBuyPackCode(saasSchemePackPO.getPackCode());
                            sscSchemeTrackExtBO.setGroupBuyPackId(saasSchemePackPO.getPackId());
                            sscSchemeTrackExtBO.setGroupBuyPackNo(saasSchemePackPO.getPackNo());
                            if (groupBuyPackIdFzMap.keySet().contains(saasSchemePackPO.getPackId())){
                                //替换询价书信息
                                SscSchemeTrackSyncFzPO sscSchemeTrackSyncFzPO = groupBuyPackIdFzMap.get(saasSchemePackPO.getPackId()).get(0);
                                sscSchemeTrackExtBO.setEnquiryBook(sscSchemeTrackSyncFzPO.getEnquiryBook());
                                sscSchemeTrackExtBO.setQuoteBook(sscSchemeTrackSyncFzPO.getQuoteBook());
                                sscSchemeTrackExtBO.setEnquiryResult(sscSchemeTrackSyncFzPO.getEnquiryResult());
                                sscSchemeTrackExtBO.setEnquirySupplier(sscSchemeTrackSyncFzPO.getEnquirySupplier());
                                sscSchemeTrackExtBO.setEnquiryMoney(sscSchemeTrackSyncFzPO.getEnquiryMoney());
                                sscSchemeTrackExtBO.setEnquiryMat(sscSchemeTrackSyncFzPO.getEnquiryMat());
                                sscSchemeTrackExtBO.setEntrustBook(sscSchemeTrackSyncFzPO.getEntrustBook());
                                sscSchemeTrackExtBO.setBidReport(sscSchemeTrackSyncFzPO.getBidReport());
                                sscSchemeTrackExtBO.setBidSupplier(sscSchemeTrackSyncFzPO.getBidSupplier());
                                sscSchemeTrackExtBO.setBidMoney(sscSchemeTrackSyncFzPO.getBidMoney());
                                sscSchemeTrackExtBO.setBidMat(sscSchemeTrackSyncFzPO.getBidMat());
                                sscSchemeTrackExtBO.setCalibrationReport(sscSchemeTrackSyncFzPO.getCalibrationReport());
                            }
                        }
                    }
                }
            }
        }
        //采购方式字典翻译
        SysDicDictionaryPO searchPO = new SysDicDictionaryPO();
        searchPO.setPCode("PURCH_WAY");
        List<SysDicDictionaryPO> sysDicDictionaryPOS = sysDicDictionaryMapper.selectDictionary(searchPO);
        if (!CollectionUtils.isEmpty(sysDicDictionaryPOS)){
            Map<String, String> codeMap = sysDicDictionaryPOS.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getDescrip));
            for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getPurchaseType())){
                    sscSchemeTrackExtBO.setPurchaseTypeStr(codeMap.get(sscSchemeTrackExtBO.getPurchaseType()));
                }
            }
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setSchemeTrackList(sscSchemeTrackExtBOS);
        return rspBO;
    }

}


