/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.repository.QrySchemeServiceRepository;
import com.tydic.dyc.ssc.repository.dao.SscSchemeMatExtMapper;
import com.tydic.dyc.ssc.repository.po.SscSchemeMatExtPO;
import com.tydic.dyc.ssc.repositoryExt.dao.PlatFormSscSchemeMapper;
import com.tydic.dyc.ssc.repositoryExt.impl.SchemeQryPackCreateUserRepositoryImpl;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryPlanPackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QrySchemeServiceRepositoryImpl
implements QrySchemeServiceRepository {
    private static final Logger log = LoggerFactory.getLogger(QrySchemeServiceRepositoryImpl.class);
    @Autowired
    private PlatFormSscSchemeMapper sscSchemeMapper;
    @Autowired
    private SscSchemeMatExtMapper sscSchemeMatExtMapper;
    private final String PLAN_TYPE = "planType";
    private final String IS_JY_Y = "1";
    private final String IS_JY_N = "0";

    public List<SscQryPlanPackBO> listByParam(SscQrySchemeMainInfoExtBO param) {
        ArrayList<SscQryPlanPackBO> dateList = new ArrayList<SscQryPlanPackBO>();
        List<SscQryPlanPackBO> packBOListCreate = this.converterList(this.sscSchemeMapper.listByParamLimitCreateTime(param));
        List<SscQryPlanPackBO> packBOListUpdate = this.converterList(this.sscSchemeMapper.listByParamLimitUpdateTime(param));
        dateList.addAll(packBOListCreate);
        dateList.addAll(packBOListUpdate);
        dateList = dateList.stream().distinct().collect(Collectors.toList());
        return dateList;
    }

    public List<SscSchemeBO> getDataByParam(SscQrySchemeMainInfoExtBO inparam) {
        ArrayList<SscSchemeBO> boList = new ArrayList<SscSchemeBO>();
        List<Object> dataByParam = new ArrayList<SscSchemePO>();
        List<SscSchemePO> dataByParamCreate = this.sscSchemeMapper.getDataByParamCreate(inparam);
        List<SscSchemePO> dataByParamUpdate = this.sscSchemeMapper.getDataByParamUpdate(inparam);
        dataByParam.addAll(dataByParamCreate);
        dataByParam.addAll(dataByParamUpdate);
        dataByParam = dataByParam.stream().distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dataByParam)) {
            for (SscSchemePO sscSchemePO : dataByParam) {
                SscSchemeBO sscSchemeBO = new SscSchemeBO();
                BeanUtils.copyProperties((Object)sscSchemePO, (Object)sscSchemeBO);
                boList.add(sscSchemeBO);
            }
        }
        return boList;
    }

    private void dealData(SscSchemePO sscSchemePO) {
        SscSchemeMatExtPO sscSchemeMatExtPO = new SscSchemeMatExtPO();
        sscSchemeMatExtPO.setSchemeId(sscSchemePO.getSchemeId());
        sscSchemeMatExtPO.setSchemeMatId(sscSchemePO.getSchemeMatId());
        sscSchemeMatExtPO.setFieldCode("planType");
        SscSchemeMatExtPO modelBy = this.sscSchemeMatExtMapper.getModelBy(sscSchemeMatExtPO);
        log.info("\u67e5\u8be2\u51fa\u7684\u62d3\u5c55\u4fe1\u606fmodelBy\u4e3a:{}" + JSON.toJSONString((Object)modelBy));
        if (modelBy != null) {
            sscSchemePO.setFieldValue(modelBy.getFieldValue());
            sscSchemePO.setFieldName(modelBy.getFieldName());
        }
    }

    private List<SscQryPlanPackBO> converterList(List<SscSchemePO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<SscQryPlanPackBO>();
        }
        ArrayList<SscQryPlanPackBO> resultList = new ArrayList<SscQryPlanPackBO>();
        for (int i = 0; i < list.size(); ++i) {
            SscSchemePO sscSchemePO = list.get(i);
            SscQryPlanPackBO sscQryPlanPackBO = new SscQryPlanPackBO();
            BeanUtils.copyProperties((Object)sscSchemePO, (Object)sscQryPlanPackBO);
            sscQryPlanPackBO.setSchemeClass(Objects.isNull(sscSchemePO.getSchemeClass()) ? null : sscSchemePO.getSchemeClass().toString());
            sscQryPlanPackBO.setCreateCompanCode(sscSchemePO.getCreateCompanyCode());
            sscQryPlanPackBO.setEmergencyFlag(Objects.isNull(sscSchemePO.getEmergencyFlag()) ? null : sscSchemePO.getEmergencyFlag().toString());
            sscQryPlanPackBO.setEstAmount(Objects.isNull(sscSchemePO.getEstAmount()) ? null : sscSchemePO.getEstAmount().toString());
            sscQryPlanPackBO.setImportFlag(Objects.isNull(sscSchemePO.getImportFlag()) ? null : sscSchemePO.getImportFlag().toString());
            sscQryPlanPackBO.setPurchaseType(Objects.isNull(sscSchemePO.getPurchaseType()) ? null : sscSchemePO.getPurchaseType().toString());
            if (SchemeQryPackCreateUserRepositoryImpl.SIMPLE_SCHEME_TYPE.toString().equals(sscSchemePO.getSchemeType())) {
                sscQryPlanPackBO.setIsJY("1");
            } else {
                sscQryPlanPackBO.setIsJY("0");
            }
            resultList.add(sscQryPlanPackBO);
        }
        return resultList;
    }
}

