/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.repository.SscSmartApproveRelationRepository;
import com.tydic.dyc.ssc.repository.po.SscSchemeMatPO;
import com.tydic.dyc.ssc.repositoryExt.comb.api.SscPushChangeSmartApproveService;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.AttorneyLetterInfoBO;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.PurchaseProgrammeInfoBO;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.SimpleInfoBO;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.SscPushChangeSmartApproveReqBO;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.SscPushChangeSmartApproveReqParam;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.SscPushChangeSmartApproveRspBO;
import com.tydic.dyc.ssc.repositoryExt.constant.RelationStatusEnum;
import com.tydic.dyc.ssc.repositoryExt.dao.CrcEntrustMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.PlatFormSscSchemeMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.PlatFormSscSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscPushChangeLogMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeInviteSupExtDealMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeMatExtPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeMatNumMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SysDicDictionaryMapper;
import com.tydic.dyc.ssc.repositoryExt.po.CrcEntrustPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscPushChangeLogPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePackReqPO;
import com.tydic.dyc.ssc.repositoryExt.po.SysDicDictionaryPO;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemePackExtServie;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApprovePushChangeInfoReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApprovePushChangeInfoRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationReqParamBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSmartApproveRelationRspParamBO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscSmartApproveRelationRepositoryImpl
implements SscSmartApproveRelationRepository {
    private static final Logger log = LoggerFactory.getLogger(SscSmartApproveRelationRepositoryImpl.class);
    @Resource
    private PlatFormSscSchemeMapper platFormSscSchemeMapper;
    @Resource
    private PlatFormSscSchemePackMapper platFormSscSchemePackMapper;
    @Resource
    private CrcEntrustMapper crcEntrustMapper;
    @Resource
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Resource
    private SscPushChangeLogMapper sscPushChangeLogMapper;
    @Resource
    private SscSchemeMatExtPackExtMapper sscSchemeMatExtPackExtMapper;
    @Resource
    private SscSchemeMatNumMapper sscSchemeMatNumMapper;
    @Resource
    private SscSchemeInviteSupExtDealMapper sscSchemeInviteSupExtDealMapper;
    @Autowired
    private SscPushChangeSmartApproveService sscPushChangeSmartApproveService;
    @Autowired
    private SscQrySchemePackExtServie sscQrySchemePackExtServie;

    public SscSmartApproveRelationRspBO dealRelationSimpleScheme(SscSmartApproveRelationReqBO reqBO) {
        List<Long> schemeIdList = reqBO.getData().stream().map(SscSmartApproveRelationReqParamBO::getSchemeId).distinct().collect(Collectors.toList());
        SscSchemePO schemePO = new SscSchemePO();
        schemePO.setSchemeIds(schemeIdList);
        schemePO.setSchemeType(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode());
        List<SscSchemePO> sscSchemePOList = this.platFormSscSchemeMapper.getList(schemePO);
        if (CollectionUtils.isEmpty(sscSchemePOList) || sscSchemePOList.size() != schemeIdList.size()) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u65b9\u6848ID\u5b58\u5728\u672a\u5339\u914d\u5230\u7684\u7b80\u6613\u91c7\u8d2d\u8ba1\u5212\uff01");
        }
        ArrayList<SscSchemePO> updateSchemePOList = new ArrayList<SscSchemePO>();
        Map<Long, SscSmartApproveRelationReqParamBO> relationReqParamBOMap = reqBO.getData().stream().collect(Collectors.toMap(SscSmartApproveRelationReqParamBO::getSchemeId, Function.identity(), (k1, k2) -> k1));
        if (RelationStatusEnum.RELATION.getCode().equals(reqBO.getType())) {
            sscSchemePOList.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getFileId())) {
                    throw new BaseBusinessException("292001", "\u5165\u53c2\u65b9\u6848ID:" + e.getSchemeId() + "\u5df2\u7ecf\u5173\u8054" + e.getFileId());
                }
                SscSchemePO updateSchemePO = new SscSchemePO();
                updateSchemePO.setSchemeId(e.getSchemeId());
                updateSchemePO.setRelationStatus(reqBO.getType());
                if (!CollectionUtils.isEmpty((Map)relationReqParamBOMap) && relationReqParamBOMap.containsKey(e.getSchemeId())) {
                    updateSchemePO.setFileId(((SscSmartApproveRelationReqParamBO)relationReqParamBOMap.get(e.getSchemeId())).getFileId());
                    updateSchemePO.setFileItemId(((SscSmartApproveRelationReqParamBO)relationReqParamBOMap.get(e.getSchemeId())).getFileItemId());
                }
                updateSchemePOList.add(updateSchemePO);
            });
        } else {
            sscSchemePOList.forEach(e -> {
                if (Objects.isNull(e.getFileId())) {
                    throw new BaseBusinessException("292001", "\u5165\u53c2\u65b9\u6848ID:" + e.getSchemeId() + "\u5c1a\u672a\u5173\u8054");
                }
                SscSchemePO updateSchemePO = new SscSchemePO();
                updateSchemePO.setSchemeId(e.getSchemeId());
                updateSchemePO.setRelationStatus(reqBO.getType());
                updateSchemePO.setFileId(null);
                updateSchemePO.setFileItemId(null);
                updateSchemePOList.add(updateSchemePO);
            });
        }
        if (!CollectionUtils.isEmpty(updateSchemePOList)) {
            this.platFormSscSchemeMapper.updateRelationStatus(updateSchemePOList);
        }
        SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
        ArrayList sscSchemePack = new ArrayList();
        schemeIdList.forEach(e -> {
            SscQrySchemePackExtBO packExtBO = new SscQrySchemePackExtBO();
            packExtBO.setSchemeId(e);
            sscSchemePack.add(packExtBO);
        });
        sscQrySchemePackExtReqBO.setSscSchemePack(sscSchemePack);
        this.sscQrySchemePackExtServie.syncSchemeESBySchemeIds(sscQrySchemePackExtReqBO);
        Map<Long, List<CrcEntrustPO>> entrustMap = this.relationSchemeEntrust(schemeIdList, reqBO.getType(), relationReqParamBOMap);
        ArrayList paramList = new ArrayList();
        SscSmartApproveRelationRspBO rspBO = new SscSmartApproveRelationRspBO();
        sscSchemePOList.forEach(e -> {
            SscSmartApproveRelationRspParamBO paramBO = new SscSmartApproveRelationRspParamBO();
            paramBO.setSchemeId(e.getSchemeId());
            paramBO.setSchemeCode(e.getSchemeCode());
            paramBO.setSchemeName(e.getSchemeName());
            paramBO.setSchemeNo(e.getSchemeNo());
            if (!CollectionUtils.isEmpty((Map)entrustMap) && entrustMap.containsKey(e.getSchemeId())) {
                paramBO.setEntrustId(((CrcEntrustPO)((List)entrustMap.get(e.getSchemeId())).get(0)).getEntrustId());
                paramBO.setEntrustCode(((CrcEntrustPO)((List)entrustMap.get(e.getSchemeId())).get(0)).getEntrustCode());
                paramBO.setEntrustName(((CrcEntrustPO)((List)entrustMap.get(e.getSchemeId())).get(0)).getEntrustName());
                paramBO.setEntrustNo(((CrcEntrustPO)((List)entrustMap.get(e.getSchemeId())).get(0)).getEntrustNo());
            }
            paramList.add(paramBO);
        });
        rspBO.setRows(paramList);
        rspBO.setRespDesc("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscSmartApproveRelationRspBO dealRelationPack(SscSmartApproveRelationReqBO reqBO) {
        List<Long> packIdList = reqBO.getData().stream().map(SscSmartApproveRelationReqParamBO::getPackId).distinct().collect(Collectors.toList());
        SscSchemePackReqPO packPO = new SscSchemePackReqPO();
        packPO.setPackIds(packIdList);
        List<SscSchemePackReqPO> packExtPOList = this.platFormSscSchemePackMapper.getList(packPO);
        if (CollectionUtils.isEmpty(packExtPOList) || packExtPOList.size() != packIdList.size()) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u65b9\u6848\u5305ID\u5b58\u5728\u672a\u5339\u914d\u5230\u7684\u91c7\u8d2d\u65b9\u6848\u5305\uff01");
        }
        ArrayList<SscSchemePackReqPO> updatePackExtPOList = new ArrayList<SscSchemePackReqPO>();
        Map<Long, SscSmartApproveRelationReqParamBO> relationReqParamBOMap = reqBO.getData().stream().collect(Collectors.toMap(SscSmartApproveRelationReqParamBO::getPackId, Function.identity(), (k1, k2) -> k1));
        if (RelationStatusEnum.RELATION.getCode().equals(reqBO.getType())) {
            packExtPOList.forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getFileId())) {
                    throw new BaseBusinessException("292001", "\u5165\u53c2\u65b9\u6848\u5305ID:" + e.getPackId() + "\u5df2\u7ecf\u5173\u8054" + e.getFileId());
                }
                SscSchemePackReqPO updateSchemePackPO = new SscSchemePackReqPO();
                updateSchemePackPO.setPackId(e.getPackId());
                updateSchemePackPO.setRelationStatus(reqBO.getType());
                if (!CollectionUtils.isEmpty((Map)relationReqParamBOMap) && relationReqParamBOMap.containsKey(e.getPackId())) {
                    updateSchemePackPO.setFileId(((SscSmartApproveRelationReqParamBO)relationReqParamBOMap.get(e.getPackId())).getFileId());
                    updateSchemePackPO.setFileItemId(((SscSmartApproveRelationReqParamBO)relationReqParamBOMap.get(e.getPackId())).getFileItemId());
                }
                updatePackExtPOList.add(updateSchemePackPO);
            });
        } else {
            packExtPOList.forEach(e -> {
                if (Objects.isNull(e.getFileId())) {
                    throw new BaseBusinessException("292001", "\u5165\u53c2\u65b9\u6848\u5305ID:" + e.getPackId() + "\u5c1a\u672a\u5173\u8054");
                }
                SscSchemePackReqPO updateSchemePackPO = new SscSchemePackReqPO();
                updateSchemePackPO.setPackId(e.getPackId());
                updateSchemePackPO.setRelationStatus(reqBO.getType());
                updateSchemePackPO.setFileId(null);
                updateSchemePackPO.setFileItemId(null);
                updatePackExtPOList.add(updateSchemePackPO);
            });
        }
        if (!CollectionUtils.isEmpty(updatePackExtPOList)) {
            this.platFormSscSchemePackMapper.updateRelationStatus(updatePackExtPOList);
        }
        ArrayList sscSchemePack = new ArrayList();
        packIdList.forEach(e -> {
            SscQrySchemePackExtBO packExtBO = new SscQrySchemePackExtBO();
            packExtBO.setPackId(e);
            sscSchemePack.add(packExtBO);
        });
        SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
        sscQrySchemePackExtReqBO.setSscSchemePack(sscSchemePack);
        this.sscQrySchemePackExtServie.syncSchemePackES(sscQrySchemePackExtReqBO);
        Map<Long, List<CrcEntrustPO>> entrustMap = this.relationPackEntrust(packIdList, reqBO.getType(), relationReqParamBOMap);
        SscSmartApproveRelationRspBO rspBO = new SscSmartApproveRelationRspBO();
        ArrayList paramList = new ArrayList();
        packExtPOList.forEach(e -> {
            SscSmartApproveRelationRspParamBO paramBO = new SscSmartApproveRelationRspParamBO();
            paramBO.setPackId(e.getPackId());
            paramBO.setPackCode(e.getPackCode());
            paramBO.setPackName(e.getPackName());
            paramBO.setPackNo(e.getPackNo());
            if (!CollectionUtils.isEmpty((Map)entrustMap) && entrustMap.containsKey(e.getPackId())) {
                paramBO.setEntrustId(((CrcEntrustPO)((List)entrustMap.get(e.getPackId())).get(0)).getEntrustId());
                paramBO.setEntrustCode(((CrcEntrustPO)((List)entrustMap.get(e.getPackId())).get(0)).getEntrustCode());
                paramBO.setEntrustName(((CrcEntrustPO)((List)entrustMap.get(e.getPackId())).get(0)).getEntrustName());
                paramBO.setEntrustNo(((CrcEntrustPO)((List)entrustMap.get(e.getPackId())).get(0)).getEntrustNo());
            }
            paramList.add(paramBO);
        });
        rspBO.setRows(paramList);
        rspBO.setRespDesc("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscSmartApprovePushChangeInfoRspBO dealPushChangeInfo(SscSmartApprovePushChangeInfoReqBO reqBO) {
        SscSmartApprovePushChangeInfoRspBO rspBO = new SscSmartApprovePushChangeInfoRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        SscSchemePO sscSchemePO = new SscSchemePO();
        sscSchemePO.setSchemeId(reqBO.getSchemeId());
        SscSchemePO schemePO = this.platFormSscSchemeMapper.getBySchemeId(sscSchemePO);
        if (Objects.isNull(schemePO)) {
            throw new BaseBusinessException("292001", "\u672a\u67e5\u8be2\u5230\u65b9\u6848\u4fe1\u606f\uff01");
        }
        if (SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(schemePO.getSchemeType())) {
            this.pushSimple(reqBO, schemePO);
        } else {
            this.pushPack(reqBO, schemePO);
        }
        return rspBO;
    }

    private void pushSimple(SscSmartApprovePushChangeInfoReqBO reqBO, SscSchemePO schemePO) {
        SscPushChangeSmartApproveReqBO sscPushChangeSmartApproveReqBO = new SscPushChangeSmartApproveReqBO();
        SscPushChangeSmartApproveReqParam sscPushChangeSmartApproveReqParam = new SscPushChangeSmartApproveReqParam();
        if (!RelationStatusEnum.RELATION.getCode().equals(schemePO.getRelationStatus())) {
            return;
        }
        SimpleInfoBO simpleInfoBO = new SimpleInfoBO();
        BeanUtils.copyProperties((Object)schemePO, (Object)simpleInfoBO);
        simpleInfoBO.setPurchaseTypeStr(Objects.isNull(schemePO.getPurchaseType()) ? null : this.translateDic("PURCH_WAY", String.valueOf(schemePO.getPurchaseType())));
        simpleInfoBO.setSchemeClassStr(Objects.isNull(schemePO.getSchemeClass()) ? null : this.translateDic("SCHEME_CLASS", String.valueOf(schemePO.getSchemeClass())));
        simpleInfoBO.setSchemeAuditStatusStr(this.translateDic("APPROVAL_TYPE", schemePO.getSchemeAuditStatus()));
        simpleInfoBO.setSchemeStatusStr(this.translateDic("SCHEME_STATUS", schemePO.getSchemeStatus()));
        simpleInfoBO.setCreateTimeStr(DateUtils.dateToStr((Date)schemePO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        SscSchemeMatPO schemeMatPO = new SscSchemeMatPO();
        schemeMatPO.setSchemeId(reqBO.getSchemeId());
        List<SscSchemeMatPO> schemeMatPOList = this.sscSchemeMatExtPackExtMapper.getSchemeMatList(schemeMatPO);
        if (!CollectionUtils.isEmpty(schemeMatPOList)) {
            simpleInfoBO.setItemInfo(JSON.parseArray((String)JSON.toJSONString(schemeMatPOList), SscSchemeMatExtBO.class));
        }
        sscPushChangeSmartApproveReqParam.setSimpleInfo(simpleInfoBO);
        CrcEntrustPO crcEntrustPO = new CrcEntrustPO();
        crcEntrustPO.setSchemeId(reqBO.getSchemeId());
        List<CrcEntrustPO> crcEntrustPOList = this.crcEntrustMapper.queryList(crcEntrustPO);
        if (!CollectionUtils.isEmpty(crcEntrustPOList)) {
            CrcEntrustPO entrustPO = crcEntrustPOList.get(0);
            if (!RelationStatusEnum.RELATION.getCode().equals(entrustPO.getRelationStatus())) {
                crcEntrustPOList.forEach(e -> {
                    e.setRelationStatus(RelationStatusEnum.RELATION.getCode());
                    e.setFileId(schemePO.getFileId());
                    e.setFileItemId(schemePO.getFileItemId());
                });
                this.crcEntrustMapper.updateRelationStatus(crcEntrustPOList);
            }
            AttorneyLetterInfoBO attorneyLetterInfoBO = new AttorneyLetterInfoBO();
            BeanUtils.copyProperties((Object)entrustPO, (Object)attorneyLetterInfoBO);
            attorneyLetterInfoBO.setEstAmount(entrustPO.getYsje());
            attorneyLetterInfoBO.setPurTypeStr(this.translateDic("PURCH_WAY", entrustPO.getPurType()));
            attorneyLetterInfoBO.setSchemeClassStr(Objects.isNull(schemePO.getSchemeClass()) ? null : this.translateDic("SCHEME_CLASS", String.valueOf(schemePO.getSchemeClass())));
            if (!CollectionUtils.isEmpty(schemeMatPOList)) {
                attorneyLetterInfoBO.setItemInfo(JSON.parseArray((String)JSON.toJSONString(schemeMatPOList), SscSchemeMatExtBO.class));
            }
            sscPushChangeSmartApproveReqParam.setAttorneyLetterInfo(attorneyLetterInfoBO);
        } else {
            sscPushChangeSmartApproveReqParam.setAttorneyLetterInfo(new AttorneyLetterInfoBO());
        }
        sscPushChangeSmartApproveReqParam.setPurchaseProgrammeInfos(new PurchaseProgrammeInfoBO());
        sscPushChangeSmartApproveReqBO.setFileId(schemePO.getFileId());
        sscPushChangeSmartApproveReqBO.setData(Collections.singletonList(sscPushChangeSmartApproveReqParam));
        SscPushChangeSmartApproveRspBO sscPushChangeSmartApproveRspBO = this.sscPushChangeSmartApproveService.pushChange(sscPushChangeSmartApproveReqBO);
        int pushStatus = 0;
        String rspData = "";
        if (Objects.nonNull((Object)sscPushChangeSmartApproveRspBO)) {
            if ("0000".equals(sscPushChangeSmartApproveRspBO.getRespCode())) {
                pushStatus = 1;
            }
            rspData = sscPushChangeSmartApproveRspBO.getRespData();
        }
        this.insertLog(reqBO.getSchemeId(), 2, pushStatus, JSON.toJSONString((Object)sscPushChangeSmartApproveReqBO), rspData);
    }

    private void pushPack(SscSmartApprovePushChangeInfoReqBO reqBO, SscSchemePO schemePO) {
        SscSchemePackReqPO sscSchemePackReqPO = new SscSchemePackReqPO();
        sscSchemePackReqPO.setSchemeId(reqBO.getSchemeId());
        sscSchemePackReqPO.setPackId(reqBO.getPackId());
        List<SscSchemePackReqPO> packPOList = this.platFormSscSchemePackMapper.getList(sscSchemePackReqPO);
        if (CollectionUtils.isEmpty(packPOList)) {
            return;
        }
        ArrayList<SscPushChangeSmartApproveReqParam> paramList = new ArrayList<SscPushChangeSmartApproveReqParam>();
        packPOList.forEach(e -> {
            if (!RelationStatusEnum.RELATION.getCode().equals(e.getRelationStatus())) {
                return;
            }
            int matNum = this.sscSchemeMatNumMapper.getMatNum(e.getPackId());
            int supNum = this.sscSchemeInviteSupExtDealMapper.getSupNum(e.getPackId());
            SscSchemeMatPO schemeMatPO = new SscSchemeMatPO();
            schemeMatPO.setSchemeId(reqBO.getSchemeId());
            List<SscSchemeMatPO> schemeMatPOList = this.sscSchemeMatExtPackExtMapper.getSchemeMatList(schemeMatPO);
            SscPushChangeSmartApproveReqParam sscPushChangeSmartApproveReqParam = new SscPushChangeSmartApproveReqParam();
            PurchaseProgrammeInfoBO purchaseProgrammeInfoBO = new PurchaseProgrammeInfoBO();
            BeanUtils.copyProperties((Object)e, (Object)purchaseProgrammeInfoBO);
            purchaseProgrammeInfoBO.setSchemeClassStr(Objects.isNull(schemePO.getSchemeClass()) ? null : this.translateDic("SCHEME_CLASS", String.valueOf(schemePO.getSchemeClass())));
            purchaseProgrammeInfoBO.setPurTypeStr(Objects.isNull(schemePO.getPurchaseType()) ? null : this.translateDic("PURCH_WAY", String.valueOf(schemePO.getPurchaseType())));
            purchaseProgrammeInfoBO.setSchemeCode(schemePO.getSchemeCode());
            purchaseProgrammeInfoBO.setSchemeName(schemePO.getSchemeName());
            purchaseProgrammeInfoBO.setSchemeNo(schemePO.getSchemeNo());
            purchaseProgrammeInfoBO.setMatNum(matNum);
            purchaseProgrammeInfoBO.setSupNum(supNum);
            purchaseProgrammeInfoBO.setEstAmount(schemePO.getEstAmount());
            purchaseProgrammeInfoBO.setCreateUsername(schemePO.getCreateUsername());
            purchaseProgrammeInfoBO.setCreateName(schemePO.getCreateName());
            purchaseProgrammeInfoBO.setCreateTime(schemePO.getCreateTime());
            purchaseProgrammeInfoBO.setSchemeVersion(schemePO.getSchemeVersion());
            if (!CollectionUtils.isEmpty(schemeMatPOList)) {
                purchaseProgrammeInfoBO.setItemInfo(JSON.parseArray((String)JSON.toJSONString(schemeMatPOList), SscSchemeMatExtBO.class));
            }
            sscPushChangeSmartApproveReqParam.setPurchaseProgrammeInfos(purchaseProgrammeInfoBO);
            CrcEntrustPO crcEntrustPO = new CrcEntrustPO();
            crcEntrustPO.setPackId(e.getPackId());
            List<CrcEntrustPO> crcEntrustPOList = this.crcEntrustMapper.queryList(crcEntrustPO);
            if (!CollectionUtils.isEmpty(crcEntrustPOList)) {
                CrcEntrustPO entrustPO = crcEntrustPOList.get(0);
                if (!RelationStatusEnum.RELATION.getCode().equals(entrustPO.getRelationStatus())) {
                    crcEntrustPOList.forEach(entrust -> {
                        entrust.setRelationStatus(RelationStatusEnum.RELATION.getCode());
                        entrust.setFileId(e.getFileId());
                        entrust.setFileItemId(e.getFileItemId());
                    });
                    this.crcEntrustMapper.updateRelationStatus(crcEntrustPOList);
                }
                AttorneyLetterInfoBO attorneyLetterInfoBO = new AttorneyLetterInfoBO();
                BeanUtils.copyProperties((Object)entrustPO, (Object)attorneyLetterInfoBO);
                attorneyLetterInfoBO.setPurTypeStr(this.translateDic("PURCH_WAY", entrustPO.getPurType()));
                attorneyLetterInfoBO.setSchemeClassStr(Objects.isNull(schemePO.getSchemeClass()) ? null : this.translateDic("SCHEME_CLASS", String.valueOf(schemePO.getSchemeClass())));
                if (!CollectionUtils.isEmpty(schemeMatPOList)) {
                    attorneyLetterInfoBO.setItemInfo(JSON.parseArray((String)JSON.toJSONString(schemeMatPOList), SscSchemeMatExtBO.class));
                }
                sscPushChangeSmartApproveReqParam.setAttorneyLetterInfo(attorneyLetterInfoBO);
            } else {
                sscPushChangeSmartApproveReqParam.setAttorneyLetterInfo(new AttorneyLetterInfoBO());
            }
            sscPushChangeSmartApproveReqParam.setSimpleInfo(new SimpleInfoBO());
            paramList.add(sscPushChangeSmartApproveReqParam);
        });
        if (!CollectionUtils.isEmpty(paramList)) {
            SscPushChangeSmartApproveReqBO sscPushChangeSmartApproveReqBO = new SscPushChangeSmartApproveReqBO();
            sscPushChangeSmartApproveReqBO.setFileId(((SscPushChangeSmartApproveReqParam)paramList.get(0)).getPurchaseProgrammeInfos().getFileId());
            sscPushChangeSmartApproveReqBO.setData(paramList);
            SscPushChangeSmartApproveRspBO sscPushChangeSmartApproveRspBO = this.sscPushChangeSmartApproveService.pushChange(sscPushChangeSmartApproveReqBO);
            int pushStatus = 0;
            String rspData = "";
            if (Objects.nonNull((Object)sscPushChangeSmartApproveRspBO)) {
                if ("0000".equals(sscPushChangeSmartApproveRspBO.getRespCode())) {
                    pushStatus = 1;
                }
                rspData = sscPushChangeSmartApproveRspBO.getRespData();
            }
            this.insertLog(reqBO.getSchemeId(), 1, pushStatus, JSON.toJSONString((Object)sscPushChangeSmartApproveReqBO), rspData);
        }
    }

    private void insertLog(Long schemeId, int type, int pushStatus, String pushDate, String respData) {
        SscPushChangeLogPO sscPushChangeLogPO = new SscPushChangeLogPO();
        sscPushChangeLogPO.setId(Sequence.getInstance().nextId());
        sscPushChangeLogPO.setSchemeId(schemeId);
        sscPushChangeLogPO.setType(type);
        sscPushChangeLogPO.setPushStatus(pushStatus);
        sscPushChangeLogPO.setPushData(pushDate);
        sscPushChangeLogPO.setRespData(respData);
        sscPushChangeLogPO.setPushTime(new Date());
        this.sscPushChangeLogMapper.insert(sscPushChangeLogPO);
    }

    private String translateDic(String pCode, String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String descrip = "";
        SysDicDictionaryPO pi = new SysDicDictionaryPO();
        pi.setPCode(pCode);
        List<SysDicDictionaryPO> selectDictionary = this.sysDicDictionaryMapper.selectDictionary(pi);
        if (!CollectionUtils.isEmpty(selectDictionary)) {
            for (SysDicDictionaryPO dictionaryPO : selectDictionary) {
                if (!str.equals(dictionaryPO.getCode())) continue;
                descrip = dictionaryPO.getDescrip();
                break;
            }
        }
        return descrip;
    }

    private Map<Long, List<CrcEntrustPO>> relationSchemeEntrust(List<Long> schemeIdList, Integer type, Map<Long, SscSmartApproveRelationReqParamBO> relationReqParamBOMap) {
        Map<Long, List<CrcEntrustPO>> entrustMap = new HashMap<Long, List<CrcEntrustPO>>();
        ArrayList<CrcEntrustPO> updateEntrustPOList = new ArrayList<CrcEntrustPO>();
        CrcEntrustPO crcEntrustPO = new CrcEntrustPO();
        crcEntrustPO.setSchemeIds(schemeIdList);
        List<CrcEntrustPO> crcEntrustPOList = this.crcEntrustMapper.queryList(crcEntrustPO);
        if (!CollectionUtils.isEmpty(crcEntrustPOList)) {
            crcEntrustPOList.forEach(e -> {
                CrcEntrustPO entrustPO = new CrcEntrustPO();
                entrustPO.setEntrustId(e.getEntrustId());
                entrustPO.setRelationStatus(type);
                if (RelationStatusEnum.RELATION.getCode().equals(type)) {
                    if (!CollectionUtils.isEmpty((Map)relationReqParamBOMap) && relationReqParamBOMap.containsKey(e.getSchemeId())) {
                        entrustPO.setFileId(((SscSmartApproveRelationReqParamBO)relationReqParamBOMap.get(e.getSchemeId())).getFileId());
                        entrustPO.setFileItemId(((SscSmartApproveRelationReqParamBO)relationReqParamBOMap.get(e.getSchemeId())).getFileItemId());
                    }
                } else {
                    entrustPO.setFileId(null);
                    entrustPO.setFileItemId(null);
                }
                updateEntrustPOList.add(entrustPO);
            });
            if (!CollectionUtils.isEmpty(updateEntrustPOList)) {
                this.crcEntrustMapper.updateRelationStatus(updateEntrustPOList);
            }
            entrustMap = crcEntrustPOList.stream().collect(Collectors.groupingBy(CrcEntrustPO::getSchemeId));
        }
        return entrustMap;
    }

    private Map<Long, List<CrcEntrustPO>> relationPackEntrust(List<Long> packIdList, Integer type, Map<Long, SscSmartApproveRelationReqParamBO> relationReqParamBOMap) {
        Map<Long, List<CrcEntrustPO>> entrustMap = new HashMap<Long, List<CrcEntrustPO>>();
        ArrayList<CrcEntrustPO> updateEntrustPOList = new ArrayList<CrcEntrustPO>();
        CrcEntrustPO crcEntrustPO = new CrcEntrustPO();
        crcEntrustPO.setPackIds(packIdList);
        List<CrcEntrustPO> crcEntrustPOList = this.crcEntrustMapper.queryList(crcEntrustPO);
        if (!CollectionUtils.isEmpty(crcEntrustPOList)) {
            crcEntrustPOList.forEach(e -> {
                CrcEntrustPO entrustPO = new CrcEntrustPO();
                entrustPO.setEntrustId(e.getEntrustId());
                entrustPO.setRelationStatus(type);
                if (RelationStatusEnum.RELATION.getCode().equals(type)) {
                    if (!CollectionUtils.isEmpty((Map)relationReqParamBOMap) && relationReqParamBOMap.containsKey(e.getPackId())) {
                        entrustPO.setFileId(((SscSmartApproveRelationReqParamBO)relationReqParamBOMap.get(e.getPackId())).getFileId());
                        entrustPO.setFileItemId(((SscSmartApproveRelationReqParamBO)relationReqParamBOMap.get(e.getPackId())).getFileItemId());
                    }
                } else {
                    entrustPO.setFileId(null);
                    entrustPO.setFileItemId(null);
                }
                updateEntrustPOList.add(entrustPO);
            });
            if (!CollectionUtils.isEmpty(updateEntrustPOList)) {
                this.crcEntrustMapper.updateRelationStatus(updateEntrustPOList);
            }
            entrustMap = crcEntrustPOList.stream().collect(Collectors.groupingBy(CrcEntrustPO::getPackId));
        }
        return entrustMap;
    }
}

