/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.bo.SscSchemeRspBO;
import com.tydic.dyc.ssc.repositoryExt.config.SscThreadPoolExecutorUtil;
import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemePackExtServie;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeBO;
import com.tydic.dyc.ssc.service.scheme.syncSchemeListService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.syncSchemeListService"})
public class syncSchemeListServiceImpl
implements syncSchemeListService {
    private static final Logger log = LoggerFactory.getLogger(syncSchemeListServiceImpl.class);
    @Autowired
    private SaasSchemePackMapper schemePackMapper;
    @Value(value="${PAGE_SIZE:100}")
    private int PAGE_SIZE;
    @Value(value="${MaxSize:200}")
    private int MaxSize;
    @Autowired
    private SscQrySchemePackExtServie schemePackExtServie;
    private static final ThreadPoolExecutor threadPoolExecutor = SscThreadPoolExecutorUtil.poolExecutor;

    @PostMapping(value={"syncSchemeList"})
    public SscQrySchemePackExtRspBO syncSchemeList(@RequestBody SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO busiRspBO = new SscQrySchemePackExtRspBO();
        log.error("\u540c\u6b65\u65b9\u6848ES\u5f00\u542f=====");
        if (CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds()) && null == reqBO.getSchemeId()) {
            busiRspBO.setRespCode("0001");
            busiRspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return busiRspBO;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            ids.addAll(reqBO.getSchemeIds());
        }
        if (null != reqBO.getSchemeId()) {
            ids.add(reqBO.getSchemeId());
        }
        ArrayList<SscQrySchemePackExtBO> syncList = new ArrayList<SscQrySchemePackExtBO>();
        for (Long schemeId : ids) {
            SscQrySchemePackExtBO sscQrySchemePackExtBO = new SscQrySchemePackExtBO();
            sscQrySchemePackExtBO.setSchemeId(schemeId);
            syncList.add(sscQrySchemePackExtBO);
        }
        this.dealData(syncList);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    @PostMapping(value={"qrySchemeByPlanId"})
    public SchemeListRspBO qrySchemeByPlanId(@RequestBody SscQrySchemePackExtReqBO reqBO) {
        SchemeListRspBO rspBO = new SchemeListRspBO();
        if (Objects.isNull(reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getPlanId()) && CollectionUtils.isEmpty((Collection)reqBO.getPlanIds())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SscSchemeBO> sscSchemeBOS = this.schemePackMapper.qrySchemeByPlan(reqBO);
        if (!CollectionUtils.isEmpty(sscSchemeBOS)) {
            rspBO.setSchemeList(JSON.parseArray((String)JSON.toJSONString(sscSchemeBOS), SscSchemeRspBO.class));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealData(List<SscQrySchemePackExtBO> syncList) {
        CompletableFuture.runAsync(() -> {
            for (SscQrySchemePackExtBO sscQrySchemePackExtBO : syncList) {
                Long objId = this.schemePackMapper.queryObjId(sscQrySchemePackExtBO.getSchemeId());
                log.error("Objid============" + objId);
                log.error("SchemeId()============" + sscQrySchemePackExtBO.getSchemeId());
                if (null == objId) continue;
                SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
                sscQrySchemePackExtReqBO.setOrderId(sscQrySchemePackExtBO.getSchemeId());
                sscQrySchemePackExtReqBO.setObjId(objId);
                this.schemePackExtServie.syncTaskBySchemeId(sscQrySchemePackExtReqBO);
            }
        });
    }
}

