package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.repository.CrcItemQueryExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.CrcItemPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.po.CrcItemPackExtPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：询源明细查询基建层接口接口实现类
 * 时间：2023/08/14
 */
@Service
public class CrcItemQueryExtRepositoryImpl implements CrcItemQueryExtRepository {

    /**
     * 询源明细查询 Mapper
     */
    @Autowired
    private CrcItemPackExtMapper crcItemPackExtMapper;

    /**
     * 查询询源定标明细数量信息集合
     */
    @Override
    public CrcItemDbQryListExtRspBO getItemDbCountInfoList(CrcItemDbQryListExtReqBO reqBO) {
        CrcItemDbQryListExtRspBO rspBO = new CrcItemDbQryListExtRspBO();

        //定义询源明细查询集合
        List<CrcItemPackExtPO> crcItemPackExtPOList = new ArrayList<>(10);

        //定义询源明细查询条件入参
        CrcItemPackExtPO queryCrcItemPackExtPO = new CrcItemPackExtPO();
        //设置明细ID集合
        queryCrcItemPackExtPO.setItemIds(reqBO.getItemIds());

        if (reqBO.getQueryType() == 1){
            //调用根据明细ID集合查询 集中采购 列表数据
            crcItemPackExtPOList = this.crcItemPackExtMapper.getFindSourceItemDbCountInfoList(queryCrcItemPackExtPO);
        }
        if (reqBO.getQueryType() == 2){
            //调用根据明细ID集合查询 委托采购 列表数据
            crcItemPackExtPOList = this.crcItemPackExtMapper.getEntrustItemDbCountInfoList(queryCrcItemPackExtPO);
        }
        if (reqBO.getQueryType() == 3){
            //调用根据明细ID集合查询 自行采购 列表数据
            crcItemPackExtPOList = this.crcItemPackExtMapper.getInquiryItemDbCountInfoList(queryCrcItemPackExtPO);
        }

        //询源明细列表数据转换
        List<CrcItemDbQryExtBO> crcItemDbQryExtBOList = JSON.parseArray(JSON.toJSONString(crcItemPackExtPOList), CrcItemDbQryExtBO.class);

        //出参
        rspBO.setCrcItemDbExtBOList(crcItemDbQryExtBOList);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);

        return rspBO;
    }

}
