package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.bo.SchemePushLogBO;
import com.tydic.dyc.ssc.bo.SchemePushLogReqBO;
import com.tydic.dyc.ssc.bo.SchemePushLogRspBO;
import com.tydic.dyc.ssc.repository.SchemePushLogRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SchemePushLogMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SchemePushLogPO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者 85222
 * 创建日期 2023年05月06日
 */
@Slf4j
@Service
public class SchemePushLogRepositoryImpl implements SchemePushLogRepository {
    @Autowired
    private SchemePushLogMapper schemePushLogMapper;
    @Override
    public int insert(SchemePushLogBO bo) {
        SchemePushLogPO po = JUtil.js(bo, SchemePushLogPO.class);
        po.setId(Sequence.getInstance().nextId());
        int count = 0;
        try {
            log.info("记录日志开始");
            count = schemePushLogMapper.insert(po);
            if (count ==0){
                throw new ZTBusinessException("插入数据失败");
            }
        }catch (Exception e){
            log.error("记录推送日志异常"+e.getMessage());
        }
        return count;
    }

    @Override
    public SchemePushLogRspBO insertBatch(SchemePushLogReqBO reqBO) {
        SchemePushLogRspBO rspBO = new SchemePushLogRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getBos())){
            List<SchemePushLogPO> list = new ArrayList<>();
            for (SchemePushLogBO bo : reqBO.getBos()) {
                SchemePushLogPO po = JSONObject.parseObject(JSONObject.toJSONString(bo), SchemePushLogPO.class);
                po.setId(Sequence.getInstance().nextId());
                list.add(po);
            }
            schemePushLogMapper.insertBatch(list);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }
}


