package com.tydic.dyc.ssc.repositoryExt.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.repository.SchemeQryPackCreateUserRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscPlanPackMapper;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import com.tydic.ppc.ability.api.PlanQryPackCreateUserAbilityService;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserAbilityReqBO;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserAbilityRspBO;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserBO;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 描述:非招的数据查询原始打包人（创建人）
 *
 * @author XiaWD
 * @date 2023/11/2 10:13
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@Service
public class SchemeQryPackCreateUserRepositoryImpl implements SchemeQryPackCreateUserRepository {
    /**
     * 简易计划
     */
    public static final Integer SIMPLE_SCHEME_TYPE=2;
    /**
     * 采购方案
     */
    private final Integer PURCHASE_SCHEME_TYPE=3;
    /**
     * 集采方案类型
     */
    private final Integer COLLECT_SCHEME_TYPE=4;
    @Autowired
    private SscPlanPackMapper sscPlanPackMapper;
    /**
     * 扩展字段的编码
     */
    private final String purchasePackId="purchasePackId";
    @HTServiceRef
    private PlanQryPackCreateUserAbilityService planQryPackCreateUserAbilityService;
    @Autowired
    private SaasSchemePackMapper saasSchemePackMapper;
    @Override
    public SchemeQryPackCreateUserRspBO qryPackCreateUser(SchemeQryPackCreateUserReqBO reqBO) {
        SchemeQryPackCreateUserRspBO rspBO = new SchemeQryPackCreateUserRspBO();
        List<SchemeQryPackCreateUserBO> bos = new ArrayList<>();//包id对应的原始数据
        if (!CollectionUtils.isEmpty(reqBO.getBos())){
            //简易计划
            List<Long> simplePackIds = new ArrayList<>();
            //采购方案
            List<Long> purchasePackIds = new ArrayList<>();
            //集采方案
            List<Long> collectPackIds = new ArrayList<>();
            //查询计划分流的包id
            List<Long> qryPlanPackIds = new ArrayList<>();
            //原始包id对应现在集采包id Map
            Map<Long,Long> packPurchasePackIdMap = new HashMap<>();
            for (SchemeQryPackCreateUserBO bo : reqBO.getBos()) {
                if (SIMPLE_SCHEME_TYPE.equals(bo.getSchemeType())){
                    simplePackIds.add(bo.getPackId());
                }
                if (PURCHASE_SCHEME_TYPE.equals(bo.getSchemeType())){
                    purchasePackIds.add(bo.getPackId());
                }
                if (COLLECT_SCHEME_TYPE.equals(bo.getSchemeType())){
                    collectPackIds.add(bo.getPackId());
                }
            }
            if (!CollectionUtils.isEmpty(simplePackIds)){
                //简易计划包id就是方案id，查询方案数据
                List<SscQrySchemePackExtBO> extBOS = saasSchemePackMapper.qrySchemeOrganizationFormBySchemeIds(simplePackIds);
                if (!CollectionUtils.isEmpty(extBOS)){
                    for (SscQrySchemePackExtBO extBO : extBOS) {
                        SchemeQryPackCreateUserBO createUserBO = new SchemeQryPackCreateUserBO();
                        createUserBO.setPackId(extBO.getSchemeId());
                        createUserBO.setAwardUserName(extBO.getCreateName());
                        createUserBO.setAwardEmployeeNumber(extBO.getCreateUsername());
                        bos.add(createUserBO);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(purchasePackIds)){
                //采购包直接查询计划吧
                qryPlanPackIds.addAll(purchasePackIds);
            }
            if (!CollectionUtils.isEmpty(collectPackIds)){
                //集采的包要去判断是不是从采购包过来的数据，如果是采购包
                //查询扩展字段
                List<SscQryPlanPackBO> sscQryPlanPackBOS = sscPlanPackMapper.selectPurchasePackIdByPackIds(collectPackIds);
                qryPlanPackIds.addAll(collectPackIds);
                for (SscQryPlanPackBO ext : sscQryPlanPackBOS) {
                    if (purchasePackId.equals(ext.getFieldCode()) && !StringUtils.isEmpty(ext.getFieldValue())){
                        //从采购包过来生成的数据
                        try {
                            //采购包id
                            Long packPurchasePackId = Long.valueOf(ext.getFieldValue());
                            //移除当前集采包Id
                            qryPlanPackIds.remove(ext.getPackId());
                            //添加当前采购包id
                            qryPlanPackIds.add(packPurchasePackId);
                            //添加关系
                            packPurchasePackIdMap.put(packPurchasePackId,ext.getPackId());
                        }catch (Exception e){
                            log.error("转换包Id失败");
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(qryPlanPackIds)){
                if (!CollectionUtils.isEmpty(qryPlanPackIds)){
                    //查询计划原始的打包人
                    PlanQryPackCreateUserAbilityReqBO abilityReqBO = new PlanQryPackCreateUserAbilityReqBO();
                    abilityReqBO.setPackIds(qryPlanPackIds);
                    try {
                        PlanQryPackCreateUserAbilityRspBO abilityRspBO = planQryPackCreateUserAbilityService.qryPackCreateUser(abilityReqBO);
                        if (RspConstant.RESP_CODE_SUCCESS.equals(abilityRspBO.getRespCode())){
                            if (!CollectionUtils.isEmpty(abilityRspBO.getBos())){
                                for (PlanQryPackCreateUserBO bo : abilityRspBO.getBos()) {
                                    SchemeQryPackCreateUserBO createUserBO = new SchemeQryPackCreateUserBO();
                                    createUserBO.setPackId(bo.getPackId());
                                    //判断是否是集采方案包的采购包id
                                    if (packPurchasePackIdMap.containsKey(bo.getPackId())){
                                        createUserBO.setPackId(packPurchasePackIdMap.get(bo.getPackId()));
                                    }
                                    createUserBO.setAwardUserName(bo.getAwardUserName());
                                    createUserBO.setAwardEmployeeNumber(bo.getAwardEmployeeNumber());
                                    bos.add(createUserBO);
                                }
                            }
                        }else {
                            throw new ZTBusinessException(abilityRspBO.getRespDesc());
                        }
                    }catch (Exception e){
                        log.error(e.getMessage());
                        throw new ZTBusinessException("查询原始打包人失败"+e.getMessage());
                    }
                }
            }
        }
        rspBO.setBos(bos);
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
