package com.tydic.dyc.ssc.repositoryExt.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.repository.SscAwardResultPackExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.*;
import com.tydic.dyc.ssc.repositoryExt.po.*;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryPlanPackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeTenderReportListBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import com.tydic.ppc.ability.api.PlanQryPackCreateUserAbilityService;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserAbilityReqBO;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserAbilityRspBO;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserBO;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：采购方案询比结果基建层接口实现类
 * 时间：2023/08/07
 */
@Slf4j
@Service
public class SscAwardResultPackExtRepositoryImpl implements SscAwardResultPackExtRepository {

    /**
     * 采购方案询比结果 Mapper
     */
    @Autowired
    private SscAwardResultPackExtMapper sscAwardResultPackExtMapper;

    /**
     * 采购方案明细扩展 Mapper
     */
    @Autowired
    private SscSchemeMatExtPackExtMapper sscSchemeMatExtPackExtMapper;

    /**
     * 采购方案 Mapper
     */
    @Autowired
    private SscSchemePackageExtMapper sscSchemePackageExtMapper;
    /**
     * 集采方案类型
     */
    private final Integer COLLECT_SCHEME_TYPE=4;
    /**
     * 扩展字段的编码
     */
    private final String purchasePackId="purchasePackId";
    @Autowired
    private SscPlanPackMapper sscPlanPackMapper;
    @HTServiceRef
    private PlanQryPackCreateUserAbilityService planQryPackCreateUserAbilityService;
    @Autowired
    private CrcNoticeMapper crcNoticeMapper;
    @Autowired
    private CrcSchemeFindsourceSupNoticeMapper crcSchemeFindsourceSupNoticeMapper;
    /**
     * 采购方案询比结果列表分页查询
     */
    @Override
    public SscQryAwardResultExtRspBO getAwardResultList(SscQryAwardResultExtReqBO reqBO) {
        SscQryAwardResultExtRspBO rspBO = new SscQryAwardResultExtRspBO();

        //设置分页参数
        Page<SscAwardResultPackExtPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        //入参条件参数转换
        SscAwardResultQryPackExtPO sscAwardResultQryPackExtPO = JSON.parseObject(JSON.toJSONString(reqBO), SscAwardResultQryPackExtPO.class);

        //定义采购方案询比结果列表集合
        List<SscAwardResultPackExtPO> awardResultListPage = new ArrayList<>(10);

        //校验入参空查询结果
        boolean isNullFlag = this.checkReqNullQueryResult(reqBO);
        if (isNullFlag){
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setRows(new ArrayList<>());
            rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
            rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }

        if (reqBO.getQueryType() == 1){
            //调用根据条件分页查询 集中采购 询比结果列表数据
            awardResultListPage = this.sscAwardResultPackExtMapper.getFindSourceAwardResultListPage(sscAwardResultQryPackExtPO, page);
        }
        if (reqBO.getQueryType() == 2){
            //调用根据条件分页查询 委托采购 询比结果列表数据
            awardResultListPage = this.sscAwardResultPackExtMapper.getEntrustAwardResultListPage(sscAwardResultQryPackExtPO, page);
        }
        if (reqBO.getQueryType() == 3){
            //查询优化：因为分页插件的统计sql很慢，所以进行手动分页，并把统计Sql删除无效关联的表实现优化，后续要改动查询条件需要同时维护统计sql和手动分页查询sql
            //记录总数
            Integer recordsTotal =0;
            //总页数
            Integer total =0;
            recordsTotal = sscAwardResultPackExtMapper.getInquiryAwardResultListCount(sscAwardResultQryPackExtPO);
            //改为直接查询到全部的主键ids，手动统计
            /*List<Long> awardNumIds = sscAwardResultPackExtMapper.getInquiryAwardResultListCountId(sscAwardResultQryPackExtPO);
            if (!CollectionUtils.isEmpty(awardNumIds)){
                recordsTotal = awardNumIds.size();
            }*/
            if (recordsTotal == null || recordsTotal==0){
                rspBO.setPageNo(reqBO.getPageNo());
                rspBO.setRecordsTotal(0);
                rspBO.setTotal(0);
                rspBO.setRows(new ArrayList<>());
                rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
                rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
                return rspBO;
            }
            //计算总页数
            total = recordsTotal % reqBO.getPageSize() == 0 ? recordsTotal / reqBO.getPageSize() : recordsTotal / reqBO.getPageSize() + 1;
            //查询手动分页
            Integer curPage = (reqBO.getPageNo()-1)*reqBO.getPageSize();
            sscAwardResultQryPackExtPO.setPageNo(curPage);
            sscAwardResultQryPackExtPO.setPageSize(reqBO.getPageSize());
            awardResultListPage = sscAwardResultPackExtMapper.getInquiryAwardResultListManualPage(sscAwardResultQryPackExtPO);
            page.setTotalCount(recordsTotal);
            page.setTotalPages(total);
            //调用根据条件分页查询 自行采购 询比结果列表数据
            //注释说明：优化调整，改为手动分页查询，awardResultListPage = this.sscAwardResultPackExtMapper.getInquiryAwardResultListPage(sscAwardResultQryPackExtPO, page);
        }

        //判断结果列表集合为空的返回值
        if (CollectionUtils.isEmpty(awardResultListPage)){
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setRows(new ArrayList<>());
            rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
            rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }
        //因为合同要取计划分流原始的打包人，按照逻辑 只有 采购包分配给人做集采方案的这一部包需要查询原始的打包人
        Map<Long, PlanQryPackCreateUserBO> packIdMap = new HashMap<>();//集采包id对应的原始数据
        if (!CollectionUtils.isEmpty(awardResultListPage)){
            //查询计划分流的包ids
            List<Long> planPackIds = new ArrayList<>();
            Set<String> collect = awardResultListPage.stream().filter(e -> COLLECT_SCHEME_TYPE.equals(e.getSchemeType()) && !StringUtils.isEmpty(e.getPackId())).map(SscAwardResultPackExtPO::getPackId).collect(Collectors.toSet());
            //原始包id对应现在集采包id Map
            Map<Long,Long> packPurchasePackIdMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(collect)){
                //因为集采方案的包可能是分配过来的，所以要查询原始包Ids
                List<Long> list = new ArrayList<>();
                for (String s : collect) {
                    try {
                        list.add(Long.valueOf(s));
                    }catch (Exception e){
                        log.error("转换包Id失败");
                    }
                }
                if (!CollectionUtils.isEmpty(list)){
                    //查询扩展字段
                    List<SscQryPlanPackBO> sscQryPlanPackBOS = sscPlanPackMapper.selectPurchasePackIdByPackIds(list);
                    for (SscQryPlanPackBO ext : sscQryPlanPackBOS) {
                        if (purchasePackId.equals(ext.getFieldCode()) && !StringUtils.isEmpty(ext.getFieldValue())){
                            //从采购包过来生成的数据
                            try {
                                //采购包id
                                Long packPurchasePackId = Long.valueOf(ext.getFieldValue());
                                planPackIds.add(packPurchasePackId);
                                packPurchasePackIdMap.put(packPurchasePackId,ext.getPackId());
                            }catch (Exception e){
                                log.error("转换包Id失败");
                            }
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(planPackIds)){
                //查询计划原始的打包人
                PlanQryPackCreateUserAbilityReqBO abilityReqBO = new PlanQryPackCreateUserAbilityReqBO();
                abilityReqBO.setPackIds(planPackIds);
                try {
                    PlanQryPackCreateUserAbilityRspBO abilityRspBO = planQryPackCreateUserAbilityService.qryPackCreateUser(abilityReqBO);
                    if (RspConstant.RESP_CODE_SUCCESS.equals(abilityRspBO.getRespCode())){
                        if (!CollectionUtils.isEmpty(abilityRspBO.getBos())){
                            for (PlanQryPackCreateUserBO bo : abilityRspBO.getBos()) {
                                //先拿到集采方案包id
                                Long packId = packPurchasePackIdMap.get(bo.getPackId());
                                if (packId!=null){
                                    packIdMap.put(packId,bo);
                                }
                            }
                        }
                    }else {
                        throw new ZTBusinessException(abilityRspBO.getRespDesc());
                    }
                }catch (Exception e){
                    log.error(e.getMessage());
                    throw new ZTBusinessException("查询原始打包人失败"+e.getMessage());
                }
            }
        }

        for (SscAwardResultPackExtPO sscAwardResultPackExtPO : awardResultListPage) {
            // 线下模式的标段编码给空值
            if ("2".equals(sscAwardResultPackExtPO.getQuotationType())) {
                sscAwardResultPackExtPO.setBdCode(null);
            }
            //判断是否取原始打包人
            if (COLLECT_SCHEME_TYPE.equals(sscAwardResultPackExtPO.getSchemeType())){
                try {
                    Long packId = Long.valueOf(sscAwardResultPackExtPO.getPackId());
                    if (packIdMap.containsKey(packId)){
                        PlanQryPackCreateUserBO planQryPackCreateUserBO = packIdMap.get(packId);
                        sscAwardResultPackExtPO.setAwardEmployeeNumber(planQryPackCreateUserBO.getAwardEmployeeNumber());
                        sscAwardResultPackExtPO.setAwardUserName(planQryPackCreateUserBO.getAwardUserName());
                    }
                }catch (Exception e){

                }
            }
        }

        //采购方案询比结果列表数据转换
        List<SscQryAwardResultExtBO> sscQryAwardResultExtBOList = JSON.parseArray(JSON.toJSONString(awardResultListPage), SscQryAwardResultExtBO.class);

        //获取采购方案明细扩展数据
        this.getSscSchemeMatExt(sscQryAwardResultExtBOList);

        //封装采购方案询比结果数据
        this.packingAwardResultData(reqBO ,sscQryAwardResultExtBOList);

        //号码/编号/数量/数字 数据处理
        this.numberProcessingData(sscQryAwardResultExtBOList);
        //获取中标时间
        getBidTime(reqBO, sscQryAwardResultExtBOList);
        //出参
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(sscQryAwardResultExtBOList);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);

        return rspBO;
    }

    /**
     * 获取采购方案明细扩展数据
     */
    private void getSscSchemeMatExt(List<SscQryAwardResultExtBO> sscQryAwardResultExtBOList){
        if (!CollectionUtils.isEmpty(sscQryAwardResultExtBOList)){
            //获取方案物料ID集合
            List<Long> schemeMatIds = sscQryAwardResultExtBOList.stream().map(SscQryAwardResultExtBO::getSchemaItemId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());

            //调用根据方案物料ID查询列表数据
            List<SscSchemeMatExtPackExtPO> sscSchemeMatExtPackExtPOList = new ArrayList<>(10);
            if (!CollectionUtils.isEmpty(schemeMatIds)){
                sscSchemeMatExtPackExtPOList = this.sscSchemeMatExtPackExtMapper.getListBySchemeMatExtId(schemeMatIds);
            }

            if (!CollectionUtils.isEmpty(sscSchemeMatExtPackExtPOList)){

                //获取采购方案明细扩展Map
                Map<Long, List<SscSchemeMatExtPackExtPO>> sscSchemeMatExtPackExtPOMap = sscSchemeMatExtPackExtPOList.stream().collect(Collectors.groupingBy(SscSchemeMatExtPackExtPO::getSchemeMatId));

                for (SscQryAwardResultExtBO sscQryAwardResultExtBO : sscQryAwardResultExtBOList) {
                    if (!CollectionUtils.isEmpty(sscSchemeMatExtPackExtPOMap.get(sscQryAwardResultExtBO.getSchemaItemId()))){

                        //获取当前方案物料扩展信息
                        List<SscSchemeMatExtPackExtPO> sscSchemeMatExtPackExtPOS = sscSchemeMatExtPackExtPOMap.get(sscQryAwardResultExtBO.getSchemaItemId());
                        //获取字段编码+字段值Map
                        Map<String, String> fieldMap = sscSchemeMatExtPackExtPOS.stream().filter(bo -> ObjectUtil.isNotEmpty(bo.getFieldCode())).collect(Collectors.toMap(SscSchemeMatExtPackExtPO::getFieldCode, SscSchemeMatExtPackExtPO::getFieldValue, (k1, k2) -> k2));

                        //设置质量技术说明
                        if (ObjectUtil.isNotEmpty(fieldMap.get("qualityRequire"))){
                            sscQryAwardResultExtBO.setTechnicalAgreements(fieldMap.get("qualityRequire"));
                        }
                        //设置执行标准
                        if (ObjectUtil.isNotEmpty(fieldMap.get("excuteStandard"))){
                            sscQryAwardResultExtBO.setTechnicalNorms(fieldMap.get("excuteStandard"));
                        }

                    }
                }
            }
        }
    }

    /**
     * 校验入参空查询结果
     */
    private boolean checkReqNullQueryResult(SscQryAwardResultExtReqBO reqBO){
        //集中采购空查询校验
        if (reqBO.getQueryType() == 1){
            //校验询比结果编码
            if (ObjectUtil.isNotEmpty(reqBO.getAwardCode())){
                return true;
            }
            //校验询比结果名称
            if (ObjectUtil.isNotEmpty(reqBO.getAwardName())){
                return true;
            }
            //校验询价书编码
            if (ObjectUtil.isNotEmpty(reqBO.getBusinessCode())){
                return true;
            }
            //校验询价书名称
            if (ObjectUtil.isNotEmpty(reqBO.getBusinessName())){
                return true;
            }
            //校验询价书编号
            if (ObjectUtil.isNotEmpty(reqBO.getBusinessNo())){
                return true;
            }
        }

        //委托采购空查询校验
        if (reqBO.getQueryType() == 2){
            //校验询比结果编码
            if (ObjectUtil.isNotEmpty(reqBO.getAwardCode())){
                return true;
            }
            //校验询比结果名称
            if (ObjectUtil.isNotEmpty(reqBO.getAwardName())){
                return true;
            }
            //校验简易采购计划类型的采购员编码
            if (ObjectUtil.isNotEmpty(reqBO.getBuyerId()) && ObjectUtil.isNotEmpty(reqBO.getIsJy()) && reqBO.getIsJy() == 1){
                return true;
            }
            //校验简易采购计划类型的采购包编码
            if (ObjectUtil.isNotEmpty(reqBO.getPackCode()) && ObjectUtil.isNotEmpty(reqBO.getIsJy()) && reqBO.getIsJy() == 1){
                return true;
            }
            //校验简易采购计划类型的采购包名称
            if (ObjectUtil.isNotEmpty(reqBO.getPackName()) && ObjectUtil.isNotEmpty(reqBO.getIsJy()) && reqBO.getIsJy() == 1){
                return true;
            }
            //校验简易采购计划类型的采购包编号
            if (ObjectUtil.isNotEmpty(reqBO.getPackNo()) && ObjectUtil.isNotEmpty(reqBO.getIsJy()) && reqBO.getIsJy() == 1){
                return true;
            }
        }

        //自行采购空查询校验
        if (reqBO.getQueryType() == 3){
            //校验项目编码
            if (ObjectUtil.isNotEmpty(reqBO.getProjectCode())){
                return true;
            }
            //校验项目名称
            if (ObjectUtil.isNotEmpty(reqBO.getProjectName())){
                return true;
            }
            //校验标段编码
            if (ObjectUtil.isNotEmpty(reqBO.getBdCode())){
                return true;
            }
            //校验简易采购计划类型的采购员编码
            if (ObjectUtil.isNotEmpty(reqBO.getBuyerId()) && ObjectUtil.isNotEmpty(reqBO.getIsJy()) && reqBO.getIsJy() == 1){
                return true;
            }
            //校验简易采购计划类型的采购包编码
            if (ObjectUtil.isNotEmpty(reqBO.getPackCode()) && ObjectUtil.isNotEmpty(reqBO.getIsJy()) && reqBO.getIsJy() == 1){
                return true;
            }
            //校验简易采购计划类型的采购包名称
            if (ObjectUtil.isNotEmpty(reqBO.getPackName()) && ObjectUtil.isNotEmpty(reqBO.getIsJy()) && reqBO.getIsJy() == 1){
                return true;
            }
            //校验简易采购计划类型的采购包编号
            if (ObjectUtil.isNotEmpty(reqBO.getPackNo()) && ObjectUtil.isNotEmpty(reqBO.getIsJy()) && reqBO.getIsJy() == 1){
                return true;
            }
        }

        return false;
    }

    /**
     * 封装采购方案询比结果数据
     */
    private void packingAwardResultData(SscQryAwardResultExtReqBO reqBO, List<SscQryAwardResultExtBO> sscQryAwardResultExtBOList){
        if (!CollectionUtils.isEmpty(sscQryAwardResultExtBOList)){
            for (SscQryAwardResultExtBO bo : sscQryAwardResultExtBOList) {
                //设置采购结果
                if (reqBO.getQueryType() == 1){
                    //集中采购
                    if (ObjectUtil.isNotEmpty(bo.getPackageCode()) && ObjectUtil.isNotEmpty(bo.getPackName())){
                        bo.setPurchaserResult(bo.getPackageCode() + "_" + bo.getPackName());
                    }
                }else if (reqBO.getQueryType() == 2){
                    //委托采购
                    if (ObjectUtil.isNotEmpty(bo.getBusinessCode()) && ObjectUtil.isNotEmpty(bo.getBusinessName())){
                        bo.setPurchaserResult(bo.getBusinessCode() + "_" + bo.getBusinessName());
                    }
                }else {
                    //自行采购
                    if (ObjectUtil.isNotEmpty(bo.getBusinessCode()) && ObjectUtil.isNotEmpty(bo.getBusinessName())){
                        bo.setPurchaserResult(bo.getBusinessCode() + "_" + bo.getBusinessName());
                    }
                }

                //设置合同类型
                if (ObjectUtil.isNotEmpty(bo.getContractType())){
                    //转换合同类型
                    if ("采购标准合同".equals(bo.getContractType())){
                        bo.setContractType("CONTRACT_BZCGDD");
                    }else if ("采购框架协议(定价)".equals(bo.getContractType())){
                        bo.setContractType("CONTRACT_CQCGXY");
                    }else if ("采购框架协议(寄售)".equals(bo.getContractType())){
                        bo.setContractType("CONTRACT_JSXY");
                    }else {
                        bo.setContractType("");
                    }
                }
                //转换合同的物资分类字段 materialCategory
                if (bo.getSchemeClass()!=null){
                    bo.setMaterialCategory(SscCommConstant.transContractMaterialCategory(bo.getSchemeClass()));
                }
            }
        }
    }

    /**
     * 号码/编号/数量/数字 数据处理
     */
    private void numberProcessingData(List<SscQryAwardResultExtBO> sscQryAwardResultExtBOList){
        if (!CollectionUtils.isEmpty(sscQryAwardResultExtBOList)){
            for (SscQryAwardResultExtBO bo : sscQryAwardResultExtBOList) {
                //处理税率 去除小数点后多余的0
                if (ObjectUtil.isNotEmpty(bo.getAwardItemTax())){
                    BigDecimal awardItemTax = new BigDecimal(bo.getAwardItemTax());
                    //去除小数点后多余的0 并将数据转换成字符串类型
                    bo.setAwardItemTax(awardItemTax.stripTrailingZeros().toPlainString());
                }
            }
        }
    }

    /**
     * 获取中标时间
     * @param reqBO
     * @param sscQryAwardResultExtBOList
     */
    private void getBidTime(SscQryAwardResultExtReqBO reqBO,List<SscQryAwardResultExtBO> sscQryAwardResultExtBOList){
        if (reqBO.getIsQryBidTime()!=null && reqBO.getIsQryBidTime()==1 && !CollectionUtils.isEmpty(sscQryAwardResultExtBOList)){
            /**
             * ①若会发中标通知书，则以中标通知书的审批通过时间，或外部系统接口回传时间，或无需审批时的提交时间进行回传
             * ②若不发中标通知书，以中标审批时间回传
             */
            Set<Long> supTabIdList = sscQryAwardResultExtBOList.stream().filter(e -> e.getSupTabId() != null).map(SscQryAwardResultExtBO::getSupTabId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(supTabIdList)){
                Map<Long, List<CrcSchemeFindsourceSupNoticePO>> supIdMap = new HashMap<>();
                Map<Long, List<CrcNoticePO>> supTabIdMap = new HashMap<>();

                if (reqBO.getQueryType() == 1){
                    //调用根据条件分页查询 集中采购 询比结果列表数据
                    CrcSchemeFindsourceSupNoticePO searchPO = new CrcSchemeFindsourceSupNoticePO();
                    searchPO.setSupTableIdList(new ArrayList<>(supTabIdList));
                    List<CrcSchemeFindsourceSupNoticePO> supNoticePOS = crcSchemeFindsourceSupNoticeMapper.getList(searchPO);
                    if (!CollectionUtils.isEmpty(supNoticePOS)){
                        supIdMap = supNoticePOS.stream().collect(Collectors.groupingBy(CrcSchemeFindsourceSupNoticePO::getSupId));
                    }
                }
                if (reqBO.getQueryType() == 2 || reqBO.getQueryType() == 3){
                    //调用根据条件分页查询 委托采购 和自行采购
                    CrcNoticePO searchPO = new CrcNoticePO();
                    searchPO.setObjIds(new ArrayList<>(supTabIdList));
                    List<CrcNoticePO> noticePOS = crcNoticeMapper.getList(searchPO);
                    if (!CollectionUtils.isEmpty(noticePOS)){
                        supTabIdMap = noticePOS.stream().collect(Collectors.groupingBy(CrcNoticePO::getSupTableId));
                    }
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss");
                for (SscQryAwardResultExtBO sscQryAwardResultExtBO : sscQryAwardResultExtBOList) {
                    if (reqBO.getQueryType() == 1){
                        if (supIdMap.containsKey(sscQryAwardResultExtBO.getSupTabId())){
                            String ext1 = supIdMap.get(sscQryAwardResultExtBO.getSupTabId()).get(0).getExt1();
                            if (!StringUtils.isEmpty(ext1)){
                                try {
                                    Date noticeTime = dateFormat.parse(ext1);
                                    sscQryAwardResultExtBO.setBidTime(noticeTime);
                                }catch (Exception e){
                                    sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                                }
                            }else {
                                sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                            }
                        }else {
                            sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                        }
                    }
                    if (reqBO.getQueryType() == 2 || reqBO.getQueryType() == 3){
                        if (supTabIdMap.containsKey(sscQryAwardResultExtBO.getSupTabId())){
                            CrcNoticePO crcNoticePO = supTabIdMap.get(sscQryAwardResultExtBO.getSupTabId()).get(0);
                            if (crcNoticePO.getAuditTime()!=null){
                                sscQryAwardResultExtBO.setBidTime(crcNoticePO.getAuditTime());
                            }else if (!StringUtils.isEmpty(crcNoticePO.getExt4())){
                                String ext4 = crcNoticePO.getExt4();
                                try {
                                    Date noticeTime = dateFormat.parse(ext4);
                                    sscQryAwardResultExtBO.setBidTime(noticeTime);
                                }catch (Exception e){
                                    sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                                }
                            }else {
                                sscQryAwardResultExtBO.setBidTime(crcNoticePO.getCreatTime());
                            }
                        }else {
                            sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                        }
                    }
                }
            }
        }
    }

}
