package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import com.tydic.dyc.ssc.repository.SscSchemeRecentMatListQueryRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.PlatFormSscSchemeMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 说明：查询近期相同物料提交的方案
 * 时间：2024/08/28
 * 作者：曹永吉
 */
@Service
public class SscSchemeRecentMatListQueryRepositoryImpl implements SscSchemeRecentMatListQueryRepository {

    /**
     * 采购方案 Mapper
     */
    @Autowired
    private PlatFormSscSchemeMapper platFormSscSchemeMapper;

    /**
     * 采购方案明细分页查询
     */
    @Override
    public SscSchemeRecentMatListRspBO querySchemeRecentMatList(SscSchemeRecentMatListReqBO reqBO) {
        SscSchemeRecentMatListRspBO rspBO = new SscSchemeRecentMatListRspBO();

        //出参
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);

        SscSchemePO sscSchemePO = new SscSchemePO();
        sscSchemePO.setSchemeId(reqBO.getSchemeId());
        sscSchemePO.setMatCodeList(reqBO.getMatCodeList());
        sscSchemePO.setTargetDay(reqBO.getTargetDay());
        sscSchemePO.setPurchaseType(reqBO.getPurchaseType());
        sscSchemePO.setSchemeClass(reqBO.getSchemeClass());
        sscSchemePO.setCreateCompanyCode(reqBO.getCreateCompanyCode());
        // 查询近期相同物资的方案采购计划金额---按物资维度查
        List<SscSchemePO> allEstAmountList = platFormSscSchemeMapper.queryRecentSchemeEstAmount(sscSchemePO);
        if (CollectionUtils.isEmpty(allEstAmountList)) {
            rspBO.setRows(new ArrayList<>());
            return rspBO;
        }
        // 超额的物料集合
        List<String> matCodeList = new ArrayList<>();
        for (SscSchemePO po : allEstAmountList) {
            // 计算物料的方案金额
            BigDecimal allEstAmount = reqBO.getEstAmount().add(po.getEstAmount());
            // 工程类大于400万;服务类大于100万;货物类大于200，返回预警
            if ((reqBO.getSchemeClass() == 0 && allEstAmount.compareTo(new BigDecimal("4000000")) > 0)
                    || (reqBO.getSchemeClass() == 2 && allEstAmount.compareTo(new BigDecimal("1000000")) > 0)
                    || (reqBO.getSchemeClass() != 0 && reqBO.getSchemeClass() != 2 && allEstAmount.compareTo(new BigDecimal("2000000")) > 0)
            ) {
                matCodeList.add(po.getMatCode());
            }
        }
        // 存在超额的物料
        if (!CollectionUtils.isEmpty(matCodeList)) {
            sscSchemePO.setMatCodeList(matCodeList);
            List<SscSchemePO> matList = platFormSscSchemeMapper.queryRecentSchemeMatList(sscSchemePO);
            rspBO.setRows(JSON.parseArray(JSONObject.toJSONString(matList), SscSchemeRecentMatListBO.class));
        }

        return rspBO;
    }
}
