package com.tydic.dyc.ssc.repositoryExt;

import com.tydic.dyc.ssc.bo.SscQryOrderIdAndProInstIdBO;
import com.tydic.dyc.ssc.repositoryExt.dao.SscPlanPackMapper;
import com.tydic.dyc.ssc.service.scheme.SscQryOrderIdAndProInstIdService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryOrderIdAndProInstIdReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryOrderIdAndProInstIdRspBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：询源明细查询基建层接口接口实现类
 * 时间：2023/08/14
 */
@HTServiceImpl
public class SscQryOrderIdAndProInstIdServiceImpl implements SscQryOrderIdAndProInstIdService {
    @Autowired
    private SscPlanPackMapper sscPlanPackMapper;
    @Override
    public SscQryOrderIdAndProInstIdRspBO qryApproveList(SscQryOrderIdAndProInstIdReqBO repBO) {
        List<SscQryOrderIdAndProInstIdBO> list=sscPlanPackMapper.selectProcInstIdsByOrderIds(repBO.getOrderIds(),repBO.getObjType());
        SscQryOrderIdAndProInstIdRspBO rspBO = new SscQryOrderIdAndProInstIdRspBO();
        rspBO.setList(list);
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
