package com.tydic.dyc.ssc.repositoryExt.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.ssc.repositoryExt.comb.api.SscPushChangeSmartApproveService;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.SscPushChangeSmartApproveReqBO;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.SscPushChangeSmartApproveRspBO;
import com.tydic.dyc.ssc.repositoryExt.utils.SignAuthUtil;
import com.tydic.dyc.ssc.repositoryExt.utils.http.HttpUtil;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Objects;

/**
 * 推送变更信息给智能评审
 *
 * @author hsw
 * @since 2024-8-23 16:05:37
 */
@Slf4j
@Service
public class SscPushChangeSmartApproveServiceImpl implements SscPushChangeSmartApproveService {

    /**
     * 智能审批侧变更推送地址
     */
    @Value("${ssc_push_change_sa_url:http://192.168.0.9:18700/ebidding/api/evaluation/bid/info}")
    private String pushUrl;

    /**
     * 智能审批侧变更推送地址
     */
    @Value("${smart_approve_app_key:4KAUEOC6RV93K2C0BS3V78RPTAPDRE2U}")
    private String APP_KEY;
    /**
     * 智能审批侧变更推送地址
     */
    @Value("${smart_approve_app_secret:AVOPPQ530UQTBOG8PV5IIH1KO2MRDKUV}")
    private String APP_SECRET;

    private final static String RSP_SUCCESS_CODE = "000000";

    /**
     * 推送变更信息给智能评审
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscPushChangeSmartApproveRspBO pushChange(SscPushChangeSmartApproveReqBO reqBO) {
        String result;
        SscPushChangeSmartApproveRspBO rspBO = new SscPushChangeSmartApproveRspBO();
        JSONObject header = new JSONObject();
        // 获取当前时间戳
        String requestTime = String.valueOf(System.currentTimeMillis());
        // 获得加签结果
        String signStr = SignAuthUtil.getSign(new HashMap<>(), requestTime);
        header.put("appKey", APP_KEY);
        header.put("appSecret", APP_SECRET);
        header.put("requestTime", requestTime);
        header.put("secData", signStr);
        try {
            log.info("-----------推送变更信息给智能评审---------------{}", JSONObject.toJSONString(reqBO));
            result = HttpUtil.doPost(pushUrl, JSONObject.toJSONString(reqBO), header.toJSONString());
            log.info("-----------推送变更信息给智能评审出参---------------{}", result);
            if(Objects.isNull(result)){
                rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                rspBO.setRespDesc("返回值为空");
            } else {
                JSONObject resultJSON = JSONObject.parseObject(result);
                if (RSP_SUCCESS_CODE.equals(resultJSON.getString("code"))) {
                    rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
                    rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
                } else {
                    rspBO.setRespCode(RspConstant.RESP_DESC_ERROR);
                    rspBO.setRespDesc(resultJSON.getString("message"));
                }
                rspBO.setRespData(JSON.toJSONString(result));

            }
        } catch (Exception e) {
            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            rspBO.setRespDesc("错误原因：" + e.getMessage());
            log.error("推送变更信息给智能评审失败,原因为:" + e);
        }
        return rspBO;
    }
}
