package com.tydic.dyc.ssc.repositoryExt.config;

import java.util.concurrent.*;

/**
 * @Author jmrg
 * @dATE 2023/8/25
 * @Desc 线程池工具类
 */
public class SscThreadPoolExecutorUtil {

    /**
     * 核心线程数
     */
    private static final int CORE_POOL_SIZE = 4;
    /**
     * 最大线程数
     */
    private static final int MAXIMUM_POOL_SIZE = 8;
    /**
     * 线程活动保持时间
     */
    private static final long KEEP_ALIVE_TIME = 2000;
    /**
     * 线程活动保持时间的单位
     */
    private static final TimeUnit UNIT = TimeUnit.MILLISECONDS;
    /**
     * 线程队列数
     */
    private static final BlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<>(500);
    private static final RejectedExecutionHandler REJECTED = new ThreadPoolExecutor.CallerRunsPolicy();
    public static ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE_TIME, UNIT, workQueue,REJECTED);
}
