package com.tydic.dyc.ssc.repositoryExt.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.ssc.repository.SchemeSaveXwglRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.XwglObjLogMapper;
import com.tydic.dyc.ssc.repositoryExt.po.XwglObjLogPO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeSaveXwglReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeSaveXwglRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.XwgLSaveLogXwglLogBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import com.tydic.xwgl.ability.api.XwgLSaveLogAbilityService;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBo;
import com.tydic.xwgl.ability.bo.XwgLSaveLogReqBoXwglLogs;
import com.tydic.xwgl.ability.bo.XwgLSaveLogRspBo;
import com.tydic.xwgl.ability.bo.XwgLSaveLogRspBoXwglLogs;
import lombok.extern.ohaotian.HTServiceRef;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 服务名:
 * 作者:lantian
 * 时间:2024/12/13
 */
@Service
public class SchemeSaveXwglRepositoryImpl implements SchemeSaveXwglRepository {
    @Autowired
    private XwglObjLogMapper xwglObjLogMapper;

    @HTServiceRef
    private XwgLSaveLogAbilityService xwgLSaveLogAbilityService;

    @Override
    public SchemeSaveXwglRspBO saveXwgl(SchemeSaveXwglReqBO reqBO) {
        XwglObjLogPO xwglObjLogPO = new XwglObjLogPO();
        List<String> ruleNos = new ArrayList<>();
        XwgLSaveLogReqBo saveLogReqBo = new XwgLSaveLogReqBo();
        List<XwgLSaveLogReqBoXwglLogs> xwglLogs = new ArrayList<>();
        for (XwgLSaveLogXwglLogBO lSaveLogXwglLogBO : reqBO.getXwglLogs()) {
            XwgLSaveLogReqBoXwglLogs logs = new XwgLSaveLogReqBoXwglLogs();
            BeanUtils.copyProperties(lSaveLogXwglLogBO, logs);
            ruleNos.add(lSaveLogXwglLogBO.getRuleNo());
            xwglLogs.add(logs);
        }
        saveLogReqBo.setXwglLogs(xwglLogs);
        xwglObjLogPO.setRuleNos(ruleNos);
        xwglObjLogPO.setObjId(String.valueOf(reqBO.getSchemeId()));
        List<XwglObjLogPO> get = xwglObjLogMapper.selectByCondition(xwglObjLogPO);
        List<Long> delIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(get)) {
            List<Long> ids = new ArrayList<>();
            for (XwglObjLogPO po : get) {
                ids.add(po.getXwgLogId());
                delIds.add(po.getId());
            }
            saveLogReqBo.setDelIds(ids);
        }
        XwgLSaveLogRspBo rspBo = xwgLSaveLogAbilityService.saveXwglLog(saveLogReqBo);
        List<XwglObjLogPO> insert = new ArrayList<>();
        if (!CollectionUtils.isEmpty(rspBo.getXwglLogs())) {
            for (XwgLSaveLogRspBoXwglLogs bo : rspBo.getXwglLogs()) {
                XwglObjLogPO po = new XwglObjLogPO();
                po.setId(Sequence.getInstance().nextId());
                po.setXwgLogId(bo.getId());
                po.setObjId(bo.getBusinessId());
                po.setRuleNo(bo.getRuleNo());
                po.setCreateTime(new Date());
                po.setCreateUserId(reqBO.getUserId());
                po.setCreateUserCode(reqBO.getUsername());
                po.setCreateUserName(reqBO.getName());
                po.setUpdateTime(new Date());
                po.setUpdateUserId(reqBO.getUserId());
                po.setUpdateUserCode(reqBO.getUsername());
                po.setUpdateUserName(reqBO.getName());
                insert.add(po);
            }
        }
        if (!CollectionUtils.isEmpty(insert)) {
            xwglObjLogMapper.insertBatch(insert);
        }
        if (!CollectionUtils.isEmpty(delIds)) {
            XwglObjLogPO del = new XwglObjLogPO();
            del.setIds(delIds);
            xwglObjLogMapper.delete(del);
        }
        SchemeSaveXwglRspBO rspBO = new SchemeSaveXwglRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SchemeSaveXwglRspBO getXwglLog(SchemeSaveXwglReqBO reqBO) {
        XwglObjLogPO xwglObjLogPO = new XwglObjLogPO();
        xwglObjLogPO.setRuleNos(reqBO.getRuleNos());
        xwglObjLogPO.setObjId(String.valueOf(reqBO.getSchemeId()));
        List<XwglObjLogPO> get = xwglObjLogMapper.selectByCondition(xwglObjLogPO);
        SchemeSaveXwglRspBO rspBO = new SchemeSaveXwglRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        if (!CollectionUtils.isEmpty(get)) {
            List<Long> ids = new ArrayList<>();
            for (XwglObjLogPO po : get) {
                ids.add(po.getXwgLogId());
            }
            rspBO.setIds(ids);
        }
        return rspBO;
    }
}
