package com.tydic.dyc.ssc.repositoryExt.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtReqBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtRspBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackSyncFzBO;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.repository.SscSchemeTrackExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeTrackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeTrackSyncFzMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SysDicDictionaryMapper;
import com.tydic.dyc.ssc.repositoryExt.po.*;
import com.tydic.dyc.ssc.service.scheme.bo.SscEntrustResultPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscInquiryItemDbPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscInquiryPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryInquiryInfoExtBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 作者 85222
 * 创建日期 2023年04月12日
 */
@Service
public class SscSchemeTrackExtRepositoryImpl implements SscSchemeTrackExtRepository {
    @Autowired
    private SscSchemeTrackExtMapper sscSchemeTrackExtMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @Autowired
    private SscSchemeTrackSyncFzMapper sscSchemeTrackSyncFzMapper;
    @Autowired
    private SaasSchemePackMapper saasSchemePackMapper;
    @Override
    public int schemeTrackSync(SscSchemeTrackSyncFzBO bo) {
        int rspBO=8888;
        SscSchemeTrackSyncFzPO po = sscSchemeTrackSyncFzMapper.selectByPackId(bo.getPackId());
        if(ObjectUtils.isEmpty(po)){
            SscSchemeTrackSyncFzPO js = JUtil.js(bo, SscSchemeTrackSyncFzPO.class);
            js.setCreateTime(new Date());
            rspBO = sscSchemeTrackSyncFzMapper.insert(js);
        }else {
            SscSchemeTrackSyncFzPO sscSchemeTrackSyncFzPO = JUtil.js(bo, SscSchemeTrackSyncFzPO.class);
            sscSchemeTrackSyncFzPO.setId(po.getId());
            sscSchemeTrackSyncFzPO.setUpdateTime(new Date());
            rspBO=sscSchemeTrackSyncFzMapper.updateById(sscSchemeTrackSyncFzPO);
        }
        return rspBO;
    }
    @Override
    public SscSchemeTrackExtRspBO selectSchemeTrack(SscSchemeTrackExtReqBO reqBO) {
        if (!StringUtils.isEmpty(reqBO.getAuditTimeEnd())) {
            reqBO.setAuditTimeEnd(reqBO.getAuditTimeEnd()+" 23:59:59");
        }
        if (!StringUtils.isEmpty(reqBO.getCreateTimeEnd())) {
            reqBO.setCreateTimeEnd(reqBO.getCreateTimeEnd()+" 23:59:59");
        }
        SscSchemeTrackExtRspBO rspBO = new SscSchemeTrackExtRspBO();
        Page<SscSchemeTrackExtReqBO> page = new Page<SscSchemeTrackExtReqBO>(reqBO.getPageNo(), reqBO.getPageSize());
        //是否是集采方案要根据采购方案那面的数据查询
        Integer isGroupBuyQryFlag = 0;
        if (!StringUtils.isEmpty(reqBO.getPlanPackCode())){
            isGroupBuyQryFlag =1;
        }
        if (!StringUtils.isEmpty(reqBO.getPlanPackName())){
            isGroupBuyQryFlag =1;
        }
        if (!StringUtils.isEmpty(reqBO.getPlanPackNo())){
            isGroupBuyQryFlag =1;
        }
        if (!StringUtils.isEmpty(reqBO.getPlanPackOrgCode())){
            isGroupBuyQryFlag =1;
        }
        if (!StringUtils.isEmpty(reqBO.getPlanPackOrgName())){
            isGroupBuyQryFlag =1;
        }
        reqBO.setIsGroupBuyQryFlag(isGroupBuyQryFlag);
        List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS = sscSchemeTrackExtMapper.selectSchemeTrack(reqBO, page);
        // 采购方案,简易采购计划封装关注状态
        List<Long> careIds = sscSchemeTrackExtMapper.selectCareIdsByUserId(reqBO.getUserId());
        List<String> schemeTypeList = Arrays.asList("2","3");
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS) && schemeTypeList.contains(reqBO.getSchemeType())) {
            if (CollectionUtils.isEmpty(careIds)) {
                sscSchemeTrackExtBOS.forEach(e -> {
                    e.setCare(0);
                    e.setCareStr("未关注");
                });
            } else {
                sscSchemeTrackExtBOS.forEach(e -> {
                    if (careIds.contains(e.getPackId())){
                        e.setCare(1);
                        e.setCareStr("已关注");
                    } else {
                        e.setCare(0);
                        e.setCareStr("未关注");
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS) && SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(String.valueOf(reqBO.getSchemeType()))){
            //判断 采购方案 分配给 对应人，然后生成集采方案，跟踪列表要展示对应的集采方案的 询比
            /**
             * 1、采购方案的分交方式被审核/修改为[集采实施-自营]后，
             * 采购方案采购包的执行状态、业务状态=集采方案采购包的执行状态、业务状态，
             * 并在采购方案跟踪-采购寻源中展示该集采方案采购包的集采方案、委托书、询价书...合同、订单等 (除采购方案可以查看详情外，其他单据均不可查看详情)
             */
            List<Long> packIds = new ArrayList<>();
            for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                if ("集采实施-自营".equals(sscSchemeTrackExtBO.getSchemeSubmitValue())){
                    packIds.add(sscSchemeTrackExtBO.getPackId());
                }
            }
            if (!CollectionUtils.isEmpty(packIds)){
                //查询 是否有对应的集采包
                List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackByPurchasePackIds(packIds);
                if (!CollectionUtils.isEmpty(saasSchemePackPOS)){
                    Map<String, List<SaasSchemePackPO>> groupBuyPackIdMap = saasSchemePackPOS.stream().collect(Collectors.groupingBy(SaasSchemePackPO::getPurchasePackId));
                    //找到所有的集采包ids
                    List<Long> groupBuyPackIds = saasSchemePackPOS.stream().map(SaasSchemePackPO::getPackId).collect(Collectors.toList());
                    List<SscSchemeTrackSyncFzPO> sscSchemeTrackSyncFzPOS = sscSchemeTrackSyncFzMapper.selectByPackIds(groupBuyPackIds);
                    Map<Long, List<SscSchemeTrackSyncFzPO>> groupBuyPackIdFzMap = new HashMap<>();
                    if (CollectionUtils.isEmpty(sscSchemeTrackSyncFzPOS)){
                        groupBuyPackIdFzMap = sscSchemeTrackSyncFzPOS.stream().collect(Collectors.groupingBy(SscSchemeTrackSyncFzPO::getPackId));
                    }
                    for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                        if (groupBuyPackIdMap.keySet().contains(sscSchemeTrackExtBO.getPackId().toString())){
                            SaasSchemePackPO saasSchemePackPO = groupBuyPackIdMap.get(sscSchemeTrackExtBO.getPackId().toString()).get(0);
                            //替换为集采包的状态
                            sscSchemeTrackExtBO.setSchemeExectStatus(saasSchemePackPO.getPackExectStatus());
                            sscSchemeTrackExtBO.setGroupBuyPackCode(saasSchemePackPO.getPackCode());
                            sscSchemeTrackExtBO.setGroupBuyPackId(saasSchemePackPO.getPackId());
                            sscSchemeTrackExtBO.setGroupBuyPackNo(saasSchemePackPO.getPackNo());
                            if (groupBuyPackIdFzMap.keySet().contains(saasSchemePackPO.getPackId())){
                                //替换询价书信息
                                SscSchemeTrackSyncFzPO sscSchemeTrackSyncFzPO = groupBuyPackIdFzMap.get(saasSchemePackPO.getPackId()).get(0);
                                sscSchemeTrackExtBO.setEnquiryBook(sscSchemeTrackSyncFzPO.getEnquiryBook());
                                sscSchemeTrackExtBO.setQuoteBook(sscSchemeTrackSyncFzPO.getQuoteBook());
                                sscSchemeTrackExtBO.setEnquiryResult(sscSchemeTrackSyncFzPO.getEnquiryResult());
                                sscSchemeTrackExtBO.setEnquirySupplier(sscSchemeTrackSyncFzPO.getEnquirySupplier());
                                sscSchemeTrackExtBO.setEnquiryMoney(sscSchemeTrackSyncFzPO.getEnquiryMoney());
                                sscSchemeTrackExtBO.setEnquiryMat(sscSchemeTrackSyncFzPO.getEnquiryMat());
                                sscSchemeTrackExtBO.setEntrustBook(sscSchemeTrackSyncFzPO.getEntrustBook());
                                sscSchemeTrackExtBO.setBidReport(sscSchemeTrackSyncFzPO.getBidReport());
                                sscSchemeTrackExtBO.setBidSupplier(sscSchemeTrackSyncFzPO.getBidSupplier());
                                sscSchemeTrackExtBO.setBidMoney(sscSchemeTrackSyncFzPO.getBidMoney());
                                sscSchemeTrackExtBO.setBidMat(sscSchemeTrackSyncFzPO.getBidMat());
                                sscSchemeTrackExtBO.setCalibrationReport(sscSchemeTrackSyncFzPO.getCalibrationReport());
                            }
                        }
                    }
                }
            }
        }
        //采购方式字典翻译
        SysDicDictionaryPO searchPO = new SysDicDictionaryPO();
        searchPO.setPCode("PURCH_WAY");
        List<SysDicDictionaryPO> sysDicDictionaryPOS = sysDicDictionaryMapper.selectDictionary(searchPO);
        if (!CollectionUtils.isEmpty(sysDicDictionaryPOS)){
            Map<String, String> codeMap = sysDicDictionaryPOS.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getDescrip));
            for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getPurchaseType())){
                    sscSchemeTrackExtBO.setPurchaseTypeStr(codeMap.get(sscSchemeTrackExtBO.getPurchaseType()));
                }
            }
        }
        //组织采购寻源数据数据
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS)){
            if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(reqBO.getSchemeType())){
                getCrcFindSource(sscSchemeTrackExtBOS);
            }else {
                //获取对应询价书数量
                getInquiryCount(reqBO,sscSchemeTrackExtBOS);
                //查询自行采购寻源对应的 报价书、询价结果、中选供应商、中选金额(元)、中选物资
                getCrcInquiry(sscSchemeTrackExtBOS);
                //查询委托书对应的委托书、评标报告、定标报告、中选供应商、中选金额(元)、中选物资
                getCrcEntrust(sscSchemeTrackExtBOS);
            }
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setSchemeTrackList(sscSchemeTrackExtBOS);
        return rspBO;
    }

    /**
     * 获取对应询价书数量
     */
    private void getInquiryCount(SscSchemeTrackExtReqBO reqBO,List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS){
        if (CollectionUtils.isEmpty(sscSchemeTrackExtBOS)){
            return;
        }
        List<Long> packIds = new ArrayList<>();
        List<Long> schemeIds =  new ArrayList<>();

        if (!StringUtils.isEmpty(reqBO.getSchemeType()) && reqBO.getSchemeType().equals(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode())){
            //简易计划
            schemeIds =sscSchemeTrackExtBOS.stream().map(SscSchemeTrackExtBO::getSchemeId).collect(Collectors.toList());
        }else {
            //采购方案
            packIds =sscSchemeTrackExtBOS.stream().map(SscSchemeTrackExtBO::getPackId).collect(Collectors.toList());
        }
        Map<Long, Integer> inquiryNumMap = new HashMap<>();
        Map<Long, Integer> inquiryQuoteLNumMap = new HashMap<>();

        //根据入参的方案包id或者方案id 统计对应的询价书数量和报价书数量
        if (!CollectionUtils.isEmpty(packIds) || !CollectionUtils.isEmpty(schemeIds)){
            List<SscQryInquiryInfoExtBo> inquiryList = saasSchemePackMapper.qryInquiryCount(packIds, schemeIds);
            if (!CollectionUtils.isEmpty(inquiryList)){
                if (!StringUtils.isEmpty(reqBO.getSchemeType()) && reqBO.getSchemeType().equals(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode())){
                    inquiryNumMap = inquiryList.stream().collect(Collectors.toMap(SscQryInquiryInfoExtBo::getSchemeId, SscQryInquiryInfoExtBo::getInquiryNum));
                }else {
                    inquiryNumMap = inquiryList.stream().collect(Collectors.toMap(SscQryInquiryInfoExtBo::getPackId, SscQryInquiryInfoExtBo::getInquiryNum));
                }
            }
            List<SscQryInquiryInfoExtBo> inquiryQuoteList = saasSchemePackMapper.qryInquiryQuoteCount(packIds, schemeIds);
            if (!CollectionUtils.isEmpty(inquiryQuoteList)){
                if (!StringUtils.isEmpty(reqBO.getSchemeType()) && reqBO.getSchemeType().equals(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode())){
                    inquiryQuoteLNumMap = inquiryQuoteList.stream().collect(Collectors.toMap(SscQryInquiryInfoExtBo::getSchemeId, SscQryInquiryInfoExtBo::getQuoteNum));
                }else {
                    inquiryQuoteLNumMap = inquiryQuoteList.stream().collect(Collectors.toMap(SscQryInquiryInfoExtBo::getPackId, SscQryInquiryInfoExtBo::getQuoteNum));
                }
            }
        }
        for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
            Integer enquiryBookNum = 0;
            Integer quoteBookNum = 0;
            if (!StringUtils.isEmpty(reqBO.getSchemeType()) && reqBO.getSchemeType().equals(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode())){
                if (inquiryNumMap.containsKey(sscSchemeTrackExtBO.getSchemeId())){
                    enquiryBookNum = inquiryNumMap.get(sscSchemeTrackExtBO.getSchemeId());
                }
                if (inquiryQuoteLNumMap.containsKey(sscSchemeTrackExtBO.getSchemeId())){
                    quoteBookNum = inquiryQuoteLNumMap.get(sscSchemeTrackExtBO.getSchemeId());
                }
            }else {
                if (inquiryNumMap.containsKey(sscSchemeTrackExtBO.getPackId())){
                    enquiryBookNum = inquiryNumMap.get(sscSchemeTrackExtBO.getPackId());
                }
                if (inquiryQuoteLNumMap.containsKey(sscSchemeTrackExtBO.getPackId())){
                    quoteBookNum = inquiryQuoteLNumMap.get(sscSchemeTrackExtBO.getPackId());
                }
            }
            //要保留非招原有数据
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEntrustBook())){
                try {
                    Integer entrustBook = Integer.valueOf(sscSchemeTrackExtBO.getEntrustBook());
                    enquiryBookNum += entrustBook;
                }catch (Exception e){

                }
            }
            //要保留非招原有数据
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getQuoteBook())){
                try {
                    Integer quoteBook = Integer.valueOf(sscSchemeTrackExtBO.getQuoteBook());
                    quoteBookNum += quoteBook;
                }catch (Exception e){

                }
            }
            sscSchemeTrackExtBO.setEnquiryBook(enquiryBookNum+"");
            sscSchemeTrackExtBO.setQuoteBook(quoteBookNum+"");
        }
    }

    /**
     * 查询自行采购寻源对应的 报价书、询价结果、中选供应商、中选金额(元)、中选物资
     * @param
     */
    private void getCrcInquiry(List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS){
        List<Long> packIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS)){
            packIds = sscSchemeTrackExtBOS.stream().filter(e->e.getPackId()!=null).map(SscSchemeTrackExtBO::getPackId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(packIds)){
            return;
        }
        Map<Long, List<SscInquiryPO>> packIdMap = new HashMap<>();
        //查询定标表明细数据统计对应的中选供应商数量、中选金额（取成交总额）、中选物资改为中选物资项（取中标物资项数）
        Map<Long,Integer> inquiryIdBdSupCountMap = new HashMap<>();
        Map<Long,Integer> inquiryIdBdItemCountMap = new HashMap<>();
        Map<Long,BigDecimal> inquiryIdBdCjAmountMap = new HashMap<>();
        //根据询价结果ids 查询对应的报价书数量
        Map<Long, Integer> inquiryIdBjsCountMap = new HashMap<>();

        if (!CollectionUtils.isEmpty(packIds)){
            SscInquiryPO qryInquiryPO = new SscInquiryPO();
            qryInquiryPO.setPackIds(packIds);

            List<SscInquiryPO> crcInquiryPOS = saasSchemePackMapper.qryInquiryTrackDownList(qryInquiryPO);

            if (!CollectionUtils.isEmpty(crcInquiryPOS)){
                packIdMap = crcInquiryPOS.stream().collect(Collectors.groupingBy(SscInquiryPO::getPackId));

                List<Long> inquiryIds = crcInquiryPOS.stream().map(SscInquiryPO::getInquiryId).collect(Collectors.toList());
                //非招过来的数据单独查询报价书
                List<Long> qryQuoteInquiryIds = new ArrayList<>();
                for (SscInquiryPO inquiryPO : crcInquiryPOS) {
                    Long busiId = null;
                    if (!StringUtils.isEmpty(inquiryPO.getExt7())){
                        try {
                            //非招的是Uuid，易购的是Long型
                            busiId = Long.valueOf(inquiryPO.getExt7());
                        }catch (Exception e){

                        }
                    }
                    if (busiId!=null){
                        //易购询比采购过来的数据
                    }else {
                        //非招过来的数据，需要单独查询报价书
                        qryQuoteInquiryIds.add(inquiryPO.getInquiryId());
                    }
                }
                //根据询价结果ids 查询对应的报价书数量(需要排除掉从易购询比采购过去的数据，因为上面已经单独统计过了)
                if (!CollectionUtils.isEmpty(qryQuoteInquiryIds)){
                    List<SscInquiryPO> bjsList = saasSchemePackMapper.qryInquiryBjsCount(qryQuoteInquiryIds);
                    if (!CollectionUtils.isEmpty(bjsList)){
                        inquiryIdBjsCountMap = bjsList.stream().filter(e->e.getBjsCount()!=null).collect(Collectors.toMap(SscInquiryPO::getInquiryId,SscInquiryPO::getBjsCount));
                    }
                }
                //查询定标表明细数据统计对应的中选供应商数量、中选金额（取成交总额）、中选物资改为中选物资项（取中标物资项数）
                List<SscInquiryItemDbPO> sscInquiryItemDbPOS = saasSchemePackMapper.qryInquiryDbItem(inquiryIds);
                if (!CollectionUtils.isEmpty(sscInquiryItemDbPOS)){
                    Map<Long, List<SscInquiryItemDbPO>> inquiryIdDbMap = sscInquiryItemDbPOS.stream().collect(Collectors.groupingBy(SscInquiryItemDbPO::getInquiryId));

                    for (Long inquiryId : inquiryIdDbMap.keySet()) {
                        Set<Long> bdSupIds = new HashSet<>();
                        Set<Long> bdSchemaItemIds = new HashSet<>();
                        BigDecimal cjTotal = BigDecimal.ZERO;
                        for (SscInquiryItemDbPO itemDbPO : inquiryIdDbMap.get(inquiryId)) {
                            if (itemDbPO.getPurchaseCount()!=null && itemDbPO.getPurchaseCount().compareTo(BigDecimal.ZERO)>0){
                                bdSupIds.add(itemDbPO.getSupId());
                                bdSchemaItemIds.add(itemDbPO.getSchemaItemId());
                                if (itemDbPO.getYzfAmount()!=null){
                                    cjTotal = cjTotal.add(itemDbPO.getYzfAmount());
                                }
                                if (itemDbPO.getHaveTaxAmount()!=null){
                                    cjTotal = cjTotal.add(itemDbPO.getHaveTaxAmount());
                                }
                            }
                        }
                        inquiryIdBdSupCountMap.put(inquiryId,bdSupIds.size());
                        inquiryIdBdItemCountMap.put(inquiryId,bdSchemaItemIds.size());
                        inquiryIdBdCjAmountMap.put(inquiryId,cjTotal);
                    }
                }
            }
            //组装数据:报价书、询价结果、中选供应商、 中选金额(元)、中选物资
            for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                Integer quoteBookNum = 0;
                Integer enquiryResultNum = 0;
                Integer enquirySupplierNum = 0;
                BigDecimal enquiryMoneySum = BigDecimal.ZERO;
                Integer enquiryMatNum = 0;

                if (packIdMap.containsKey(sscSchemeTrackExtBO.getPackId())){
                    List<SscInquiryPO> inquiryPOS = packIdMap.get(sscSchemeTrackExtBO.getPackId());
                    enquiryResultNum = inquiryPOS.size();
                    for (SscInquiryPO inquiryPO : inquiryPOS) {
                        if (inquiryIdBjsCountMap.containsKey(inquiryPO.getInquiryId())){
                            quoteBookNum += inquiryIdBjsCountMap.get(inquiryPO.getInquiryId());
                        }
                        if (inquiryIdBdSupCountMap.containsKey(inquiryPO.getInquiryId())){
                            enquirySupplierNum += inquiryIdBdSupCountMap.get(inquiryPO.getInquiryId());
                        }
                        if (inquiryIdBdItemCountMap.containsKey(inquiryPO.getInquiryId())){
                            enquiryMatNum += inquiryIdBdItemCountMap.get(inquiryPO.getInquiryId());
                        }
                        if (inquiryIdBdCjAmountMap.containsKey(inquiryPO.getInquiryId())){
                            enquiryMoneySum = enquiryMoneySum.add(inquiryIdBdCjAmountMap.get(inquiryPO.getInquiryId()));
                        }
                    }
                }
                //要保留原有非招的数量
                if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getQuoteBook())){
                    try {
                        Integer quoteBook = Integer.valueOf(sscSchemeTrackExtBO.getQuoteBook());
                        quoteBookNum += quoteBook;
                    }catch (Exception e){

                    }
                }
                if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEnquiryResult())){
                    try {
                        Integer enquiryResult = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryResult());
                        enquiryResultNum += enquiryResult;
                    }catch (Exception e){

                    }
                }
                if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEnquirySupplier())){
                    try {
                        Integer enquirySupplier = Integer.valueOf(sscSchemeTrackExtBO.getEnquirySupplier());
                        enquirySupplierNum += enquirySupplier;
                    }catch (Exception e){

                    }
                }
                if (sscSchemeTrackExtBO.getEnquiryMoney()!=null){
                    enquiryMoneySum = enquiryMoneySum.add(sscSchemeTrackExtBO.getEnquiryMoney());
                }
                if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEnquiryMat())){
                    try {
                        Integer enquiryMat = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryMat());
                        enquiryMatNum += enquiryMat;
                    }catch (Exception e){

                    }
                }
                sscSchemeTrackExtBO.setQuoteBook(quoteBookNum +"");
                sscSchemeTrackExtBO.setEnquiryResult(enquiryResultNum +"");
                sscSchemeTrackExtBO.setEnquirySupplier(enquirySupplierNum +"");
                sscSchemeTrackExtBO.setEnquiryMoney(enquiryMoneySum);
                sscSchemeTrackExtBO.setEnquiryMat(enquiryMatNum+"");
            }
        }
    }

    /**
     * 查询委托书对应的委托书、评标报告、定标报告、中选供应商、中选金额(元)、中选物资
     * @param sscSchemeTrackExtBOS
     */
    private void getCrcEntrust(List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS){
        List<Long> packIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS)){
            packIds = sscSchemeTrackExtBOS.stream().filter(e->e.getPackId()!=null).map(SscSchemeTrackExtBO::getPackId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(packIds)){
            return;
        }
        Map<Long, List<SscEntrustResultPO>> packIdMap = new HashMap<>();
        List<Long> allPbResultIds = new ArrayList<>();
        List<Long> allDbResultIds = new ArrayList<>();


        //查询定标表明细数据统计对应的中选供应商数量、中选金额（取成交总额）、中选物资改为中选物资项（取中标物资项数）
        Map<Long,Integer> resultIdBdSupCountMap = new HashMap<>();
        Map<Long,Integer> resultIdBdItemCountMap = new HashMap<>();
        Map<Long,BigDecimal> resultIdBdCjAmountMap = new HashMap<>();
        Map<Long,Integer> resultIdBjsCountMap = new HashMap<>();

        SscEntrustResultPO qryResultPO = new SscEntrustResultPO();
        qryResultPO.setPackIds(packIds);
        List<SscEntrustResultPO> entrustPOS = saasSchemePackMapper.qryResultTrackDownList(qryResultPO);
        if (!CollectionUtils.isEmpty(entrustPOS)){
            packIdMap = entrustPOS.stream().collect(Collectors.groupingBy(SscEntrustResultPO::getPackId));

            List<Long> resultIds = entrustPOS.stream().filter(e -> e.getResultId() != null).map(SscEntrustResultPO::getResultId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(resultIds)){
                //获取评标报告、定标报告的结果数量
                List<Long> pbResultIds = saasSchemePackMapper.qryExistSupPb(resultIds);
                if (!CollectionUtils.isEmpty(pbResultIds)){
                    allPbResultIds = pbResultIds;
                }
                List<Long> dbResultIds = saasSchemePackMapper.qryExistSupDb(resultIds);
                if (!CollectionUtils.isEmpty(dbResultIds)){
                    allDbResultIds = dbResultIds;
                    //再根据定标结果ids查询db明细表数据
                    List<SscInquiryItemDbPO> sscInquiryItemDbPOS = saasSchemePackMapper.qryResultDbItem(dbResultIds);
                    if (!CollectionUtils.isEmpty(sscInquiryItemDbPOS)){
                        Map<Long, List<SscInquiryItemDbPO>> resultIdDbMap = sscInquiryItemDbPOS.stream().collect(Collectors.groupingBy(SscInquiryItemDbPO::getResultId));
                        for (Long resultId : resultIdDbMap.keySet()) {
                            Set<Long> bdSupIds = new HashSet<>();
                            Set<Long> bdSchemaItemIds = new HashSet<>();
                            BigDecimal cjTotal = BigDecimal.ZERO;
                            for (SscInquiryItemDbPO itemDbPO : resultIdDbMap.get(resultId)) {
                                if (itemDbPO.getPurchaseCount()!=null && itemDbPO.getPurchaseCount().compareTo(BigDecimal.ZERO)>0){
                                    bdSupIds.add(itemDbPO.getSupId());
                                    bdSchemaItemIds.add(itemDbPO.getSchemaItemId());
                                    if (itemDbPO.getYzfAmount()!=null){
                                        cjTotal = cjTotal.add(itemDbPO.getYzfAmount());
                                    }
                                    if (itemDbPO.getHaveTaxAmount()!=null){
                                        cjTotal = cjTotal.add(itemDbPO.getHaveTaxAmount());
                                    }
                                }
                            }
                            resultIdBdSupCountMap.put(resultId,bdSupIds.size());
                            resultIdBdItemCountMap.put(resultId,bdSchemaItemIds.size());
                            resultIdBdCjAmountMap.put(resultId,cjTotal);
                        }
                    }
                }
                //查询报价书数量
                if (!CollectionUtils.isEmpty(resultIds)){
                    List<SscInquiryPO> bjsCount = saasSchemePackMapper.qryEntrustResultBjsCount(resultIds);
                    if (!CollectionUtils.isEmpty(bjsCount)){
                        resultIdBjsCountMap = bjsCount.stream().collect(Collectors.toMap(SscInquiryPO::getResultId, SscInquiryPO::getBjsCount));
                    }
                }
            }
        }
        //组装数据
        for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
            Integer entrustBookNum = 0;
            Integer bidReportNum = 0;
            Integer calibrationReportNum = 0;
            Integer bidSupplierNum = 0;
            BigDecimal bidMoneySum = BigDecimal.ZERO;
            Integer bidMatNum = 0;
            Integer bidQuoteBookNum = 0;
            if (packIdMap.containsKey(sscSchemeTrackExtBO.getPackId())){
                List<SscEntrustResultPO> entrustResultPOS = packIdMap.get(sscSchemeTrackExtBO.getPackId());
                entrustBookNum = entrustResultPOS.size();
                List<Long> resultIds = entrustResultPOS.stream().filter(e -> e.getResultId() != null).map(SscEntrustResultPO::getResultId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(resultIds)){

                    for (Long resultId : resultIds) {
                        if (allPbResultIds.contains(resultId)){
                            bidReportNum++;
                        }
                        if (allDbResultIds.contains(resultId)){
                            calibrationReportNum++;
                            if (resultIdBdSupCountMap.containsKey(resultId)){
                                bidSupplierNum += resultIdBdSupCountMap.get(resultId);
                                bidMoneySum = bidMoneySum.add(resultIdBdCjAmountMap.get(resultId));
                                bidMatNum += resultIdBdItemCountMap.get(resultId);
                            }
                        }
                        if (resultIdBjsCountMap.containsKey(resultId)){
                            bidQuoteBookNum += resultIdBjsCountMap.get(resultId);
                        }
                    }
                }
            }
            //要保留原有非招的数量
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEntrustBook())){
                try {
                    Integer entrustBook = Integer.valueOf(sscSchemeTrackExtBO.getEntrustBook());
                    entrustBookNum += entrustBook;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getBidReport())){
                try {
                    Integer bidReport = Integer.valueOf(sscSchemeTrackExtBO.getBidReport());
                    bidReportNum += bidReport;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getBidSupplier())){
                try {
                    Integer bidSupplier = Integer.valueOf(sscSchemeTrackExtBO.getBidSupplier());
                    bidSupplierNum += bidSupplier;
                }catch (Exception e){

                }
            }
            if (sscSchemeTrackExtBO.getBidMoney()!=null){
                bidMoneySum = bidMoneySum.add(sscSchemeTrackExtBO.getBidMoney());
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getBidMat())){
                try {
                    Integer bidMat = Integer.valueOf(sscSchemeTrackExtBO.getBidMat());
                    bidMatNum += bidMat;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getCalibrationReport())){
                try {
                    Integer calibrationReport = Integer.valueOf(sscSchemeTrackExtBO.getCalibrationReport());
                    calibrationReportNum += calibrationReport;
                }catch (Exception e){

                }
            }
            sscSchemeTrackExtBO.setEntrustBook(entrustBookNum+"");
            sscSchemeTrackExtBO.setBidReport(bidReportNum+"");
            sscSchemeTrackExtBO.setBidSupplier(bidSupplierNum+"");
            sscSchemeTrackExtBO.setBidMoney(bidMoneySum);
            sscSchemeTrackExtBO.setBidMat(bidMatNum+"");
            sscSchemeTrackExtBO.setCalibrationReport(calibrationReportNum+"");
            sscSchemeTrackExtBO.setBidQuoteBook(bidQuoteBookNum+"");
        }
    }

    /**
     * 查询集中采购寻源对应的报价书、询价结果、中选供应商、中选金额(元)、中选物资
     * @param sscSchemeTrackExtBOS
     */
    private void getCrcFindSource(List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS){
        List<Long> packIds = new ArrayList<>();
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS)){
            packIds = sscSchemeTrackExtBOS.stream().filter(e->e.getPackId()!=null).map(SscSchemeTrackExtBO::getPackId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(packIds)){
            return;
        }
        Map<Long, List<SScSchemeFindsourcePO>> packIdMap = new HashMap<>();
        Map<Long, Integer> sourceIdBjsCountMap = new HashMap<>();
        List<Long> allPbSourceIds = new ArrayList<>();
        List<Long> allDbSourceIds = new ArrayList<>();
        //查询定标表明细数据统计对应的中选供应商数量、中选金额（取成交总额）、中选物资改为中选物资项（取中标物资项数）
        Map<Long,Integer> sourceIdBdSupCountMap = new HashMap<>();
        Map<Long,Integer> sourceIdBdItemCountMap = new HashMap<>();
        Map<Long,BigDecimal> sourceIdBdCjAmountMap = new HashMap<>();

        SScSchemeFindsourcePO searchPO = new SScSchemeFindsourcePO();
        searchPO.setPackIds(packIds);
        List<SScSchemeFindsourcePO> schemeFindsourcePOS = saasSchemePackMapper.qryFindSourceTrackDownList(searchPO);
        if (!CollectionUtils.isEmpty(schemeFindsourcePOS)){
            packIdMap = schemeFindsourcePOS.stream().collect(Collectors.groupingBy(SScSchemeFindsourcePO::getPackId));
            //查询报价书数量
            List<Long> sourceIds = schemeFindsourcePOS.stream().map(SScSchemeFindsourcePO::getSourceId).collect(Collectors.toList());
            List<SscFindsourcePbPO> sscFindsourcePbPOS = saasSchemePackMapper.qryFindsourceBjsCount(sourceIds);
            if (!CollectionUtils.isEmpty(sscFindsourcePbPOS)){
                sourceIdBjsCountMap = sscFindsourcePbPOS.stream().collect(Collectors.toMap(SscFindsourcePbPO::getSourceId, SscFindsourcePbPO::getBjsCount));
            }
            //获取评标报告、定标报告的结果数量
            List<Long> pbSourceIds = saasSchemePackMapper.qryFindsourceExistSupPb(sourceIds);
            if (!CollectionUtils.isEmpty(pbSourceIds)){
                allPbSourceIds = pbSourceIds;
            }
            List<Long> dbSourceIds = saasSchemePackMapper.qryFindsourceExistSupDb(sourceIds);
            if (!CollectionUtils.isEmpty(dbSourceIds)){
                allDbSourceIds = dbSourceIds;
                //再根据定标结果ids查询db明细表数据
                List<SscInquiryItemDbPO> sscInquiryItemDbPOS = saasSchemePackMapper.qryFindsourceDbItem(dbSourceIds);
                if (!CollectionUtils.isEmpty(sscInquiryItemDbPOS)){
                    Map<Long, List<SscInquiryItemDbPO>> sourceIdDbMap = sscInquiryItemDbPOS.stream().collect(Collectors.groupingBy(SscInquiryItemDbPO::getSourceId));
                    for (Long sourceId : sourceIdDbMap.keySet()) {
                        Set<Long> bdSupIds = new HashSet<>();
                        Set<Long> bdSchemaItemIds = new HashSet<>();
                        BigDecimal cjTotal = BigDecimal.ZERO;
                        for (SscInquiryItemDbPO itemDbPO : sourceIdDbMap.get(sourceId)) {
                            if (itemDbPO.getPurchaseCount()!=null && itemDbPO.getPurchaseCount().compareTo(BigDecimal.ZERO)>0){
                                bdSupIds.add(itemDbPO.getSupId());
                                bdSchemaItemIds.add(itemDbPO.getSchemaItemId());
                                if (itemDbPO.getYzfAmount()!=null){
                                    cjTotal = cjTotal.add(itemDbPO.getYzfAmount());
                                }
                                if (itemDbPO.getHaveTaxAmount()!=null){
                                    cjTotal = cjTotal.add(itemDbPO.getHaveTaxAmount());
                                }
                            }
                        }
                        sourceIdBdSupCountMap.put(sourceId,bdSupIds.size());
                        sourceIdBdItemCountMap.put(sourceId,bdSchemaItemIds.size());
                        sourceIdBdCjAmountMap.put(sourceId,cjTotal);
                    }
                }
            }
        }
        //组装数据
        for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
            Integer enquiryBookNum = 0;
            Integer quoteBookNum = 0;
            Integer enquiryResultNum = 0;
            Integer enquirySupplierNum = 0;
            BigDecimal enquiryMoneySum = BigDecimal.ZERO;
            Integer enquiryMatNum = 0;
            Integer entrustBookNum = 0;
            Integer bidReportNum = 0;
            Integer bidSupplierNum = 0;
            BigDecimal bidMoneySum = BigDecimal.ZERO;
            Integer bidMatNum = 0;
            Integer calibrationReportNum = 0;
            Integer bidQuoteBookNum = 0;
            if (packIdMap.containsKey(sscSchemeTrackExtBO.getPackId())){
                List<SScSchemeFindsourcePO> sourcePOS = packIdMap.get(sscSchemeTrackExtBO.getPackId());
                //招标采购取 采购方式为 公开招标和邀请招标；询比采购 取 其它采购方式；数据来源为 集中采购寻源
                //采购方式（ 0-公开招标，1-邀请招标，2-公开竞争性谈判，3-邀请竞争性谈判，4-公开询价，5-邀请询价，6-单一来源 7-公开询比 8-邀请询比 9-直接采购(定商定价) 10-直接采购(执行协议)，11-公开竞谈，12-邀请竞谈，13-公开竞价，14-邀请竞价）
                //
                for (SScSchemeFindsourcePO sourcePO : sourcePOS) {
                    Long sourceId = sourcePO.getSourceId();
                    if (sourcePO.getPurchaseType()!=null && (sourcePO.getPurchaseType()==0 ||  sourcePO.getPurchaseType()==1)){
                        //招标采购
                        if (allPbSourceIds.contains(sourceId)){
                            bidReportNum ++;
                        }
                        if (allDbSourceIds.contains(sourceId)){
                            calibrationReportNum ++;
                            if (sourceIdBdSupCountMap.containsKey(sourceId)){
                                bidSupplierNum += sourceIdBdSupCountMap.get(sourceId);
                                bidMoneySum = bidMoneySum.add(sourceIdBdCjAmountMap.get(sourceId));
                                bidMatNum += sourceIdBdItemCountMap.get(sourceId);
                            }
                        }
                        if (sourceIdBjsCountMap.containsKey(sourceId)){
                            bidQuoteBookNum += sourceIdBjsCountMap.get(sourceId);
                        }
                        if (allDbSourceIds.contains(sourceId)){
                            calibrationReportNum ++;
                        }
                    }else {
                        //询比采购
                        enquiryResultNum++;
                        if (sourceIdBdSupCountMap.containsKey(sourceId)){
                            enquirySupplierNum += sourceIdBdSupCountMap.get(sourceId);
                            enquiryMoneySum = enquiryMoneySum.add(sourceIdBdCjAmountMap.get(sourceId));
                            enquiryMatNum += sourceIdBdItemCountMap.get(sourceId);
                        }
                        if (sourceIdBjsCountMap.containsKey(sourceId)){
                            quoteBookNum += sourceIdBjsCountMap.get(sourceId);
                        }
                    }
                }
            }
            //要保留原有非招的数量
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEnquiryBook())){
                try {
                    Integer enquiryBook = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryBook());
                    enquiryBookNum += enquiryBook;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getQuoteBook())){
                try {
                    Integer quoteBook = Integer.valueOf(sscSchemeTrackExtBO.getQuoteBook());
                    quoteBookNum += quoteBook;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEnquiryResult())){
                try {
                    Integer enquiryResult = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryResult());
                    enquiryResultNum += enquiryResult;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEnquirySupplier())){
                try {
                    Integer enquirySupplier = Integer.valueOf(sscSchemeTrackExtBO.getEnquirySupplier());
                    enquirySupplierNum += enquirySupplier;
                }catch (Exception e){

                }
            }
            if (sscSchemeTrackExtBO.getEnquiryMoney()!=null){
                enquiryMoneySum = enquiryMoneySum.add(sscSchemeTrackExtBO.getEnquiryMoney());
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEnquiryMat())){
                try {
                    Integer enquiryMat = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryMat());
                    enquiryMatNum += enquiryMat;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getEntrustBook())){
                try {
                    Integer entrustBook = Integer.valueOf(sscSchemeTrackExtBO.getEntrustBook());
                    entrustBookNum += entrustBook;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getBidReport())){
                try {
                    Integer bidReport = Integer.valueOf(sscSchemeTrackExtBO.getBidReport());
                    bidReportNum += bidReport;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getBidSupplier())){
                try {
                    Integer bidSupplier = Integer.valueOf(sscSchemeTrackExtBO.getBidSupplier());
                    bidSupplierNum += bidSupplier;
                }catch (Exception e){

                }
            }
            if (sscSchemeTrackExtBO.getBidMoney()!=null){
                bidMoneySum = bidMoneySum.add(sscSchemeTrackExtBO.getBidMoney());
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getBidMat())){
                try {
                    Integer bidMat = Integer.valueOf(sscSchemeTrackExtBO.getBidMat());
                    bidMatNum += bidMat;
                }catch (Exception e){

                }
            }
            if (!StringUtils.isEmpty(sscSchemeTrackExtBO.getCalibrationReport())){
                try {
                    Integer calibrationReport = Integer.valueOf(sscSchemeTrackExtBO.getCalibrationReport());
                    calibrationReportNum += calibrationReport;
                }catch (Exception e){

                }
            }
            sscSchemeTrackExtBO.setEnquiryBook(enquiryBookNum+"");
            sscSchemeTrackExtBO.setQuoteBook(quoteBookNum+"");
            sscSchemeTrackExtBO.setEnquiryResult(enquiryResultNum+"");
            sscSchemeTrackExtBO.setEnquirySupplier(enquirySupplierNum+"");
            sscSchemeTrackExtBO.setEnquiryMoney(enquiryMoneySum);
            sscSchemeTrackExtBO.setEnquiryMat(enquiryMatNum+"");
            sscSchemeTrackExtBO.setEntrustBook(entrustBookNum + "");
            sscSchemeTrackExtBO.setBidReport(bidReportNum + "");
            sscSchemeTrackExtBO.setBidSupplier(bidSupplierNum +"");
            sscSchemeTrackExtBO.setBidMoney(bidMoneySum);
            sscSchemeTrackExtBO.setBidMat(bidMatNum +"");
            sscSchemeTrackExtBO.setCalibrationReport(calibrationReportNum +"");
            sscSchemeTrackExtBO.setBidQuoteBook(bidQuoteBookNum +"");
        }
    }
}


