package com.tydic.dyc.ssc.repositoryExt.impl;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.bo.SchemeHistoryBO;
import com.tydic.dyc.ssc.bo.SchemeHistoryReqBO;
import com.tydic.dyc.ssc.bo.SchemeHistoryRspBO;
import com.tydic.dyc.ssc.bo.SscAccessoryExtBO;
import com.tydic.dyc.ssc.repository.SchemeHistoryExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SscAccessoryExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeStatusChngExtMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscAccessoryPO;

/**
 * 作者 85222
 * 创建日期 2023年04月03日
 */
@Service
public class SchemeHistoryExtRepositoryImpl implements SchemeHistoryExtRepository {
    @Autowired
    private SscSchemeStatusChngExtMapper sscSchemeStatusChngMapper;
    @Autowired
    private SscAccessoryExtMapper sscAccessoryMapper;
    @Override
    public SchemeHistoryRspBO selectSchemeHistory(SchemeHistoryReqBO bo) {
    	SchemeHistoryRspBO rspBO = new SchemeHistoryRspBO();
    	
    	Page<SchemeHistoryReqBO> pg = new Page<SchemeHistoryReqBO>(bo.getPageNo(), bo.getPageSize());
        List<SchemeHistoryBO> schemeHistoryRspBOS = sscSchemeStatusChngMapper.selectSchemeHistory(bo,pg);
        for (SchemeHistoryBO schemeHistoryRspBO : schemeHistoryRspBOS) {
            SscAccessoryPO accessory = new SscAccessoryPO();
            accessory.setObjId(schemeHistoryRspBO.getId());
            if("4".equals(bo.getOperType())){//分交方式
                schemeHistoryRspBO.setOldSchemeStatusStr(schemeSubmitType(schemeHistoryRspBO.getOldSchemeStatus()));
                schemeHistoryRspBO.setNewSchemeStatusStr(schemeSubmitType(schemeHistoryRspBO.getNewSchemeStatus()));
            }else if("0".equals(bo.getOperType()) || "1".equals(bo.getOperType()) || "7".equals(bo.getOperType())) {
            	schemeHistoryRspBO.setOldSchemeStatusStr(schemeStatus(schemeHistoryRspBO.getOldSchemeStatus()));
                schemeHistoryRspBO.setNewSchemeStatusStr(schemeStatus(schemeHistoryRspBO.getNewSchemeStatus()));
            }else if("2".equals(bo.getOperType())) {
            	schemeHistoryRspBO.setOldSchemeStatusStr(purchWay(schemeHistoryRspBO.getOldSchemeStatus()));
                schemeHistoryRspBO.setNewSchemeStatusStr(purchWay(schemeHistoryRspBO.getNewSchemeStatus()));
            }
            schemeHistoryRspBO.setSscAccessory(JUtil.jsl(sscAccessoryMapper.selectAll(accessory), SscAccessoryExtBO.class));
        }
        rspBO.setSchemeHistoryBOs(schemeHistoryRspBOS);
        rspBO.setPageNo(pg.getPageNo());
        rspBO.setRecordsTotal(pg.getTotalCount());
        return rspBO;
    }
    private String schemeSubmitType(String s){
        if (StringUtils.isEmpty(s)){
            return "";
        }
        switch(s){
            case "0" :
                s="集采实施-自营";
                break;
            case "1" :
                s="集采实施-代理采购";
                break;
            case "2" :
                s="企业自采";
                break;
        }
        return s;
    }
    
    private String schemeStatus(String s){
        if (StringUtils.isEmpty(s)){
            return "";
        }
        switch(s){
            case "0" :
                s="已完成";
                break;
            case "1" :
                s="委托中";
                break;
            case "2" :
                s="已受理";
                break;
            case "3" :
                s="委托退回";
                break;
            case "4" :
                s="已变更";
                break;
            case "5" :
                s="已挂起";
                break;
            case "6" :
                s="已终止";
                break;
            case "7" :
                s="企业核实";
                break;
            case "8" :
                s="变更中";
                break;
        }
        return s;
    }
    
    private String purchWay(String s){
        if (StringUtils.isEmpty(s)){
            return "";
        }
        switch(s){
            case "0" :
                s="公开招标";
                break;
            case "1" :
                s="邀请招标";
                break;
            case "6" :
                s="单一来源";
                break;
            case "7" :
                s="公开询比";
                break;
            case "8" :
                s="邀请询比";
                break;
            case "9" :
                s="直接采购（定商定价）";
                break;
            case "10" :
                s="直接采购（执行协议）";
                break;
            case "11" :
                s="公开竞谈";
                break;
            case "12" :
                s="邀请竞谈";
                break;
            case "13" :
                s="公开竞价";
                break;
            case "14" :
                s="邀请竞价";
                break;
        }
        return s;
    }
}


