package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.bo.SscSchemeRspBO;
import com.tydic.dyc.ssc.repository.dao.SscSchemeMapper;
import com.tydic.dyc.ssc.repository.dao.SscSchemeMatMapper;
import com.tydic.dyc.ssc.repositoryExt.config.SscThreadPoolExecutorUtil;
import com.tydic.dyc.ssc.repositoryExt.po.syncSchemeListPO;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemePackExtServie;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import com.tydic.dyc.ssc.service.scheme.syncSchemeListService;
import lombok.extern.ohaotian.HTServiceAPI;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import com.tydic.dyc.ssc.repositoryExt.dao.*;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 描述:
 *
 * @author WangGang
 * @date 2024/7/17
 */
@Slf4j
@HTServiceImpl
public class syncSchemeListServiceImpl implements syncSchemeListService {

    @Autowired
    private SaasSchemePackMapper schemePackMapper;
    @Value("${PAGE_SIZE:100}")
    private int PAGE_SIZE;
    @Value("${MaxSize:200}")
    private int MaxSize;

    @HTServiceRef
    private SscQrySchemePackExtServie schemePackExtServie;

    /**
     * 线程池
     */
    private static final ThreadPoolExecutor threadPoolExecutor = SscThreadPoolExecutorUtil.poolExecutor;

    @Override
    public SscQrySchemePackExtRspBO syncSchemeList(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO busiRspBO = new SscQrySchemePackExtRspBO();
        log.error("同步方案ES开启=====");
        if (CollectionUtils.isEmpty(reqBO.getSchemeIds()) && null == reqBO.getSchemeId()) {
            busiRspBO.setRespCode(RspConstant.REQ_PARAM_NULL_ERROR);
            busiRspBO.setRespDesc("入参为空");
            return busiRspBO;
        }
        List<Long> ids = new ArrayList<>();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())) {
            ids.addAll(reqBO.getSchemeIds());
        }
        if (null != reqBO.getSchemeId()) {
            ids.add(reqBO.getSchemeId());
        }
        List<SscQrySchemePackExtBO> syncList = new ArrayList<>();
        for (Long schemeId : ids) {
            SscQrySchemePackExtBO sscQrySchemePackExtBO = new SscQrySchemePackExtBO();
            sscQrySchemePackExtBO.setSchemeId(schemeId);
            syncList.add(sscQrySchemePackExtBO);
        }
        dealData(syncList);
        busiRspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        busiRspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return busiRspBO;
    }

    @Override
    public SchemeListRspBO qrySchemeByPlanId(SscQrySchemePackExtReqBO reqBO) {
        SchemeListRspBO rspBO = new SchemeListRspBO();
        if(Objects.isNull(reqBO)){
            throw new ZTBusinessException("入参不能为空");
        }
        if(Objects.isNull(reqBO.getPlanId()) && CollectionUtils.isEmpty(reqBO.getPlanIds())){
            throw new ZTBusinessException("入参不能为空");
        }
        List<SscSchemeBO> sscSchemeBOS = schemePackMapper.qrySchemeByPlan(reqBO);
        if(!CollectionUtils.isEmpty(sscSchemeBOS)){
            rspBO.setSchemeList(JSON.parseArray(JSON.toJSONString(sscSchemeBOS), SscSchemeRspBO.class));
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    private void dealData( List<SscQrySchemePackExtBO> syncList) {
        CompletableFuture.runAsync(() -> {
            for (SscQrySchemePackExtBO sscQrySchemePackExtBO : syncList) {
                Long objId = schemePackMapper.queryObjId(sscQrySchemePackExtBO.getSchemeId());
                log.error("Objid============" +objId);
                log.error("SchemeId()============" +sscQrySchemePackExtBO.getSchemeId());
                if (null != objId){
                    SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
                    sscQrySchemePackExtReqBO.setOrderId(sscQrySchemePackExtBO.getSchemeId());
                    sscQrySchemePackExtReqBO.setObjId(objId);
                    schemePackExtServie.syncTaskBySchemeId(sscQrySchemePackExtReqBO);
                }
            }
        });
    }
}
