package com.tydic.dyc.ssc.repositoryExt.dao;

import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoExtBO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author jmrg
 * @dATE 2023/7/25
 * @Desc
 */
@Mapper
public interface PlatFormSscSchemeMapper {

    List<SscSchemePO> listByParamLimitCreateTime(SscQrySchemeMainInfoExtBO param);

    List<SscSchemePO> listByParamLimitUpdateTime(SscQrySchemeMainInfoExtBO param);

    List<SscSchemePO> getDataByParamCreate(SscQrySchemeMainInfoExtBO param);

    List<SscSchemePO> getDataByParamUpdate(SscQrySchemeMainInfoExtBO param);

    /**
     * 根据id查询
     * @param schemePO
     * @return
     */
    SscSchemePO getBySchemeId(SscSchemePO schemePO);

    /**
     * 查询列表
     * @param schemePO
     * @return
     */
    List<SscSchemePO> getList(SscSchemePO schemePO);

    /**
     * 批量更新关联状态
     *
     * @param updateSchemePOList
     */
    void updateRelationStatus(@Param("updateSchemePOList") List<SscSchemePO> updateSchemePOList);


    /**
     * 查询近期相同物料的采购方案
     * @param sscSchemePO
     * @return
     */
    List<SscSchemePO> queryRecentSchemeMatList(SscSchemePO sscSchemePO);

    /**
     * 查询近期相同物料的采购方案金额总和
     * @param sscSchemePO
     * @return
     */
    List<SscSchemePO> queryRecentSchemeEstAmount(SscSchemePO sscSchemePO);
}
