package com.tydic.dyc.ssc.repositoryExt.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.repository.po.SscSchemeInviteDraftPO;
import com.tydic.dyc.ssc.repositoryExt.po.*;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2023/4/13 14:24
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Mapper
@Repository
public interface SaasSchemePackMapper {
    /**
     * 根据方案Ids 查询包Ids
     * @param schemeIds
     * @return
     */
    List<SaasSchemePackPO> qryPackBySchemeIds(@Param("schemeIds") List<Long> schemeIds);


    List<Long> qryXyCount(@Param("packIds") List<Long> packIds);

    /**
     * 批量修改
     * @param
     * @return
     */
    int updateSchemeMatAmountBatchExt(List<SscUpdateSchemeMatAmountBatchExtExtBO> updateMats);

    List<SscSchemePO> getModelBy(SscSchemePO schemePO);
    /**
     * 根据包Ids 查询包Ids
     * @param packIds
     * @return
     */
    List<SaasSchemePackPO> qryPackByPackIds(@Param("packIds") List<Long> packIds);

    /**
     * 根据包Ids 清空 包的 采购员信息
     * @param packIds
     * @return
     */
    int   updateSchemePackImplCodeExect(@Param("packIds") List<Long> packIds);

    /**
     * 根据方案ids 修改包的执行状态
     * @param schemeIds
     * @return
     */
    int   updatePackPackStatus(@Param("schemeIds") List<Long> schemeIds,@Param("packExectStatus") String packExectStatus);

    /**
     * 根据方案ids 修改方案的执行状态
     * @param schemeIds
     * @return
     */
    int   updateSchemePackStatus(@Param("schemeIds") List<Long> schemeIds,@Param("packExectStatus") String packExectStatus);

    SscQrySchemeExectStatusPackExtBO qrySchemeExist(@Param("schemeId") Long schemeId);

    /**
     * 根据方案ids 查询最新的实例id
     * @param schemeIds
     * @return
     */
    List<SscQrySchemeExectStatusPackExtBO> qrySchemeAuditProclnstld(@Param("schemeIds") List<Long> schemeIds);
    /**
     * 根据方案ids 查询方案的执行状态
     * @param schemeIds
     * @return
     */
    List<SscQrySchemePackExtBO> qrySchemeExectStatusBySchemeIds(@Param("schemeIds") List<Long> schemeIds);
    /**
     * 根据方案ids 查询方案的执行状态
     * @param packIds
     * @return
     */
    List<SscQrySchemePackExtBO> qryPackStatusByByPackIds(@Param("packIds") List<Long> packIds);

    /**
     * 根据包Ids 修改 包的 采购员信息
     * @param
     * @return
     */
    int   updateSchemePackImplCodeByBoExect(SscQrySchemePackExtReqBO bo);

    /**
     * 根据包Ids 修改 包的 状态
     * @param
     * @return
     */
    int   updatePackStatus(@Param("packIds") List<Long> packIds,@Param("packStatus") String packStatus);

    /**
     * 根据包Ids 修改 包的 采购员信息
     * @param
     * @return
     */
    int   updateClearSchemeSchemeExectStatus(@Param("schemeId") Long schemeId,@Param("schemeExectStatus") String schemeExectStatus);

    /**
     * 根据采购包Ids 查询集采包
     * @param packIds
     * @return
     */
    List<SaasSchemePackPO> qryPackByPurchasePackIds(@Param("packIds") List<Long> packIds);
    /**
     * 根据方案ids 查询非招主键Id
     * @param schemeIds
     * @return
     */
    List<SscQrySchemeExectStatusPackExtBO> qryNonRecruitmentIdBySchemeIds(@Param("schemeIds") List<Long> schemeIds);

    /**
     * 根据方案ids 查询扩展信息
     * @param schemeIds
     * @return
     */
    List<SscSchemeQryPO> getSscSchemeExtList(@Param("schemeIds") List<Long> schemeIds);

    /**
     * 根据方案ids  查询非招同步状态（不同类型的推送最新的一条）
     * @param schemeIds
     * @return
     */
    List<SscQrySchemePackExtBO> groupQryPushStatus(@Param("schemeIds") List<Long> schemeIds,@Param("types") List<Integer> types);
    /**
     * 根据方案ids  查询招标同步状态（不同类型的推送最新的一条）
     * @param schemeIds
     * @return
     */
    List<SscQrySchemePackExtBO> groupQryPackPushStatus(@Param("packIds") List<Long> schemeIds,@Param("types") List<Integer> types);

    /**
     * 根据方案id  查询推送非招同步记录
     * @param
     * @return
     */
    List<SscQrySchemePackExtBO> qryPushStatusListPage(SscQrySchemePackExtReqBO bo, Page<SscQrySchemePackExtBO> pg);

    /**
     * 根据packId  查询推送招标同步记录
     * @param
     * @return
     */
    List<SscQrySchemePackExtBO> qryPackPushStatusListPage(SscQrySchemePackExtReqBO bo, Page<SscQrySchemePackExtBO> pg);
    /**
     * 根据计划id 修改 通用物料编码
     * @param
     * @return
     */
    int updateCommonItemNo(SchemeMatExtBO reqBO);

    /**
     * 根据计划id 修改 通用物料编码的扩展字段 collecControl 集采管控目录
     * @param
     * @return
     */
    int updateCommonItemNoCollecControlExt(@Param("schemeMatId") List<Long> schemeMatId,@Param("inControlsCatalog") String inControlsCatalog);

    /**
     * 根据计划id 修改 通用物料编码的扩展字段 collecImpl 集采实施目录
     * @param
     * @return
     */
    int updateCommonItemNocollecImplExt(@Param("schemeMatId") List<Long> schemeMatId,@Param("inImplementCatalog") String inImplementCatalog);

    /**
     * 根据计划id 修改 通用物料编码
     * @param
     * @return
     */
    List<Long> getCommonItemNoSchemeMatIds(@Param("planId") Long planId,@Param("pageNo") Integer pageNo,@Param("pageSize") Integer pageSize);

    /**
     * 根据方案编号 查询方案是否存在
     * @param schemeNo
     * @return
     */
    List<SscQrySchemeExectStatusPackExtBO> qrySchemeBySchemeNo(@Param("schemeNo") String schemeNo);

    /**
     * 根据packIds 修改包的寻源人字段
     * @param
     * @return
     */
    int  updatePackImplCodeDefault(@Param("packIds") List<Long> packIds,@Param("implCode") String implCode,@Param("implName") String implName);

    /**
     * 根据方案id 查询计划物资明细数据，这个接口为了同步方案量
     * 查询草稿表
     * @param schemeId
     * @param isExcludePurchasePackage 是否排除采购包，一般是集采方案查询才传这个值
     * @return
     */
    List<SscQryMatExtBO> qryDraftPlanMatBySchemeId(@Param("schemeId") Long schemeId,@Param("isExcludePurchasePackage") Integer isExcludePurchasePackage,@Param("purchasePackageIds") List<Long> purchasePackageIds);
    /**
     * 根据方案id 查询计划物资明细数据，这个接口为了同步方案量
     * 查询正式表
     * @param schemeId
     * @param isExcludePurchasePackage 是否排除采购包，一般是集采方案查询才传这个值
     * @return
     */
    List<SscQryMatExtBO> qryFormalPlanMatBySchemeId(@Param("schemeId") Long schemeId,@Param("isExcludePurchasePackage") Integer isExcludePurchasePackage);
    /**
     * 根据方案id 查询计划物资明细数据，这个接口为了同步方案量
     * 查询历史表
     * @param schemeId
     * @param isExcludePurchasePackage 是否排除采购包，一般是集采方案查询才传这个值
     * @return
     */
    List<SscQryMatExtBO> qryHislPlanMatBySchemeId(@Param("schemeId") Long schemeId,@Param("isExcludePurchasePackage") Integer isExcludePurchasePackage,@Param("schemeHisId") Long schemeHisId);

    /**
     * 根据方案id和包id删除 供应商草稿表的数据
     *
     * @param
     * @return int 影响数量
     */
    int deleteSchemeInviteDraftBy(@Param("schemeInviteSupIds") List<Long> schemeInviteSupIds);

    /**
     * 根据供应商ids删除 供应商扩展草稿表的数据
     *
     * @param
     * @return int 影响数量
     */
    int deleteSchemeInviteExtDraftBy(@Param("schemeInviteSupIds") List<Long> schemeInviteSupIds );

    /**
     * 根据方案id和包id查询 供应商草稿表的供应商id数据
     * @return
     */
    List<Long> qrySchemeInviteDraft(@Param("schemeId") Long schemeId,@Param("packId") Long packId);



    /**
     * 根据方案ids 清空 包的 assignStatus 分配状态
     * @param schemeIds
     * @return
     */
    int   updateSchemePackAssignStatusExect(@Param("schemeIds") List<Long> schemeIds );
    /**
     * 根据方案ids 查询方案的分交方式和版本号
     * 查询正式表
     * @return
     */
    List<SscQrySchemePackExtBO> qrySchemeSubmitType(@Param("schemeIds") List<Long> schemeIds );

    List<SscSchemeTenderReportListBO> getSchemeFindSource(SchemeTenderReportReqBO po,Page<SscSchemeTenderReportListBO> page);

    List<SscSchemeTenderReportListBO> qrySchemeFindSourceBypackIds(List<String> packIds);

    List<SscSchemeTenderReportListBO> getSchemeEntrust(SchemeTenderReportReqBO po,Page<SscSchemeTenderReportListBO> page);

    List<SscSchemeTenderReportListBO> getSchemeInquiry();

    List<SscSchemeMatNum> querySchemeXYFindSourceAmount(@Param("schemeMatIds") List<String> schemeMatIds);

    List<SscSchemeMatNum> querySchemeXYEntrustResultAmount(@Param("schemeMatIds") List<String> schemeMatIds);

    List<SscSchemeMatNum> querySchemeXYInquiryAmount(@Param("schemeMatIds") List<String> schemeMatIds);

    int updateXYFindSourceAmount(SscSchemeMatNum updateSscScheme);

    int updateXYEntrustResultAmount(SscSchemeMatNum updateSscScheme);

    int updateXYInquiryAmount(SscSchemeMatNum updateSscScheme);

    /**
     * 根据包ids 查询方案的创建时间 和 是否委托 和 创建人信息
     * 查询正式表
     * @return
     */
    List<SscQrySchemePackExtBO> qrySchemeOrganizationFormByPackIds(@Param("packIds") List<Long> packIds );

    int updateSchemeNullField(@Param("schemeId") Long schemeId);
    /**
     * 根据包ids查询方案ids
     * @param packIds
     * @return
     */
    List<Long> getSchemeIdByPackIds(@Param("packIds")List<Long> packIds);

    /**
     * 根据方案ids 查询方案的创建时间 和 是否委托 和 创建人信息
     * 查询正式表
     * @return
     */
    List<SscQrySchemePackExtBO> qrySchemeOrganizationFormBySchemeIds(@Param("schemeIds") List<Long> schemeIds );
    /**
     * 简易计划根据方案ids 查询寻源人信息
     * 查询正式表
     * @return
     */
    List<SscQrySchemePackExtBO> qryImplInfoBySchemeIds(@Param("schemeIds") List<Long> schemeIds );

    /**
     * 查询上一步骤的审批完成时间
     * @param procInstId
     * @param formUrl
     * @return
     */
    Date getLastFinishTime(@Param("procInstId") String procInstId,@Param("formUrl") String formUrl);


    int queryCount();

    List<SscQrySchemePackExtBO> querySchemePage(Page<syncSchemeListPO> page);


    Long queryObjId(@Param("schemeId") Long schemeId);

    Long querySchemeId(@Param("schemeId")Long schemeId);

    /**
     * 根据包id或者方案id统计对应的询价书数量
     * @param schemePackIds
     * @param schemeIds
     * @return
     */
    List<SscQryInquiryInfoExtBo> qryInquiryCount(@Param("schemePackIds")List<Long> schemePackIds,@Param("schemeIds") List<Long> schemeIds);

    List<SscInquiryPO> qryInquiryTrackDownList(SscInquiryPO crcInquiryPO);

    /**
     * 根据询价结果ids 查询对应的报价书数量
     * @return
     */
    List<SscInquiryPO> qryInquiryBjsCount(@Param("inquiryIds")List<Long> inquiryIds);

    /**
     * 根据询价结果ids 查询对应的中标金额
     * @return
     */
    List<SscInquiryPO> qryInquiryBdCjTotalAmount(@Param("inquiryIds")List<Long> inquiryIds);

    /**
     * 根据询价结果ids 查询对应的中标表的明细
     * @return
     */
    List<SscInquiryItemDbPO> qryInquiryDbItem(@Param("inquiryIds")List<Long> inquiryIds);

    List<SscEntrustResultPO> qryResultTrackDownList(SscEntrustResultPO crcEntrustPO);

    /**
     * 获取评标报告、定标报告的结果数量
     * @param resultIds
     * @return
     */
    List<Long> qryExistSupPb(@Param("resultIds")List<Long> resultIds);

    /**
     * 获取评标报告、定标报告的结果数量
     * @param resultIds
     * @return
     */
    List<Long> qryExistSupDb(@Param("resultIds")List<Long> resultIds);

    /**
     * 根据询价结果ids 查询对应的中标表的明细
     * @return
     */
    List<SscInquiryItemDbPO> qryResultDbItem(@Param("resultIds")List<Long> resultIds);

    List<SScSchemeFindsourcePO> qryFindSourceTrackDownList(SScSchemeFindsourcePO crcEntrustPO);

    /**
     * 根据寻源结果ids查询报价书量
     * @param sourceIds
     * @return
     */
    List<SscFindsourcePbPO> qryFindsourceBjsCount(@Param("sourceIds") List<Long> sourceIds);
    /**
     * 获取评标报告、定标报告的结果数量
     * @param sourceIds
     * @return
     */
    List<Long> qryFindsourceExistSupPb(@Param("sourceIds")List<Long> sourceIds);
    /**
     * 获取评标报告、定标报告的结果数量
     * @param sourceIds
     * @return
     */
    List<Long> qryFindsourceExistSupDb(@Param("sourceIds")List<Long> sourceIds);

    /**
     * 根据询价结果ids 查询对应的中标表的明细
     * @return
     */
    List<SscInquiryItemDbPO> qryFindsourceDbItem(@Param("sourceIds")List<Long> sourceIds);

        /**
     * 根据委托书结果ids查询报价书量
     * @param resultIds
     * @return
     */
    List<SscInquiryPO> qryEntrustResultBjsCount(@Param("resultIds")List<Long> resultIds);

    List<SscSchemeBO> qrySchemeByPlan(SscQrySchemePackExtReqBO reqBO);

    /**
     * 根据包id或者方案id统计对应的询价书中的报价书数量
     * @param schemePackIds
     * @param schemeIds
     * @return
     */
    List<SscQryInquiryInfoExtBo> qryInquiryQuoteCount(@Param("schemePackIds")List<Long> schemePackIds,@Param("schemeIds") List<Long> schemeIds);

    List<SscQrySchemePackExtBO> selectAllByPage(@Param("pageNo") int pageNo,@Param("pageSize") int pageSize);

}
