package com.tydic.dyc.ssc.repositoryExt.impl;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeInviteSupExtDealMapper;
import com.tydic.dyc.ssc.repositoryExt.po.UocOrderTaskInstPO;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.repository.QryPlanPackExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SscPlanPackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SysDicDictionaryMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscQryPlanPackExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SysDicDictionaryPO;
import com.tydic.dyc.ssc.utils.SscRu;

@Service
public class QryPlanPackExtRepositoryImpl implements QryPlanPackExtRepository {

    @Autowired
    private SscPlanPackMapper sscPlanPackMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private SscSchemeInviteSupExtDealMapper sscSchemeInviteSupExtDealMapper;


    @Override
    public List<SscQryPlanPackBO> getTaskInstData(List<Long> schemeIds) {
        List<SscQryPlanPackBO> packBOList = new ArrayList<>();
        packBOList = sscPlanPackMapper.selectProcInstIdByOrderIds(schemeIds);
        return packBOList;
    }

    @Override
    public SscQryPlanPackExtRspBO selectPlanPack(SscQryPlanPackExtReqBO reqBO) {
        if (null != reqBO.getCreateEndTime()) {
            Date createEndTime = reqBO.getCreateEndTime();
            String format = DateFormatUtils.format(createEndTime, "yyyy-MM-dd 23:59:59");
            DateTime parse = DateUtil.parse(format);
            reqBO.setCreateEndTime(parse);
        }
        SscQryPlanPackExtRspBO rspBO = new SscQryPlanPackExtRspBO();
        Page<SscQryPlanPackExtPO> pg = new Page<SscQryPlanPackExtPO>(reqBO.getPageNo(), reqBO.getPageSize());
        SscQryPlanPackExtPO js = SscRu.js(reqBO, SscQryPlanPackExtPO.class);
        List<SscQryPlanPackBO> selectPlanPack = null;
        if (reqBO.getSchemeOrPack().startsWith("scheme")) {
            if ("scheme_1".equals(reqBO.getSchemeOrPack())) {
                selectPlanPack = sscPlanPackMapper.selectPackBySchemeId(js);
            } else {
                selectPlanPack = sscPlanPackMapper.selectSchemeExtPachInfo(js, pg);
                //rspBO.setTotal(pg.getTotalCount());
                //总页数
                rspBO.setTotal(pg.getTotalPages());
                //总条数
                rspBO.setRecordsTotal(pg.getTotalCount());
                if (!CollectionUtils.isEmpty(selectPlanPack)) {
                    List<Long> schemeIdList = new ArrayList<>();
                    for (SscQryPlanPackBO bo : selectPlanPack) {
                        schemeIdList.add(bo.getSchemeId());
                    }
                    List<SscQryPlanPackBO> sscQryPlanPackBOS = sscPlanPackMapper.selectProcInstIdByOrderId(schemeIdList);
                    //拿到最新的任务id
                    Map<String, Long> procInstIdMap = new HashMap<>();
                    if (!CollectionUtils.isEmpty(sscQryPlanPackBOS)) {
                        List<String> procInstIds = sscQryPlanPackBOS.stream().filter(e -> !StringUtils.isEmpty(e.getProcInstId())).map(SscQryPlanPackBO::getProcInstId).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(procInstIds)) {
                            List<UocOrderTaskInstPO> uocOrderTaskInstPOS = sscPlanPackMapper.selectTaskByProcInstIds(procInstIds);
                            if (!CollectionUtils.isEmpty(uocOrderTaskInstPOS)) {
                                for (UocOrderTaskInstPO uocOrderTaskInstPO : uocOrderTaskInstPOS) {
                                    try {
                                        procInstIdMap.put(uocOrderTaskInstPO.getProcInstId(), Long.valueOf(uocOrderTaskInstPO.getTaskInstId()));
                                    } catch (Exception e) {

                                    }
                                }
                            }
                        }
                    }
                    List<SscQryPlanPackBO> list = new ArrayList<>();
                    List<Long> strList = new ArrayList<>();
                    for (SscQryPlanPackBO bo : sscQryPlanPackBOS) {
                        if (!strList.contains(bo.getSchemeId())) {
                            list.add(bo);
                            strList.add(bo.getSchemeId());
                        }
                    }
                    for (SscQryPlanPackBO bo : selectPlanPack) {
                        for (SscQryPlanPackBO sysDicDictionaryPO : list) {
                            if (bo.getSchemeId().equals(sysDicDictionaryPO.getSchemeId())) {
                                bo.setProcInstId(sysDicDictionaryPO.getProcInstId());
                                bo.setAuditProclnstld(sysDicDictionaryPO.getProcInstId());
                                if (!StringUtils.isEmpty(sysDicDictionaryPO.getProcInstId())) {
                                    bo.setTaskId(procInstIdMap.get(sysDicDictionaryPO.getProcInstId()));
                                }
                                break;
                            }
                        }
                    }

                    SysDicDictionaryPO pi = new SysDicDictionaryPO();
                    pi.setPCode("APPROVAL_TYPE");
                    List<SysDicDictionaryPO> selectDictionary = sysDicDictionaryMapper.selectDictionary(pi);
                    if (!CollectionUtils.isEmpty(selectDictionary)) {
                        for (SscQryPlanPackBO bo : selectPlanPack) {
                            for (SysDicDictionaryPO sysDicDictionaryPO : selectDictionary) {
                                if (StringUtils.isNotBlank(bo.getSchemeAuditStatus()) && bo.getSchemeAuditStatus().equals(sysDicDictionaryPO.getCode())) {
                                    bo.setSchemeAuditStatusStr(sysDicDictionaryPO.getDescrip());
                                    break;
                                }
                            }
                        }
                    }

                    pi = new SysDicDictionaryPO();
                    pi.setPCode("PURCH_WAY");
                    selectDictionary = sysDicDictionaryMapper.selectDictionary(pi);
                    if (!CollectionUtils.isEmpty(selectDictionary)) {
                        for (SscQryPlanPackBO bo : selectPlanPack) {
                            for (SysDicDictionaryPO sysDicDictionaryPO : selectDictionary) {
                                if (StringUtils.isNotBlank(bo.getPurchaseType()) && bo.getPurchaseType().equals(sysDicDictionaryPO.getCode())) {
                                    bo.setPurchaseTypeStr(sysDicDictionaryPO.getDescrip());
                                    break;
                                }
                            }
                        }
                    }
                }

                String isAssignString = "待分配";
                if ("待分配".equals(reqBO.getAssignStatus())) {
                    isAssignString = "已分配";
                }
                int selectCountBySchemeId = sscPlanPackMapper.selectCountBySchemeId(isAssignString);
                rspBO.setOtherTotal(selectCountBySchemeId + "");
            }
        } else {
            selectPlanPack = sscPlanPackMapper.selectPlanPack(js, pg);
            if (!CollectionUtils.isEmpty(selectPlanPack)) {
                SysDicDictionaryPO pi = new SysDicDictionaryPO();
                pi.setPCode("PURCH_WAY");
                List<SysDicDictionaryPO> selectDictionary = selectDictionary = sysDicDictionaryMapper.selectDictionary(pi);
                if (!CollectionUtils.isEmpty(selectDictionary)) {
                    for (SscQryPlanPackBO bo : selectPlanPack) {
                        for (SysDicDictionaryPO sysDicDictionaryPO : selectDictionary) {
                            if (StringUtils.isNotBlank(bo.getPurchaseType()) && bo.getPurchaseType().equals(sysDicDictionaryPO.getCode())) {
                                bo.setPurchaseTypeStr(sysDicDictionaryPO.getDescrip());
                                break;
                            }
                        }
                    }
                }
            }
            //rspBO.setTotal(pg.getTotalCount());
            //总页数
            rspBO.setTotal(pg.getTotalPages());
            //总条数
            rspBO.setRecordsTotal(pg.getTotalCount());
        }
        if (!CollectionUtils.isEmpty(selectPlanPack)) {
            List<Long> schemeIds = selectPlanPack.stream().map(SscQryPlanPackBO::getSchemeId).collect(Collectors.toList());
            List<SscQryPlanPackBO> maps = sscPlanPackMapper.selectSchemePackExtInfoBySchemeIds(schemeIds, "采购员名称");
            Map<Long, String> collect = maps.stream().collect(Collectors.toMap(SscQryPlanPackBO::getSchemeId, SscQryPlanPackBO::getPurchaseUserName));
            List<Long> packIds = selectPlanPack.stream().filter(e -> e.getPackId() != null).map(SscQryPlanPackBO::getPackId).collect(Collectors.toList());
            selectPlanPack.forEach(e -> {
                e.setPurchaseUserName(collect.get(e.getSchemeId()));
            });
            if (!CollectionUtils.isEmpty(packIds)) {
                List<SscSchemeInviteSupExtDealPO> sscSchemeInviteSupExtDealPOS = sscSchemeInviteSupExtDealMapper.getListByPackIds(packIds);
                Map<Long, List<SscSchemeInviteSupExtDealPO>> packIdMap = new HashMap<>();
                if (!CollectionUtils.isEmpty(sscSchemeInviteSupExtDealPOS)) {
                    packIdMap = sscSchemeInviteSupExtDealPOS.stream().collect(Collectors.groupingBy(SscSchemeInviteSupExtDealPO::getPackId));
                }
                for (SscQryPlanPackBO planPackBO : selectPlanPack) {
                    if (packIdMap.keySet().contains(planPackBO.getPackId())) {
                        List<SscSchemeInviteSupExtDealPO> extDealPOS = packIdMap.get(planPackBO.getPackId());
                        planPackBO.setSupNum(extDealPOS.size());
                    } else {
                        planPackBO.setSupNum(0);
                    }
                }
            }
        }
        rspBO.setRows(selectPlanPack);
        return rspBO;
    }

    @Override
    public SscPurchaseSourcingRspBO qrySchemePackSourcing(SscPurchaseSourcingReqBO reqBO) {
        SscPurchaseSourcingRspBO rspBO = new SscPurchaseSourcingRspBO();
        List<SscProcurementSourcingBO> sscProcurementSourcingBOS = sscPlanPackMapper.qrySchemeAndPack(reqBO.getSchemeIds(), reqBO.getPackIds());
//		rspBO.setList(sscProcurementSourcingBOS);
		if(!CollectionUtils.isEmpty(sscProcurementSourcingBOS)){
			List<String> excludeAuditStatusList = new ArrayList<>();
			excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.DRAW.getCode());
			excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.APPROVING.getCode());
			excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.REJECT.getCode());
			excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.WAIT_APPROVE.getCode());
			excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.WITHDRAW.getCode());
			List<SscProcurementSourcingBO> list = new ArrayList<>();
			List<Long> strList = new ArrayList<>();
			for (SscProcurementSourcingBO bo:sscProcurementSourcingBOS) {
				if(!strList.contains(bo.getObjId())){
					list.add(bo);
					strList.add(bo.getObjId());
				}
				if (StringUtils.isEmpty(bo.getAuditStatus()) || excludeAuditStatusList.contains(bo.getAuditStatus())){
					//审批通过的才展示审批通过时间
					bo.setAuditTime(null);
				}
			}
//			List<SscProcurementSourcingBO> sscProcurementSourcingBOS1 = sscPlanPackMapper.qrySchemePack(reqBO.getPackIds());
//			if(!CollectionUtils.isEmpty(sscProcurementSourcingBOS1)){
//				for (SscProcurementSourcingBO ssc:list) {
//					for (SscProcurementSourcingBO ssc1:sscProcurementSourcingBOS1) {
//						if(ssc.getObjId().equals(ssc1.getObjId())){
//							ssc.setOrderNo(ssc1.getOrderNo());
//							ssc.setOrderCode(ssc1.getOrderCode());
//							ssc.setOrderName(ssc1.getOrderName());
//						}
//					}
//				}
//			}
            rspBO.setList(list);
        }
        return rspBO;
    }

    @Override
    public SscPurchaseSourcingRspBO qrySchemePackSourcingTime(SscPurchaseSourcingReqBO reqBO) {
        SscPurchaseSourcingRspBO rspBO = new SscPurchaseSourcingRspBO();
        List<SscProcurementSourcingBO> sscProcurementSourcingBOS = sscPlanPackMapper.qrySchemeAndPackSsc(reqBO.getSchemeIds(), reqBO.getPackIds());
//		rspBO.setList(sscProcurementSourcingBOS);
        if (!CollectionUtils.isEmpty(sscProcurementSourcingBOS)) {
            List<String> excludeAuditStatusList = new ArrayList<>();
            excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.DRAW.getCode());
            excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.APPROVING.getCode());
            excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.REJECT.getCode());
            excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.WAIT_APPROVE.getCode());
            excludeAuditStatusList.add(SscCommConstant.SchemeAuditStatus.WITHDRAW.getCode());
            List<SscProcurementSourcingBO> list = new ArrayList<>();
            List<Long> strList = new ArrayList<>();
            for (SscProcurementSourcingBO bo : sscProcurementSourcingBOS) {
                if (!strList.contains(bo.getObjId())) {
                    list.add(bo);
                    strList.add(bo.getObjId());
                }
            }
            List<SscProcurementSourcingBO> task = sscPlanPackMapper.qrySchemeAndPid(strList);
            for (SscProcurementSourcingBO sourcingBO : task){
                for (SscProcurementSourcingBO bo: list){
                    if (sourcingBO.getObjId().equals(bo.getObjId())){
                        bo.setAuditProclnstld(sourcingBO.getAuditProclnstld());
                        bo.setAuditTime(sourcingBO.getAuditTime());
                        if (StringUtils.isEmpty(bo.getAuditStatus()) || excludeAuditStatusList.contains(bo.getAuditStatus())){
                            //审批通过的才展示审批通过时间
                            bo.setAuditTime(null);
                        }
                    }
                }
            }
//			List<SscProcurementSourcingBO> sscProcurementSourcingBOS1 = sscPlanPackMapper.qrySchemePack(reqBO.getPackIds());
//			if(!CollectionUtils.isEmpty(sscProcurementSourcingBOS1)){
//				for (SscProcurementSourcingBO ssc:list) {
//					for (SscProcurementSourcingBO ssc1:sscProcurementSourcingBOS1) {
//						if(ssc.getObjId().equals(ssc1.getObjId())){
//							ssc.setOrderNo(ssc1.getOrderNo());
//							ssc.setOrderCode(ssc1.getOrderCode());
//							ssc.setOrderName(ssc1.getOrderName());
//						}
//					}
//				}
//			}
            rspBO.setList(list);
        }
        return rspBO;
    }


    @Override
    public SscPurchasingPlanArgumentRspBO qrySchemePurchasingPlanArgument(SscPurchasingPlanArgumentReqBO reqBO) {
        //参数校验
        val(reqBO);
        //返回对象
        SscPurchasingPlanArgumentRspBO sscPurchasingPlanArgumentRspBO = new SscPurchasingPlanArgumentRspBO();
        //入参对象
        SscPurchasingPlanArgumentBO sscPurchasingPlanArgumentBO = new SscPurchasingPlanArgumentBO();
        BeanUtils.copyProperties(reqBO, sscPurchasingPlanArgumentBO);
        //返回内容对象
        SscPurchasingPlanFileCodeBO sscPurchasingPlanFileCodeBO = new SscPurchasingPlanFileCodeBO();
        sscPurchasingPlanFileCodeBO.setSchemeId(reqBO.getSchemeId());
        //查询taskId
//        Long taskId = sscPlanPackMapper.qryTaskIdByschemeId(reqBO.getSchemeId());
//        sscPurchasingPlanFileCodeBO.setTaskId(taskId);
        //schemeSubmitType  isGroupApprove
        List<SscPurchasingPlanArgumentPO> fieldValueList = sscPlanPackMapper.qryFieldValue(sscPurchasingPlanArgumentBO);
        if (!CollectionUtils.isEmpty(fieldValueList)) {
            for (SscPurchasingPlanArgumentPO sscPurchasingPlanArgumentPO : fieldValueList) {
                if ("schemeSubmitType".equals(sscPurchasingPlanArgumentPO.getFieldCode())) {
                    sscPurchasingPlanFileCodeBO.setSchemeSubmitType(sscPurchasingPlanArgumentPO.getFieldValue());
                }
                if ("isGroupApprove".equals(sscPurchasingPlanArgumentPO.getFieldCode())) {
                    sscPurchasingPlanFileCodeBO.setIsGroupApprove(sscPurchasingPlanArgumentPO.getFieldValue());
                }
            }
        }
        sscPurchasingPlanArgumentRspBO.setSscPurchasingPlanFileCodeBO(sscPurchasingPlanFileCodeBO);
        sscPurchasingPlanArgumentRspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        sscPurchasingPlanArgumentRspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return sscPurchasingPlanArgumentRspBO;
    }

    private void val(SscPurchasingPlanArgumentReqBO reqBO) {
        //schemeId
        if (reqBO.getSchemeId() == null) {
            throw new ZTBusinessException("schemeId不能为空");
        }
        //schemeSubmitType
        if (StringUtils.isBlank(reqBO.getSchemeSubmitType())) {
            throw new ZTBusinessException("schemeSubmitType不能为空");
        }
        //isGroupApprove
        if (StringUtils.isBlank(reqBO.getIsGroupApprove())) {
            throw new ZTBusinessException("isGroupApprove不能为空");
        }
    }
}
