package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.repository.QrySchemeServiceRepository;
import com.tydic.dyc.ssc.repository.dao.SscSchemeMatExtMapper;
import com.tydic.dyc.ssc.repository.po.SscSchemeMatExtPO;
import com.tydic.dyc.ssc.repositoryExt.dao.PlatFormSscSchemeMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryPlanPackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMainInfoExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.tydic.dyc.ssc.repositoryExt.impl.SchemeQryPackCreateUserRepositoryImpl.SIMPLE_SCHEME_TYPE;

/**
 * @Author jmrg
 * @dATE 2023/7/25
 * @Desc
 */
@Slf4j
@Service
public class QrySchemeServiceRepositoryImpl implements QrySchemeServiceRepository {

    @Autowired
    private PlatFormSscSchemeMapper sscSchemeMapper;

    @Autowired
    private SscSchemeMatExtMapper sscSchemeMatExtMapper;

    private final String PLAN_TYPE="planType";
    /**
     * 是否是简易采购计划  1为是0为否
     */
    private final String IS_JY_Y="1";

    /**
     * 是否是简易采购计划  1为是0为否
     */
    private final String IS_JY_N="0";

    @Override
    public List<SscQryPlanPackBO> listByParam(SscQrySchemeMainInfoExtBO param) {
        List<SscQryPlanPackBO> dateList=new ArrayList<>();
        List<SscQryPlanPackBO> packBOListCreate = converterList(sscSchemeMapper.listByParamLimitCreateTime(param));
        List<SscQryPlanPackBO> packBOListUpdate = converterList(sscSchemeMapper.listByParamLimitUpdateTime(param));
        dateList.addAll(packBOListCreate);
        dateList.addAll(packBOListUpdate);
        dateList = dateList.stream()
                .distinct()
                .collect(Collectors.toList());

        return dateList;
    }

    @Override
    public List<SscSchemeBO> getDataByParam(SscQrySchemeMainInfoExtBO inparam) {
        List<SscSchemeBO> boList=new ArrayList<>();
        List<SscSchemePO> dataByParam=new ArrayList<>();
        //根据时间范围进行数据查询
        List<SscSchemePO> dataByParamCreate = sscSchemeMapper.getDataByParamCreate(inparam);
        List<SscSchemePO> dataByParamUpdate = sscSchemeMapper.getDataByParamUpdate(inparam);
        dataByParam.addAll(dataByParamCreate);
        dataByParam.addAll(dataByParamUpdate);
        //因为这里两个查询会有重复的数据，需要进行去重操作
        dataByParam = dataByParam.stream()
                .distinct()
                .collect(Collectors.toList());
        //转换数据  这里转换的时候需要将  计划类型放入数据中
        if (!CollectionUtils.isEmpty(dataByParam)){
            for (SscSchemePO sscSchemePO : dataByParam) {
                //设置计划类型
                SscSchemeBO sscSchemeBO=new SscSchemeBO();
                BeanUtils.copyProperties(sscSchemePO,sscSchemeBO);
                boList.add(sscSchemeBO);
            }
        }
        return boList;
    }

    /**
     * 设置计划类型
     * @param sscSchemePO
     */
    private void dealData(SscSchemePO sscSchemePO){
        SscSchemeMatExtPO sscSchemeMatExtPO=new SscSchemeMatExtPO();
        sscSchemeMatExtPO.setSchemeId(sscSchemePO.getSchemeId());
        sscSchemeMatExtPO.setSchemeMatId(sscSchemePO.getSchemeMatId());
        sscSchemeMatExtPO.setFieldCode(PLAN_TYPE);
        SscSchemeMatExtPO modelBy = sscSchemeMatExtMapper.getModelBy(sscSchemeMatExtPO);
        log.info("查询出的拓展信息modelBy为:{}"+ JSON.toJSONString(modelBy));
        if (modelBy!=null){
            sscSchemePO.setFieldValue(modelBy.getFieldValue());
            sscSchemePO.setFieldName(modelBy.getFieldName());
        }
    }

    private List<SscQryPlanPackBO> converterList(List<SscSchemePO> list){
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        List<SscQryPlanPackBO> resultList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            SscSchemePO sscSchemePO = list.get(i);
            SscQryPlanPackBO sscQryPlanPackBO = new SscQryPlanPackBO();
            BeanUtils.copyProperties(sscSchemePO,sscQryPlanPackBO);
            sscQryPlanPackBO.setSchemeClass(Objects.isNull(sscSchemePO.getSchemeClass())?null:sscSchemePO.getSchemeClass().toString());
            sscQryPlanPackBO.setCreateCompanCode(sscSchemePO.getCreateCompanyCode());
            sscQryPlanPackBO.setEmergencyFlag(Objects.isNull(sscSchemePO.getEmergencyFlag())?null:sscSchemePO.getEmergencyFlag().toString());
            sscQryPlanPackBO.setEstAmount(Objects.isNull(sscSchemePO.getEstAmount())?null:sscSchemePO.getEstAmount().toString());
            sscQryPlanPackBO.setImportFlag(Objects.isNull(sscSchemePO.getImportFlag())?null:sscSchemePO.getImportFlag().toString());
            sscQryPlanPackBO.setPurchaseType(Objects.isNull(sscSchemePO.getPurchaseType())?null:sscSchemePO.getPurchaseType().toString());
            if (SIMPLE_SCHEME_TYPE.toString().equals(sscSchemePO.getSchemeType())){
                sscQryPlanPackBO.setIsJY(IS_JY_Y);
            }else {
                sscQryPlanPackBO.setIsJY(IS_JY_N);
            }

            resultList.add(sscQryPlanPackBO);
        }
        return resultList;
    }
}
