package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.ssc.repository.SscMsgFailLogExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SscMsgFailLogMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscMsgFailLogPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscMsgFailLogExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscMsgFailLogExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscMsgFailLogExtRspBO;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2024/7/9 下午4:27
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class SscMsgFailLogExtRepositoryImpl implements SscMsgFailLogExtRepository {
    @Autowired
    private SscMsgFailLogMapper sscMsgFailLogMapper;
    /**
     * 最大失败重试次数
     */
    private static final Integer maxFailRetryTimes = 5;
    @Override
    public SscMsgFailLogExtRspBO addFailLog(SscMsgFailLogExtReqBO reqBO) {
        SscMsgFailLogExtRspBO rspBO = new SscMsgFailLogExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        if (reqBO.getAddExtBO()!=null && !StringUtils.isEmpty(reqBO.getAddExtBO().getLogMsg())){
            SscMsgFailLogPO addPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO.getAddExtBO()), SscMsgFailLogPO.class);
            sscMsgFailLogMapper.insert(addPO);
        }
        return rspBO;
    }

    @Override
    public SscMsgFailLogExtRspBO qryFailLog(SscMsgFailLogExtReqBO reqBO) {
        SscMsgFailLogExtRspBO rspBO = new SscMsgFailLogExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        //只查询失败状态的数据，并且重试最大次数要小于6
        List<SscMsgFailLogPO> sscMsgFailLogPOS = sscMsgFailLogMapper.selectFailLogs(maxFailRetryTimes);
        if (!CollectionUtils.isEmpty(sscMsgFailLogPOS)){
            List<SscMsgFailLogExtBO> failLogExtBOS = JSONObject.parseArray(JSONObject.toJSONString(sscMsgFailLogPOS), SscMsgFailLogExtBO.class);
            rspBO.setFailLogExtBOS(failLogExtBOS);
        }
        return rspBO;
    }

    @Override
    public SscMsgFailLogExtRspBO updateFailLog(SscMsgFailLogExtReqBO reqBO) {
        SscMsgFailLogExtRspBO rspBO = new SscMsgFailLogExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        if (reqBO.getUpdateExtBO()!=null && reqBO.getUpdateExtBO().getLogId()!=null){
            SscMsgFailLogPO updatePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO.getUpdateExtBO()), SscMsgFailLogPO.class);
            sscMsgFailLogMapper.updateByPrimaryKeySelective(updatePO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getLogIds()) && reqBO.getLogStatus()!=null){
            sscMsgFailLogMapper.updateLogStatus(reqBO.getLogIds(),reqBO.getLogStatus());
        }
        return rspBO;
    }
}
