package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.ssc.repository.SscOrderAuditFailLogExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SscMsgFailLogMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscOrderAuditFailLogMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscMsgFailLogPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscOrderAuditFailLogPO;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2024/7/10 下午5:06
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class SscOrderAuditFailLogExtRepositoryImpl implements SscOrderAuditFailLogExtRepository {
    @Autowired
    private SscOrderAuditFailLogMapper sscOrderAuditFailLogMapper;
    /**
     * 最大失败重试次数
     */
    private static final Integer maxFailRetryTimes = 5;
    @Override
    public SscOrderAuditFailLogExtRspBO addFailLog(SscOrderAuditFailLogExtReqBO reqBO) {
        SscOrderAuditFailLogExtRspBO rspBO = new SscOrderAuditFailLogExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        if (reqBO.getAddExtBO()!=null
                && !StringUtils.isEmpty(reqBO.getAddExtBO().getLogReqMsg())
                && !StringUtils.isEmpty(reqBO.getAddExtBO().getLogAuditInfoMsg())
                && !StringUtils.isEmpty(reqBO.getAddExtBO().getLogFlowRspMsg())
                && !StringUtils.isEmpty(reqBO.getAddExtBO().getLogSchemeInfoMsg())
        ){
            SscOrderAuditFailLogPO addPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO.getAddExtBO()), SscOrderAuditFailLogPO.class);
            sscOrderAuditFailLogMapper.insert(addPO);
        }
        return rspBO;
    }

    @Override
    public SscOrderAuditFailLogExtRspBO qryFailLog(SscOrderAuditFailLogExtReqBO reqBO) {
        SscOrderAuditFailLogExtRspBO rspBO = new SscOrderAuditFailLogExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        //只查询失败状态的数据，并且重试最大次数要小于6
        List<SscOrderAuditFailLogPO> sscMsgFailLogPOS = sscOrderAuditFailLogMapper.selectFailLogs(maxFailRetryTimes);
        if (!CollectionUtils.isEmpty(sscMsgFailLogPOS)){
            List<SscOrderAuditFailLogExtBO> failLogExtBOS = JSONObject.parseArray(JSONObject.toJSONString(sscMsgFailLogPOS), SscOrderAuditFailLogExtBO.class);
            rspBO.setFailLogExtBOS(failLogExtBOS);
        }
        return rspBO;
    }

    @Override
    public SscOrderAuditFailLogExtRspBO updateFailLog(SscOrderAuditFailLogExtReqBO reqBO) {
        SscOrderAuditFailLogExtRspBO rspBO = new SscOrderAuditFailLogExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        if (reqBO.getUpdateExtBO()!=null && reqBO.getUpdateExtBO().getLogId()!=null){
            SscOrderAuditFailLogPO updatePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO.getUpdateExtBO()), SscOrderAuditFailLogPO.class);
            sscOrderAuditFailLogMapper.updateByPrimaryKeySelective(updatePO);
        }
        if (!CollectionUtils.isEmpty(reqBO.getLogIds()) && reqBO.getLogStatus()!=null){
            sscOrderAuditFailLogMapper.updateLogStatus(reqBO.getLogIds(),reqBO.getLogStatus());
        }
        return rspBO;
    }
}
