package com.tydic.dyc.ssc.repositoryExt.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.ssc.model.SscSchemeMatPackExtModel;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeIdListService;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemePackExtModel;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题 SscQrySchemeIdListServiceImpl
 * 说明 查询方案id集合
 * 时间 2024/9/10 16:55
 *
 * @author 唐富强
 */
@HTServiceImpl
public class SscQrySchemeIdListServiceImpl implements SscQrySchemeIdListService {

    @Resource
    private SscQrySchemePackExtModel sscQrySchemePackExtModel;


    @Override
    public SscQrySchemeIdListRspBo qrySchemeIdList(SscQrySchemeIdListReqBo reqBo) {
        //参数验证
        checkParam(reqBo);
        SscQrySchemeIdListRspBo rspBo = new SscQrySchemeIdListRspBo();
        rspBo.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBo.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        //防止前端无参跳转
        if(CollectionUtils.isEmpty(reqBo.getPackIdList())){
            rspBo.setSchemeIdList(Collections.singletonList(-1L));
        }
        rspBo.setSchemeIdList(getSchemeIdList(reqBo));
        return rspBo;
    }

    /**
     * 获取方案id集合
     * @param reqBo
     * @return
     */
    private List<Long> getSchemeIdList(SscQrySchemeIdListReqBo reqBo){
        SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
        sscQrySchemePackExtReqBO.setPackIds(reqBo.getPackIdList());
        SscQrySchemePackExtRspBO sscQrySchemePackExtRspBO = sscQrySchemePackExtModel.qryPackByPackIds(sscQrySchemePackExtReqBO);
        if(CollectionUtils.isEmpty(sscQrySchemePackExtRspBO.getBos())){
            //防止前端无结果跳转
            return Collections.singletonList(-1L);
        }else {
            Set<Long> collect = sscQrySchemePackExtRspBO.getBos().stream().map(SscQrySchemePackExtBO::getSchemeId).collect(Collectors.toSet());
            return new ArrayList<>(collect);
        }
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void checkParam(SscQrySchemeIdListReqBo reqBo){
        if(reqBo == null){
            throw new ZTBusinessException("入参不能为空");
        }
//        if(CollectionUtils.isEmpty(reqBo.getPackIdList())){
//            throw new ZTBusinessException("入参包id集合不能为空");
//        }
    }
}
